/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CUDACapability;
import com.supermap.data.Charset;
import com.supermap.data.EngineFamilyType;
import com.supermap.data.EngineInfo;
import com.supermap.data.EngineType;
import com.supermap.data.Enum;
import com.supermap.data.EnvironmentNative;
import com.supermap.data.InternalResource;
import com.supermap.data.LibraryBinPath;
import com.supermap.data.ObjectsRuntimeException;
import com.supermap.data.OpenCLCapability;
import com.supermap.data.Toolkit;
import com.supermap.data.WorkspaceNative;
import java.awt.Canvas;
import java.util.ArrayList;
import java.util.Locale;

public class Environment {
    public static final double DEFAULT_MAX_EQUAL_ZERO_PRECISION = 1.0E-10;
    public static final double DEFAULT_MIN_EQUAL_ZERO_PRECISION = -1.0E-10;
    private static double maxEqualZeroPrecision = 1.0E-10;
    private static double minEqualZeroPrecision = -1.0E-10;
    private static boolean isWrapJLoaded = false;
    private static String binPath = "";

    protected Environment() {
    }

    public static double getMaxEqualZeroPrecision() {
        return maxEqualZeroPrecision;
    }

    public static void setMaxEqualZeroPrecision(double value) {
        maxEqualZeroPrecision = value;
    }

    public static double getMinEqualZeroPrecision() {
        return minEqualZeroPrecision;
    }

    public static void setMinEqualZeroPrecision(double value) {
        minEqualZeroPrecision = value;
    }

    public static String getFileCacheFolder() {
        return EnvironmentNative.jni_GetFileCacheFolder();
    }

    public static void setFileCacheFolder(String value) {
        if (value == null) {
            value = "";
        }
        EnvironmentNative.jni_SetFileCacheFolder(value);
    }

    @Deprecated
    public static boolean isCustomMapRatioEnabled() {
        return EnvironmentNative.jni_GetCustomMapRatioEnabled();
    }

    @Deprecated
    public static void setCustomMapRatioEnabled(boolean value) {
        EnvironmentNative.jni_SetCustomMapRatioEnabled(value);
    }

    public static void setCustomDPIEnabled(boolean value) {
        EnvironmentNative.jni_SetCustomDPIEnabled(value);
    }

    public static boolean isCustomDPIEnabled() {
        return EnvironmentNative.jni_GetCustomDPIEnabled();
    }

    public static double getSystemDPI() {
        return EnvironmentNative.jni_GetSystemDPI();
    }

    public static void setSystemDPI(double value) {
        EnvironmentNative.jni_SetSystemDPI(value);
    }

    @Deprecated
    public static boolean isClearTypeSupported() {
        return false;
    }

    @Deprecated
    public static void setClearTypeSupported(boolean value) {
    }

    @Deprecated
    public static double getCustomMapRatioX() {
        return EnvironmentNative.jni_GetCustomMapRatioX();
    }

    @Deprecated
    public static void setCustomMapRatioX(double value) {
        EnvironmentNative.jni_SetCustomMapRatioX(value);
    }

    @Deprecated
    public static double getCustomMapRatioY() {
        return EnvironmentNative.jni_GetCustomMapRatioY();
    }

    @Deprecated
    public static void setCustomMapRatioY(double value) {
        EnvironmentNative.jni_SetCustomMapRatioY(value);
    }

    public static double getCustomDPIX() {
        return EnvironmentNative.jni_GetCustomDPIX();
    }

    public static void setCustomDPIX(double value) {
        EnvironmentNative.jni_SetCustomDPIX(value);
    }

    public static double getCustomDPIY() {
        return EnvironmentNative.jni_GetCustomDPIY();
    }

    public static void setCustomDPIY(double value) {
        EnvironmentNative.jni_SetCustomDPIY(value);
    }

    public static boolean isUnicodeVersion() {
        return EnvironmentNative.jni_IsUnicodeVersion();
    }

    public static EngineInfo[] getCurrentLoadedEngineInfos() {
        int n = EnvironmentNative.jni_GetCurrentLoadedEngineCount();
        ArrayList<EngineInfo> arrayList = new ArrayList<EngineInfo>();
        int[] nArray = new int[n];
        EnvironmentNative.jni_GetCurrentLoadedEngine(nArray);
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == 1001 || nArray[i] == 226) continue;
            try {
                EngineType engineType = (EngineType)Enum.parseUGCValue(EngineType.class, nArray[i]);
                String string = EnvironmentNative.jni_GetSupportExtenstions(i);
                String[] stringArray = Toolkit.splitString(string, ";");
                String string2 = EnvironmentNative.jni_GetEngineName(i);
                int n2 = EnvironmentNative.jni_GetEngienFamilyType(i);
                EngineFamilyType engineFamilyType = (EngineFamilyType)Enum.parseUGCValue(EngineFamilyType.class, n2);
                EngineInfo engineInfo = new EngineInfo(engineType, stringArray, string2, engineFamilyType);
                arrayList.add(engineInfo);
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        EngineInfo[] engineInfoArray = new EngineInfo[arrayList.size()];
        return arrayList.toArray(engineInfoArray);
    }

    public static EngineType[] getCurrentLoadedEngine() {
        int n;
        Environment.LoadWrapJ();
        int n2 = EnvironmentNative.jni_GetCurrentLoadedEngineCount();
        ArrayList<EngineType> arrayList = new ArrayList<EngineType>();
        int[] nArray = new int[n2];
        EnvironmentNative.jni_GetCurrentLoadedEngine(nArray);
        for (n = 0; n < n2; ++n) {
            if (nArray[n] == 1001 || nArray[n] == 226) continue;
            if (nArray[n] == 221) {
                arrayList.add(EngineType.HIGHGODB);
            }
            try {
                arrayList.add((EngineType)Enum.parseUGCValue(EngineType.class, nArray[n]));
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        n = arrayList.size();
        EngineType[] engineTypeArray = new EngineType[n];
        for (int i = 0; i < n; ++i) {
            engineTypeArray[i] = (EngineType)arrayList.get(i);
        }
        return engineTypeArray;
    }

    public static Charset getCurrentCharset() {
        int n = EnvironmentNative.jni_GetCurrentCharset();
        return (Charset)Enum.parse(Charset.class, n);
    }

    public static void setCurrentCharset(Charset charset) {
        if (charset == null) {
            String string = InternalResource.loadString("charset", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        EnvironmentNative.jni_SetCurrentCharset(charset.value());
    }

    public static void LoadWrapJ() {
        if (!isWrapJLoaded) {
            String string = System.getProperty("os.name").toLowerCase();
            try {
                new Canvas();
                boolean bl = true;
                if (string.startsWith("linux")) {
                    String string2 = binPath;
                    if (!string2.isEmpty()) {
                        if (!string2.endsWith("/")) {
                            string2 = string2 + "/";
                        }
                        bl = false;
                        Environment.load(string2 + "libSuBase.so");
                        Environment.load(string2 + "libWrapjCore.so");
                        Environment.load(string2 + "libWrapjAnalyst.so");
                        Environment.load(string2 + "libWrapjChart.so");
                        Environment.load(string2 + "libWrapjNav.so");
                        Environment.load(string2 + "libWrapjMapping.so");
                        Environment.load(string2 + "libWrapjPlot.so");
                        Environment.load(string2 + "libWrapjMObjects.so");
                        Environment.load(string2 + "libWrapjRealspace.so");
                    } else {
                        Environment.loadLibrary("SuBase");
                    }
                }
                if (bl) {
                    Environment.loadLibrary("WrapjCore");
                    Environment.loadLibrary("WrapjAnalyst");
                    Environment.loadLibrary("WrapjChart");
                    Environment.loadLibrary("WrapjNav");
                    Environment.loadLibrary("WrapjMapping");
                    Environment.loadLibrary("WrapjPlot");
                    Environment.loadLibrary("WrapjMObjects");
                    Environment.loadLibrary("WrapjRealspace");
                }
                EnvironmentNative.jni_InitEnvironment();
                WorkspaceNative.jni_InitPlugins();
                isWrapJLoaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void loadLibrary(String wrapjName) {
        try {
            System.loadLibrary(wrapjName);
        }
        catch (Throwable throwable) {
            System.out.println("an exception caught at Environment.loadLibrary(), program will continue running.");
            throwable.printStackTrace();
        }
    }

    private static void load(String wrapjName) {
        try {
            System.load(wrapjName);
        }
        catch (Throwable throwable) {
            System.out.println("an exception caught at Environment.load(), program will continue running.");
            throwable.printStackTrace();
        }
    }

    protected static void InternalLoadWrapJ() {
        Environment.LoadWrapJ();
    }

    public static int getOMPNumThreads() {
        return EnvironmentNative.jni_GetOMPNumThreads();
    }

    public static void setOMPNumThreads(int value) {
        if (value <= 0) {
            String string = InternalResource.loadString("OMPNumThreads", "OMPNumThreads_CannotLessOrEqualsZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (value > 256) {
            String string = InternalResource.loadString("OMPNumThreads", "OMPNumThreads_OutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        EnvironmentNative.jni_SetOMPNumThreads(value, true);
    }

    public static void setOMPNumThreads(int value, boolean isSaveToXml) {
        if (value <= 0) {
            String string = InternalResource.loadString("OMPNumThreads", "OMPNumThreads_CannotLessOrEqualsZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (value > 256) {
            String string = InternalResource.loadString("OMPNumThreads", "OMPNumThreads_OutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        EnvironmentNative.jni_SetOMPNumThreads(value, isSaveToXml);
    }

    public static int getSceneAntialiasValue() {
        return EnvironmentNative.jni_GetSceneAntialiasValue();
    }

    public static void setSceneAntialiasValue(int value) {
        EnvironmentNative.jni_SetSceneAntialiasValue(value);
    }

    public static void setSceneAntialias(boolean value) {
        EnvironmentNative.jni_SetSceneAntialias(value);
    }

    public static boolean isSceneAntialias() {
        return EnvironmentNative.jni_IsSceneAntialias();
    }

    public static long getAnalystMemorySize() {
        return EnvironmentNative.jni_GetAnalystMemorySize();
    }

    public static void setAnalystMemorySize(long value) {
        boolean bl = EnvironmentNative.jni_SetAnalystMemorySize(value);
        if (!bl) {
            String string = InternalResource.loadString("AnalystMemorySize", "SettingAnalystMemorySizeFailed", "data_resources");
            throw new ObjectsRuntimeException(string);
        }
    }

    public static void setMapInflated(boolean value) {
        EnvironmentNative.jni_SetMapInflated(value);
    }

    public static boolean isMapInflated() {
        return EnvironmentNative.jni_IsMapInflated();
    }

    public static String getUGOBasePath() {
        return EnvironmentNative.jni_GetBasePath();
    }

    public static void setCUDAComputingEnabled(boolean value) {
        EnvironmentNative.jni_SetCUDAComputingEnabled(value);
    }

    public static boolean isCUDAComputingEnabled() {
        return EnvironmentNative.jni_IsCUDAComputingEnabled();
    }

    public static CUDACapability checkCUDACapability() {
        int n = EnvironmentNative.jni_CheckCUDACapability();
        return (CUDACapability)Enum.parseUGCValue(CUDACapability.class, n);
    }

    public static void setOpenCLComputingEnabled(boolean value) {
        EnvironmentNative.jni_SetOpenCLComputingEnabled(value);
    }

    public static boolean isOpenCLComputingEnabled() {
        return EnvironmentNative.jni_IsOpenCLComputingEnabled();
    }

    public static OpenCLCapability checkOpenCLCapability() {
        int n = EnvironmentNative.jni_CheckOpenCLCapability();
        return (OpenCLCapability)Enum.parseUGCValue(OpenCLCapability.class, n);
    }

    public static void SetTileLayerBufferSize(int size) {
        EnvironmentNative.jni_SetTileLayerBufferSize(size);
    }

    public static int GetTileLayerBufferSize() {
        return EnvironmentNative.jni_GetTileLayerBufferSize();
    }

    public static void SetTileLayerDownLoadThreadCount(int size) {
        EnvironmentNative.jni_SetTileLayerDownLoadThreadCount(size);
    }

    public static int GetTileLayerDownLoadThreadCount() {
        return EnvironmentNative.jni_GetTileLayerDownLoadThreadCount();
    }

    public static void setMaxStdIO(int value) {
        EnvironmentNative.jni_SetMaxStdIO(value);
    }

    public static int getMaxStdIO() {
        return EnvironmentNative.jni_GetMaxStdIO();
    }

    public static void setCurrentCulture(String value) {
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        EnvironmentNative.jni_SetCurrentCulture(value);
        String[] stringArray = value.split("-");
        if (stringArray.length == 2) {
            Locale.setDefault(new Locale(stringArray[0], stringArray[1]));
        }
    }

    public static String getCurrentCulture() {
        return EnvironmentNative.jni_GetCurrentCulture();
    }

    public static boolean isHardwareAccelerationEnable() {
        return EnvironmentNative.jni_IsHardwareAccelerationEnable();
    }

    public static void setHardwareAccelerationEnable(boolean value) {
        EnvironmentNative.jni_SetHardwareAccelerationEnable(value);
    }

    public static boolean isOneLogFilePerProcess() {
        return EnvironmentNative.jni_IsOneLogFilePerProcess();
    }

    public static void setOneLogFilePerProcess(boolean value) {
        EnvironmentNative.jni_SetOneLogFilePerProcess(value);
    }

    public static String getElementValue(String name) {
        return EnvironmentNative.jni_GetElementValue(name);
    }

    public static void setElementValue(String name, String value) {
        EnvironmentNative.jni_SetElementValue(name, value);
    }

    static {
        binPath = LibraryBinPath.getBinPath();
        Environment.LoadWrapJ();
        if (isWrapJLoaded) {
            String string = Environment.getCurrentCulture();
            if (string.isEmpty() || string.equalsIgnoreCase("system")) {
                String string2 = Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry();
                EnvironmentNative.jni_SetCurrentCulture(string2);
            } else {
                Environment.setCurrentCulture(string);
            }
        }
    }
}

