# coding: utf-8

"""
    Yagna Activity API

    It conforms with capability level 1 of the [Activity API specification](https://docs.google.com/document/d/1BXaN32ediXdBHljEApmznSfbuudTU8TmvOmHKl0gmQM).  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ya_activity.configuration import Configuration


class ActivityState(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'state': 'list[str]',
        'reason': 'str',
        'error_message': 'str'
    }

    attribute_map = {
        'state': 'state',
        'reason': 'reason',
        'error_message': 'errorMessage'
    }

    def __init__(self, state=None, reason=None, error_message=None, local_vars_configuration=None):  # noqa: E501
        """ActivityState - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._state = None
        self._reason = None
        self._error_message = None
        self.discriminator = None

        self.state = state
        if reason is not None:
            self.reason = reason
        if error_message is not None:
            self.error_message = error_message

    @property
    def state(self):
        """Gets the state of this ActivityState.  # noqa: E501

        State pair tuple (CurrentState, NextState). NextState is equal to null if there is no pending transition between states.  # noqa: E501

        :return: The state of this ActivityState.  # noqa: E501
        :rtype: list[str]
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this ActivityState.

        State pair tuple (CurrentState, NextState). NextState is equal to null if there is no pending transition between states.  # noqa: E501

        :param state: The state of this ActivityState.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and state is None:  # noqa: E501
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501
        allowed_values = ["New", "Initialized", "Deployed", "Ready", "Unresponsive", "Terminated"]  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                not set(state).issubset(set(allowed_values))):  # noqa: E501
            raise ValueError(
                "Invalid values for `state` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(state) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._state = state

    @property
    def reason(self):
        """Gets the reason of this ActivityState.  # noqa: E501

        Reason for Activity termination (specified when Activity in Terminated state).  # noqa: E501

        :return: The reason of this ActivityState.  # noqa: E501
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """Sets the reason of this ActivityState.

        Reason for Activity termination (specified when Activity in Terminated state).  # noqa: E501

        :param reason: The reason of this ActivityState.  # noqa: E501
        :type: str
        """

        self._reason = reason

    @property
    def error_message(self):
        """Gets the error_message of this ActivityState.  # noqa: E501

        If error caused state change - error message shall be provided.  # noqa: E501

        :return: The error_message of this ActivityState.  # noqa: E501
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """Sets the error_message of this ActivityState.

        If error caused state change - error message shall be provided.  # noqa: E501

        :param error_message: The error_message of this ActivityState.  # noqa: E501
        :type: str
        """

        self._error_message = error_message

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ActivityState):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ActivityState):
            return True

        return self.to_dict() != other.to_dict()
