# coding: utf-8

"""
    Yagna Activity API

    It conforms with capability level 1 of the [Activity API specification](https://docs.google.com/document/d/1BXaN32ediXdBHljEApmznSfbuudTU8TmvOmHKl0gmQM).  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ya_activity.api_client import ApiClient
from ya_activity.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ProviderApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def collect_activity_events(self, **kwargs):  # noqa: E501
        """Fetch Requestor command events.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.collect_activity_events(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float timeout: How many seconds server should wait for new events (0.0 means it should return immediately if there are no events) 
        :param int max_events: Maximum number of events that server should return at once (empty value means no limit). 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[OneOfCreateActivityDestroyActivityGetActivityStateGetActivityUsage]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.collect_activity_events_with_http_info(**kwargs)  # noqa: E501

    def collect_activity_events_with_http_info(self, **kwargs):  # noqa: E501
        """Fetch Requestor command events.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.collect_activity_events_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float timeout: How many seconds server should wait for new events (0.0 means it should return immediately if there are no events) 
        :param int max_events: Maximum number of events that server should return at once (empty value means no limit). 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[OneOfCreateActivityDestroyActivityGetActivityStateGetActivityUsage], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'timeout',
            'max_events'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method collect_activity_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'timeout' in local_var_params and local_var_params['timeout'] < 0.0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `timeout` when calling `collect_activity_events`, must be a value greater than or equal to `0.0`")  # noqa: E501
        if self.api_client.client_side_validation and 'max_events' in local_var_params and local_var_params['max_events'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_events` when calling `collect_activity_events`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'max_events' in local_var_params and local_var_params['max_events'] is not None:  # noqa: E501
            query_params.append(('maxEvents', local_var_params['max_events']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OneOfCreateActivityDestroyActivityGetActivityStateGetActivityUsage]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activity_state(self, activity_id, **kwargs):  # noqa: E501
        """Get state of specified Activity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_state(activity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str activity_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ActivityState
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_activity_state_with_http_info(activity_id, **kwargs)  # noqa: E501

    def get_activity_state_with_http_info(self, activity_id, **kwargs):  # noqa: E501
        """Get state of specified Activity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_state_with_http_info(activity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str activity_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ActivityState, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'activity_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activity_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'activity_id' is set
        if self.api_client.client_side_validation and ('activity_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['activity_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `activity_id` when calling `get_activity_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_id' in local_var_params:
            path_params['activityId'] = local_var_params['activity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/activity/{activityId}/state', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityState',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activity_usage(self, activity_id, **kwargs):  # noqa: E501
        """Get usage of specified Activity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_usage(activity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str activity_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[float]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_activity_usage_with_http_info(activity_id, **kwargs)  # noqa: E501

    def get_activity_usage_with_http_info(self, activity_id, **kwargs):  # noqa: E501
        """Get usage of specified Activity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_usage_with_http_info(activity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str activity_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[float], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'activity_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activity_usage" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'activity_id' is set
        if self.api_client.client_side_validation and ('activity_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['activity_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `activity_id` when calling `get_activity_usage`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_id' in local_var_params:
            path_params['activityId'] = local_var_params['activity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/activity/{activityId}/usage', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[float]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_activity_state(self, activity_id, activity_state, **kwargs):  # noqa: E501
        """Set state of specified Activity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_activity_state(activity_id, activity_state, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str activity_id: (required)
        :param ActivityState activity_state: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_activity_state_with_http_info(activity_id, activity_state, **kwargs)  # noqa: E501

    def set_activity_state_with_http_info(self, activity_id, activity_state, **kwargs):  # noqa: E501
        """Set state of specified Activity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_activity_state_with_http_info(activity_id, activity_state, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str activity_id: (required)
        :param ActivityState activity_state: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'activity_id',
            'activity_state'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_activity_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'activity_id' is set
        if self.api_client.client_side_validation and ('activity_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['activity_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `activity_id` when calling `set_activity_state`")  # noqa: E501
        # verify the required parameter 'activity_state' is set
        if self.api_client.client_side_validation and ('activity_state' not in local_var_params or  # noqa: E501
                                                        local_var_params['activity_state'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `activity_state` when calling `set_activity_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_id' in local_var_params:
            path_params['activityId'] = local_var_params['activity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'activity_state' in local_var_params:
            body_params = local_var_params['activity_state']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/activity/{activityId}/state', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
