# ya-activity
It conforms with capability level 1 of the [Activity API specification](https://docs.google.com/document/d/1BXaN32ediXdBHljEApmznSfbuudTU8TmvOmHKl0gmQM).

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v1
- Package version: 
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/prekucki/ya-client-python-activity.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/prekucki/ya-client-python-activity.git`)

Then import the package:
```python
import ya_activity
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import ya_activity
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import ya_activity
from ya_activity.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/activity-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = ya_activity.Configuration(
    host = "http://localhost/activity-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: app_key
configuration = ya_activity.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with ya_activity.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = ya_activity.ProviderApi(api_client)
    timeout = 3.4 # float | How many seconds server should wait for new events (0.0 means it should return immediately if there are no events)  (optional)
max_events = 56 # int | Maximum number of events that server should return at once (empty value means no limit).  (optional)

    try:
        # Fetch Requestor command events.
        api_response = api_instance.collect_activity_events(timeout=timeout, max_events=max_events)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ProviderApi->collect_activity_events: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/activity-api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ProviderApi* | [**collect_activity_events**](docs/ProviderApi.md#collect_activity_events) | **GET** /events | Fetch Requestor command events.
*ProviderApi* | [**get_activity_state**](docs/ProviderApi.md#get_activity_state) | **GET** /activity/{activityId}/state | Get state of specified Activity.
*ProviderApi* | [**get_activity_usage**](docs/ProviderApi.md#get_activity_usage) | **GET** /activity/{activityId}/usage | Get usage of specified Activity.
*ProviderApi* | [**set_activity_state**](docs/ProviderApi.md#set_activity_state) | **PUT** /activity/{activityId}/state | Set state of specified Activity.
*RequestorControlApi* | [**call_exec**](docs/RequestorControlApi.md#call_exec) | **POST** /activity/{activityId}/exec | Executes an ExeScript batch within a given Activity.
*RequestorControlApi* | [**create_activity**](docs/RequestorControlApi.md#create_activity) | **POST** /activity | Creates new Activity based on given Agreement.
*RequestorControlApi* | [**destroy_activity**](docs/RequestorControlApi.md#destroy_activity) | **DELETE** /activity/{activityId} | Destroys given Activity.
*RequestorControlApi* | [**get_exec_batch_results**](docs/RequestorControlApi.md#get_exec_batch_results) | **GET** /activity/{activityId}/exec/{batchId} | Queries for ExeScript batch results.
*RequestorStateApi* | [**get_activity_state**](docs/RequestorStateApi.md#get_activity_state) | **GET** /activity/{activityId}/state | Get state of specified Activity.
*RequestorStateApi* | [**get_activity_usage**](docs/RequestorStateApi.md#get_activity_usage) | **GET** /activity/{activityId}/usage | Get usage of specified Activity.
*RequestorStateApi* | [**get_running_command**](docs/RequestorStateApi.md#get_running_command) | **GET** /activity/{activityId}/command | Get running command for a specified Activity.


## Documentation For Models

 - [ActivityState](docs/ActivityState.md)
 - [ActivityUsage](docs/ActivityUsage.md)
 - [CreateActivity](docs/CreateActivity.md)
 - [CreateActivityAllOf](docs/CreateActivityAllOf.md)
 - [DestroyActivity](docs/DestroyActivity.md)
 - [ErrorMessage](docs/ErrorMessage.md)
 - [ExeScriptCommandResult](docs/ExeScriptCommandResult.md)
 - [ExeScriptCommandState](docs/ExeScriptCommandState.md)
 - [ExeScriptRequest](docs/ExeScriptRequest.md)
 - [GetActivityState](docs/GetActivityState.md)
 - [GetActivityUsage](docs/GetActivityUsage.md)
 - [ProviderEvent](docs/ProviderEvent.md)


## Documentation For Authorization


## app_key

- **Type**: Bearer authentication


## Author




