# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_repr_rgb.ipynb.

# %% auto 0
__all__ = ['rgb']

# %% ../nbs/01_repr_rgb.ipynb 3
from PIL import Image
import torch

# %% ../nbs/01_repr_rgb.ipynb 4
# This is here for the monkey-patched tensor use case.

# I want to be able to call both `tensor.rgb` and `tensor.rgb(stats)`. For the
# first case, the class defines `_repr_png_` to send the image to Jupyter. For
# the later case, it defines __call__, which accps the argument.

class ImageProxy(Image.Image):
    """Flexible `PIL.Image.Image` wrapper"""
    @torch.no_grad()
    def __init__(self, t:torch.Tensor):
        super().__init__()
        self.t = t.detach().permute(1, 2, 0)
        
        # Mode and size - to be used by super().__repr__()
        self.mode = "RGB"
        self._size = tuple(t.shape[1:])

    @torch.no_grad()
    def __call__(self, denorm=None):            
        means = torch.tensor(denorm["mean"] if denorm else (0., 0., 0.,), device=self.t.device)
        stds = torch.tensor(denorm["std"] if denorm else (1., 1., 1.,), device=self.t.device)
        return Image.fromarray((self.t*stds+means).mul(255).byte().cpu().numpy())

    @torch.no_grad()
    def _repr_png_(self):
        "Jupyter PNG representation"
        return Image.fromarray(self.t.mul(255).byte().cpu().numpy())._repr_png_()


# %% ../nbs/01_repr_rgb.ipynb 5
def rgb(t: torch.Tensor, denorm=None):
    return ImageProxy(t)(denorm)
