# YT_Core - an inoffical youtube api parser

[[_TOC_]]


## Introduction

As youtube-dl is way to complicated and doesnt offer the right API for app-development.

One Example is the youtube-dl search API. You're only allowed to search for a specified amount of results.

That doesnt work for feature-complete apps. (endless scrolling)

Youtube-Dl is good for one thing: Getting the video from Youtube.


This is where yt\_core comes in:

yt\_core is a python library that should feel like using youtube.

### Example:

| Website                                       | yt\_core                        |
|-----------------------------------------------|---------------------------------|
| Going to youtube.com                          | core = yt_core.Core()           |
| Using the searchbar                           | search = core.new_search()      |
| Typing 'test' into the searchbar              | search.searchterm = 'test'      |
| Pressing the searchbutton	                | search.search()	          |
| Read the estimated results returned by youtube| search.get_results_count_total()|
| Scrolling down to see new results             | search.search_continue()        |
| Scroll through the page and see all results   | search.get_results()            |

## Example Implementation

[HandyYT](https://gitlab.com/ralf1307/yt_core-examples/)


## Current dependencies

- [requests](https://requests.readthedocs.io/), and its dependencies 
- Python 3.8.6 \(should work on way more, currently the only version tested)

This module is currently only tested on PostmarketOS \(PinePhone arm64\), 
but it should also work on other operating systems and architectures (It's python).

## Motivation

Allowing apps like NewPipe for Android, but for the PinePhone + PhoneShell. 
And they have to be open-source! \(That's the reason for the AGPLv3 license.\)
In the future other platforms perhaps, as I dont see Java as a good choice for modern GUIs or Apps. 
\(Servers perhaps, I dont know about server-java stuff\)


## How to use

- Make sure you have the needed dependencies (get them via `pip`, or let `setup.py` handle them)
- Get this project (git clone, downloading the tarball, floppies...)
- Install it via `setup.py` (or adjust your python3-path to the root of the repo.)
- Open python3 and `import yt_core`
- `help(yt_core)` or view doc-pages if available

