# -*- coding: utf-8 -*-
# Generated by Django 1.9.2 on 2016-04-02 13:33
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import eremaea.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Collection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(db_index=True, max_length=256, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='RetentionPolicy',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(db_index=True, max_length=256, unique=True)),
                ('duration', models.DurationField()),
            ],
            options={
                'db_table': 'retention_policy',
            },
        ),
        migrations.CreateModel(
            name='Snapshot',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateTimeField(db_index=True, default=django.utils.timezone.now)),
                ('file', models.FileField(max_length=256, upload_to=eremaea.models.snapshot_upload_to)),
                ('collection', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='eremaea.Collection')),
                ('retention_policy', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='eremaea.RetentionPolicy')),
            ],
            options={
                'ordering': ['-date'],
                'get_latest_by': 'date',
            },
        ),
        migrations.AddField(
            model_name='collection',
            name='default_retention_policy',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='eremaea.RetentionPolicy'),
        ),
        migrations.AlterIndexTogether(
            name='snapshot',
            index_together=set([('collection', 'date', 'retention_policy')]),
        ),
    ]
