"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from plaid.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from plaid.model.ach_class import ACHClass
    from plaid.model.transfer_authorization_decision_rationale import TransferAuthorizationDecisionRationale
    from plaid.model.transfer_intent_create_mode import TransferIntentCreateMode
    from plaid.model.transfer_intent_get_failure_reason import TransferIntentGetFailureReason
    from plaid.model.transfer_metadata import TransferMetadata
    from plaid.model.transfer_user_in_response import TransferUserInResponse
    globals()['ACHClass'] = ACHClass
    globals()['TransferAuthorizationDecisionRationale'] = TransferAuthorizationDecisionRationale
    globals()['TransferIntentCreateMode'] = TransferIntentCreateMode
    globals()['TransferIntentGetFailureReason'] = TransferIntentGetFailureReason
    globals()['TransferMetadata'] = TransferMetadata
    globals()['TransferUserInResponse'] = TransferUserInResponse


class TransferIntentGet(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('status',): {
            'PENDING': "PENDING",
            'SUCCEEDED': "SUCCEEDED",
            'FAILED': "FAILED",
        },
        ('authorization_decision',): {
            'None': None,
            'APPROVED': "APPROVED",
            'PERMITTED': "PERMITTED",
            'DECLINED': "DECLINED",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'id': (str,),  # noqa: E501
            'created': (datetime,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'transfer_id': (str, none_type,),  # noqa: E501
            'failure_reason': (TransferIntentGetFailureReason,),  # noqa: E501
            'authorization_decision': (str, none_type,),  # noqa: E501
            'authorization_decision_rationale': (TransferAuthorizationDecisionRationale,),  # noqa: E501
            'origination_account_id': (str,),  # noqa: E501
            'amount': (str,),  # noqa: E501
            'mode': (TransferIntentCreateMode,),  # noqa: E501
            'ach_class': (ACHClass,),  # noqa: E501
            'user': (TransferUserInResponse,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'iso_currency_code': (str,),  # noqa: E501
            'account_id': (str, none_type,),  # noqa: E501
            'metadata': (TransferMetadata,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'created': 'created',  # noqa: E501
        'status': 'status',  # noqa: E501
        'transfer_id': 'transfer_id',  # noqa: E501
        'failure_reason': 'failure_reason',  # noqa: E501
        'authorization_decision': 'authorization_decision',  # noqa: E501
        'authorization_decision_rationale': 'authorization_decision_rationale',  # noqa: E501
        'origination_account_id': 'origination_account_id',  # noqa: E501
        'amount': 'amount',  # noqa: E501
        'mode': 'mode',  # noqa: E501
        'ach_class': 'ach_class',  # noqa: E501
        'user': 'user',  # noqa: E501
        'description': 'description',  # noqa: E501
        'iso_currency_code': 'iso_currency_code',  # noqa: E501
        'account_id': 'account_id',  # noqa: E501
        'metadata': 'metadata',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, id, created, status, transfer_id, failure_reason, authorization_decision, authorization_decision_rationale, origination_account_id, amount, mode, ach_class, user, description, iso_currency_code, *args, **kwargs):  # noqa: E501
        """TransferIntentGet - a model defined in OpenAPI

        Args:
            id (str): Plaid's unique identifier for a transfer intent object.
            created (datetime): The datetime the transfer was created. This will be of the form `2006-01-02T15:04:05Z`.
            status (str): The status of the transfer intent.  - `PENDING` – The transfer intent is pending. - `SUCCEEDED` – The transfer intent was successfully created. - `FAILED` – The transfer intent was unable to be created.
            transfer_id (str, none_type): Plaid's unique identifier for the transfer created through the UI. Returned only if the transfer was successfully created. Null value otherwise.
            failure_reason (TransferIntentGetFailureReason):
            authorization_decision (str, none_type):  A decision regarding the proposed transfer.  `APPROVED` – The proposed transfer has received the end user's consent and has been approved for processing. Plaid has also reviewed the proposed transfer and has approved it for processing.   `PERMITTED` – Plaid was unable to fetch the information required to approve or decline the proposed transfer. You may proceed with the transfer, but further review is recommended. Plaid is awaiting further instructions from the client.  `DECLINED` – Plaid reviewed the proposed transfer and declined processing. Refer to the `code` field in the `decision_rationale` object for details. Null value otherwise.
            authorization_decision_rationale (TransferAuthorizationDecisionRationale):
            origination_account_id (str): Plaid’s unique identifier for the origination account used for the transfer.
            amount (str): The amount of the transfer (decimal string with two digits of precision e.g. \"10.00\").
            mode (TransferIntentCreateMode):
            ach_class (ACHClass):
            user (TransferUserInResponse):
            description (str): A description for the underlying transfer. Maximum of 8 characters.
            iso_currency_code (str): The currency of the transfer amount, e.g. \"USD\"

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            account_id (str, none_type): The Plaid `account_id` for the account that will be debited or credited. Returned only if `account_id` was set on intent creation.. [optional]  # noqa: E501
            metadata (TransferMetadata): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.created = created
        self.status = status
        self.transfer_id = transfer_id
        self.failure_reason = failure_reason
        self.authorization_decision = authorization_decision
        self.authorization_decision_rationale = authorization_decision_rationale
        self.origination_account_id = origination_account_id
        self.amount = amount
        self.mode = mode
        self.ach_class = ach_class
        self.user = user
        self.description = description
        self.iso_currency_code = iso_currency_code
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
