from simpleicons.icon import Icon
postcss_icon= Icon(
    title="PostCSS",
    slug="postcss",
    hex="DD3A0A",
    source="https://postcss.org/",
    svg="""<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>PostCSS</title><path d="M11.6266.008c-.235.008-.47.0322-.7053.0645-.2266.0246-.4533.0649-.672.0978-.2669.0323-.5341.0485-.8017.0812-.2512.0326-.5104.0813-.7613.122-.0893.0161-.1787.0484-.268.0644-.194.0406-.3966.057-.5912.122-.3479.106-.6966.228-1.0368.3573-.3162.13-.6241.2678-.9237.43-.3079.17-.5998.3725-.8914.5677-.2759.1866-.5508.3812-.8187.5921-.2586.2032-.502.4301-.7372.6574-.1293.1293-.235.2837-.3567.4297-.2023.2355-.4047.4623-.5993.7059-.1613.2032-.308.4138-.462.625-.275.3726-.5098.7705-.7284 1.1682-.0893.1623-.17.3246-.251.4865-.1216.2432-.2513.4788-.3646.7304-.0812.1705-.146.357-.1946.5435-.113.3978-.2266.8036-.332 1.2008-.0972.3572-.1217.7304-.1294 1.0955-.0083.3245.0241.641.0564.9655.0083.0813-.0399.1785.0568.2432-.0324.0893-.008.1385.04.1539-.056.0893.0246.1466-.0075.2279-.0083.0161.0247.0484.0401.0727 0 .0246-.0077.0569 0 .0812.0087.073.0408.146.0408.2272 0 .0567.0485.1218.0649.1787.0079.024 0 .0645-.0163.0808-.0486.0567-.0406.1053.0323.138.041.1052.0247.1538.0166.203.016.0728-.0083.0972 0 .1135.0647.13.0891.2757.0968.4216 0 .0326.0163.0653.0326.1057.008 0 0 .1542 0 .1542.04-.024.0732-.0323.1135-.0486.0246.1053.0485.2032.0809.2924.0406.0647.0408.0967.0247.1047.0324.146.0484.284.1047.422 0-.154-.0155-.308-.04-.4543.1132.0407.2105.0812.2754.0812.0083-.0246.0164-.0567.0248-.073-.0486-.0483-.0892-.1212-.1379-.1699.0162.0647 0 .0892 0 .1138-.0323-.0166-.0731-.0329-.1135-.0492.0324-.04.0649-.081.1135-.1294 0-.0733-.04-.1384-.1539-.13.0487-.0162.0973-.0402.1539-.0568.0893-.0483-.0081-.1375-.0081-.251.008-.1377-.0728-.2757-.0972-.422C.755 12.52.7632 12.1792.739 11.952c-.0487-.0407-.0892.0647-.0972.073.0247.1946.0486.3891.0646.584-.0483-.1623-.081-.3408-.1213-.5357-.0083.0569-.0162.081-.0162.1138-.04.04-.008.0894.0162.146-.0566-.0246-.1216-.016-.1216-.016v.2272c-.0807-.0813-.1048-.1462-.1457-.2035-.016-.0647-.0248-.1293-.0401-.194.0153-.0409 0-.065 0-.089a4.9287 4.9287 0 0 1-.0245-.1953c.008-.008-.0081-.1294-.0081-.1294.0647.008.1057.0153.146.0153-.081-.1047-.0247-.1698.0082-.2347.0162-.0326.073-.0401.0893-.0734.0647-.1217.1702-.2185.1702-.373 0-.073.025-.154.0326-.2273.0162-.138.0321-.2758.0398-.4137.0166-.1786.0001-.3573.041-.5276.0653-.2832.1462-.5675.2351-.8516.0647-.2032.1382-.397.2188-.6003.1216-.3165.235-.633.389-.9328.2186-.4384.4698-.8604.713-1.2902.154-.2678.316-.5194.4865-.7789.1617-.2515.3234-.5111.5103-.7467.2595-.3325.5432-.641.8591-.9168.3242-.2919.632-.592.9801-.8598a9.8482 9.8482 0 0 1 1.4415-.9256c.4135-.2186.8427-.3898 1.2722-.552.2756-.1053.5753-.154.8592-.2433.3239-.1056.648-.1537.9882-.162.2186-.008.4293-.0327.6479-.0571a16.277 16.277 0 0 0 .6-.0564.3469.3469 0 0 0-.0409.0645c-.0886.13-.1859.26-.2751.3896-.073.1056-.154.2191-.227.3244-.1299.171-.2676.3412-.389.5197-.1862.268-.3567.5437-.5513.8113-.194.2595-.4048.5032-.6074.7544-.2673.3492-.5186.706-.7858 1.0548-.2432.3325-.5016.6495-.7369.982-.2106.2916-.3973.6004-.5999.9-.2996.4464-.5993.8844-.8989 1.3309a83.6172 83.6172 0 0 1-.713 1.014c-.0163.0246-.0406.0319-.0646.0482-.0647.1053-.0647.1623-.0894.211-.0646.1215-.1292.2434-.2024.3573-.0407.0647-.0975.1212-.1461.1862-.008-.0973.1292-.1461.0645-.268-.04.0652-.081.1218-.1212.1868l-.0972.194c.0318.0242.0863.0408.034.0874-.0054-.019-.0327-.0318-.0532-.0473l-.0003-.0004a4.5465 4.5465 0 0 0-.1937.2925c.0486.0403.0726.0244.105-.0326.0292-.0586.0713-.1043.1092-.1542a2.28 2.28 0 0 1-.0417.0743.2946.2946 0 0 0 .0893-.0815c0 .0893-.0487.1621-.0893.235-.0324.0648-.1133.1138-.17.1621.008.008.0648.0327.0731.0408.073-.0246.0973-.0648.1057-.0408.0246-.0323.0484-.0566.0564-.0809.032-.0813.0807-.146.1617-.1787.0326-.0162.0568-.0405.0812-.0645.2432-.2518.4941-.495.7127-.763.3405-.414.6484-.8435.973-1.2653.1373-.1786.2997-.357.4453-.5276.024.1866.008.3649 0 .5357-.0246.3-.0405.6002-.0645.9081-.0083.1216-.0002.2432-.0085.3652 0 .0323-.0245.0567-.0245.0893 0 .081.0245.1704.0245.2517-.0246.3002-.0572.5919-.0815.892-.0083.0647.024.13.04.1869-.04.4378.0492.9007-.024 1.3632.0566-.0893.073-.1462.073-.2028.0077-.0487 0-.0973 0-.154v-.0811c.0077-.1463.0398-.3001.0238-.4464-.0162-.1622-.0164-.3162.0162-.4705.0163-.0647-.0077-.146.033-.2272v.1216c-.008.4618.0083.9246-.0564 1.387-.0083.0407.0244.114-.0649.1056-.0733.146.016.2516-.0646.3326-.0166.0162.0155.0893.0239.138-.0327.0975-.0327.0975.016.1056.008.1785.0246.3403.0323.5109.1293-.3079.0647-.6251.122-.9416.0079.1299.0163.2601.008.3974 0 .2115-.0083.4138-.0162.6247 0 .0407-.0083.0813-.0162.122-.0247.1139-.0321.2272-.0727.3325-.0324.0813-.016.2033-.016.3003v.3088c.0323.138-.0084.2108.016.2918-.0247.0816-.0325.1061-.0248.1304l.0248.1216c.1622-.0162.0892.1056.1539.1702-.0487.0653-.0323.0893-.0323.1223 0 .073-.0078.138-.016.211 0 .1865-.0082.373-.0082.5516 0 .0246.0081.0484.0081.0727 0 .0166-.008.2276-.008.2276.0161.024-.0002.0484-.0249.0727-.0077 0-.032-1.0303-.032-1.0303h-.1216c-.016.4864.0248.9244-.0645 1.3792-.0973.008-.1295.024-.2354.024-.2512 0-.5023-.0001-.7535.008-.2999 0-.5912.008-.8914.008-.1453 0-.2991.0167-.445.0167-.1947 0-.3972-.0248-.5912-.0248-.3002 0-.5919.0246-.8917.0326-.2186.008-.4371.008-.6557.0162-.1463.008-.2926.0157-.438.0323-.0646.008-.1214.032-.2024.0564-.0246 0-.0811-.008-.1294 0-.0816.0162-.1538.0649-.2354.0815-.1216.0246-.154.0564-.138.1783v.0812c-.0079.016.1784-.0248.1784-.0248-.0166 0-.0246.0487-.0492.0893.0652-.0246.1057-.0407.1464-.0567.1216.057.2268.0246.3237.0492.316.0807.64.114.9638.1457.211.0162.4135.0246.624.0323.2997.0162.5994.0326.899.0326.2512 0 .4944-.0245.745-.0245.348 0 .6971.016 1.0453.0245.073 0 .1541-.008.2351-.008h.5911c.5271-.016 1.0536-.0247 1.5804-.04.3002-.009.6078-.0247.9074-.033l.9237-.0248c.3565-.008.713-.008 1.0616-.0153.2672 0 .5264-.009.7943-.017.2992-.008.6071-.0322.907-.0483.1623-.008.3245-.0247.4865-.0408.1946-.016.3971-.04.5911-.0483.2919-.0166.5917-.0244.8836-.0408.3645-.024.7292-.0566 1.1017-.0649.3405-.016.6888-.008 1.0293-.016.3-.008.5996-.0246.9074-.0326l.5113-.0248s.34-.008.5102-.0245c.2916-.016.583-.0484.8748-.0564.186-.008.3726.0002.5589-.008.2996-.008.6075-.0248.9074-.0248.113 0 .2345.0168.3805.0248-.0647.057-.1053.0891-.154.1298.0324.008.0646.0247.0972.0408-.0486.0323-.089.0401-.129.0401-.0167.041-.033.057-.0493.1383h.1457c-.0566 0-.105.073-.1617.1216-.0646-.0166-.1219 0-.1542.0893.0567.032.0488.0564.0408.0893-.0973.032-.1701.0646-.1292.1698-.033.0161-.0734.0324-.114.0567-.0401.0647-.1133.081-.0973.1702.0327.008.0647.025.0894.0323-.0407.0162-.081.0404-.1216.0564-.1457.0893-.081.13-.0486.1706-.0246.0162-.0484.0324-.0727.0408.016.073.04.0893.0482.0893a2.7824 2.7824 0 0 0-.085.0678.1666.1666 0 0 1 .01-.0264h-.0325c0 .0149.003.0277.0052.0404-.0074.006-.0116.009-.0193.0153-.0246.073-.057.1052-.0893.1538-.0323.0487-.0487.114-.0893.1624-.17.187-.2917.4064-.5103.552-.0813.057-.154.1299-.227.2031-.1459.1377-.2754.292-.4293.422-.2023.1702-.4124.324-.6316.4783-.267.1865-.5342.3734-.8018.552-.1459.097-.308.1699-.462.2592-.154.0893-.2999.1705-.4538.2595-.0973.0647-.1865.1539-.2918.2031-.2673.114-.551.211-.8262.3166-.2679.114-.462.2107-.6645.2837-.1863.0647-.3809.1139-.5752.1539-.0646.0166-.138.0001-.211.009-.1379.0246-.2754.0574-.4134.0734-.3565.0486-.7129.081-1.069.1297-.211.0246-.4139.0647-.6245.0893-.1456.008-.2994-.008-.4453-.008-.1053 0-.2185.0248-.3241.009-.17-.0246-.3404-.0645-.5106-.0972-.04-.008-.0971-.0248-.1291-.008-.0647.0326-.1222-.016-.1872 0-.04.008-.0806-.0245-.1213-.0245-.0326-.008-.0731.009-.1138 0-.0892-.024-.17-.0566-.268-.0486-.0963.008-.194-.0405-.2986-.0645-.1463-.0326-.2832-.0645-.4298-.0975-.0563-.0162-.1047-.0407-.1617-.073-.2109 0-.3487-.008-.4783-.057-.1133-.04-.2185-.0969-.34-.0806-.032.008-.0565-.008-.0894-.008-.0246-.0326-.0484-.0975-.0724-.0975-.162.008-.2592-.1292-.3971-.1702-.0727-.0246-.1295-.1057-.2025-.13-.1786-.073-.3237-.2268-.5262-.2511-.0647-.008-.1296-.041-.2028-.065.0246.032.0402.0567.0648.0809-.2349-.114-.4537-.2433-.6726-.3652-.032-.008-.0562-.04-.0805-.0567l-.2189-.1473c-.1216.0246-.1701-.0244-.203-.0404-.2187-.1539-.4696-.2516-.6805-.4219-.0893-.0733-.194-.122-.2586-.2112-.114-.138-.2517-.235-.4056-.316-.1213-.0647-.2346-.138-.3479-.211-.057-.0406-.1138-.0893-.1138-.1786 0-.057-.0239-.1138-.0968-.0812-.0324-.0486-.0647-.1053-.1053-.1216-.0973-.04-.1622-.114-.2351-.1787-.073-.0647-.1292-.1538-.2185-.1862-.1622-.0647-.2597-.2026-.3567-.3162-.2272-.2679-.4297-.5603-.6403-.8435-.0163-.0246-.0487-.041-.073-.0652.0323.0893.073.1622.1134.2432-.0807-.0323-.1372-.0894-.1858-.146-.0083.008.5585.9412.5585.9412.0492.073.0893.1462.1379.2191-.1216.008-.2026-.057-.2432-.13-.0727-.1294-.1537-.2103-.3157-.1937-.016-.0573-.0324-.1223-.04-.1787a.6159.6159 0 0 1-.1142-.009c.114.1786.211.3327.3163.5112-.041-.0246-.0646-.0406-.0815-.0486.1456.154.251.3488.4372.4464.0407.1863.2513.2756.3.4542-.04-.008-.0735-.0164-.1142-.0248-.0646-.081-.1376-.1618-.2103-.251a.4071.4071 0 0 0 .0727.1457c.0973.1216.1867.2432.3.3488.0406.0413.0972.0575.0972.1305.0646.0323.0894.04.1134.04.0166.0494-.0075.1223.0894.106.0646.1216.1291.1215.2184.0812.1056.1056.1624.114.235.0492 0 .04.0082.0808.0082.1135.0323-.0162.0248-.0405.0248-.0812.04.0323.0645.0485.0805.0645.081.1139.1541.2191.2674.3084.154.13.2916.268.4369.3896.2839.2356.6006.4302.9162.6085.3892.2192.762.4545 1.1588.665.4778.252.9883.4227 1.5148.5443.1946.0407.381.0808.5758.129.1693.0494.3397.1225.51.1628.2592.0569.5265.1056.7857.1539.0564.008.114.0168.1787.0248.0723.0162.1614-.0164.1777.008.0406.0647.073.032.1216.024.0567-.0161.1215-.0161.1862-.0161.2269.008.4454.0564.6723.0404.0492 0 .122-.041.1627.04.0727-.0322.1134-.0323.1457-.04.0087.0727-.0002.0729-.0157.0808-.0166.008-.0407.016-.073.0404.2916.0567.567.0647.8096 0 .4218.0323.7864-.0162 1.135-.138.0323.0407.0567.0974.1053.0163.016-.0246.0564-.0328.089-.0408.0727-.0162.162-.0488.2266-.0248.0733.0246.0979-.0401.1542-.0401.0976 0 .1866-.008.2759-.0245.0486-.008.0972-.0323.1538-.0486a.3938.3938 0 0 0-.1786-.0411 7.2787 7.2787 0 0 1 .2758-.1292c-.0162.024-.0325.0561-.0645.0561h.1128c-.0247 0-.0569.073-.0972.1217.2913-.073.5585-.1379.818-.2032-.0892-.17.0971-.113.1621-.2106-.081.0246-.162.0485-.2432.0645.2755-.1376.559-.2592.8343-.3808-.04.0486-.0894.0732-.1617.1141.0486.008.081.008.1053.0153.1293.0409.0973-.0806.1376-.1539.154 0 .2185-.024.2915-.0486.081-.0246.162-.0488.2432-.0812.1293-.0567.2509-.1293.3805-.194.0247-.009.0649 0 .0975 0 .0893-.0573.1211-.1058.1454-.0978.114.0162.194-.0244.2266-.1291.0096-.007.0144-.0101.0232-.0166.0325.0715.0975.0794.2028.007-.065 0-.1299-.008-.1865-.0161-.006 0-.0081.004-.0115.006.0405-.03.0778-.0586.11-.0783.1779-.0973.3476-.1945.5262-.2918.0646 0 .0974.0001.1134-.008.106-.0493.203-.1054.3-.1624-.0246-.008-.0809-.04-.0809-.04a1.055 1.055 0 0 0 .154-.0409c.1939-.2278.4618-.3819.664-.5605.0894-.008.0894-.0322.0894-.0482.032-.0407.0647-.0893.1047-.122.1786-.1622.3725-.3001.5347-.4704.235-.2358.4617-.4795.6723-.731.194-.2272.3894-.454.5514-.7056.2269-.3488.4211-.706.6237-1.0714.146-.2592.2757-.5187.422-.7782.0152-.0246.048-.0571.0723-.0571.2186-.0246.438-.04.6485-.0645.0487-.008.1053-.0403.1539-.065-.0246-.0406-.0405-.089-.0646-.1297-.0326-.0493-.0811-.0893-.1137-.1386-.032-.04-.0566-.0892-.0809-.1376-.0246-.04-.0487-.0729-.073-.1141-.0493-.0893-.0976-.1785-.1386-.2752-.008-.0246-.0246-.0647-.016-.0893.1459-.3162.2027-.6567.3403-.9732.1377-.3245.1786-.6897.2433-1.0385.0566-.3325.089-.6652.129-.9977.0247-.2352.0573-.4625.065-.6977.0492-.3732.0324-.7223.0244-1.0714-.0079-.308-.0247-.6244-.04-.9329l-.0007-.001c-.0161-.3164-.0242-.6328-.0568-.949-.0566-.4301-.1133-.8684-.2106-1.2902-.073-.3488-.194-.6815-.316-1.014-.1539-.3895-.3078-.787-.5024-1.16-.3159-.6005-.729-1.1361-1.1099-1.6959-.2518-.3571-.5758-.6491-.819-1.0143-.1376-.2109-.3403-.389-.5429-.551-.3242-.2602-.6643-.4956-1.0045-.7225-.2593-.1786-.5184-.3489-.7943-.5031-.2186-.1222-.4535-.2195-.6804-.3251-.2593-.1216-.5106-.268-.8021-.3247-.0733-.0153-.138-.04-.211-.0645-.1862-.0647-.3644-.1377-.551-.1947-.2832-.0893-.5588-.1944-.8507-.2677-.2826-.073-.5744-.1214-.8663-.1623-.3239-.0477-.6559-.0645-.9804-.0962-.2106-.0246-.4211-.0487-.6237-.0567-.3079-.0161-.6237-.0161-.9315-.0241-.154-.008-.316-.0246-.4699-.0162zm.6941.94c.1056.0166.2033.0328.3003.041l.389.0246c.2916.0237.5832.0402.8745.0802.2432.0329.4866.0816.7378.122.5351.0892 1.0614.2353 1.5719.4055.2999.0973.5911.2273.8836.349.6558.2678 1.2799.5922 1.8956.9327.194.1056.308.2758.4532.43.211.2193.4218.4383.624.6652.2347.2679.4533.5438.6806.8197.2022.2432.4127.4865.6159.7304.0646.073.1138.1622.1698.2432.1293.1949.2754.3815.3887.5921.0807.1545.1295.3332.1862.5034.0806.2516.162.4948.2432.7463.0563.1866.1044.3819.145.5758.0327.1303.025.2679.065.3972.0492.1712 0 .3573.0492.5282.0077.0162.0155.0404.0241.0567.0324.032.0565.0648.0077.1134-.0077.008-.0077.04 0 .0645.0166-.016.0248-.0324.0411-.0567 0 .0162.0076.025.0076.0326 0 .032-.0083.0645 0 .0968 0 .0161.016.0401.0241.0567.0163-.0166.0323-.0246.0646-.0492.073.2762.0815.5518.0815.8357 0 .2678.0481.5357-.0649.7952.024-.0893-.0325-.1707-.008-.2517l.0032.002c-.0083 0-.0565-.0494-.0645-.0574-.0083.0246 0 .0485-.0163.0812-.0083-.024-.0648-.0157-.0648-.0398-.0083.1133.0484.2268.04.3404.0247-.0162.1218-.0246.1461-.0486.0083.008.0246.0161.0326.0161-.1622.122-.1215.2433-.0485.3818.016.032.0646.0967.016.1617-.016.0162.0083.0647.0162.1057h.0239v.0157l-.073.0245c-.0161-.0246-.1132-.0725-.1132-.1138v.4144c.081.0246.0811.1377.1134.1946a.2405.2405 0 0 0 .033-.0645l.008.008c-.0082.0487-.0162.0971-.0325.1461-.016.0727-.0324.1377-.0401.2106 0 .008.0156.0246.0156.0323-.0886.2032-.04.4298-.0724.6404-.0246.154 0 .3173-.0162.4793-.0166.138-.0495.2836-.0815.4216-.0083.0246-.0245.0326-.0646.0489.0161-.0973.0081-.1625-.008-.2517-.0088 0-.114-.0567-.1223-.0567 0 .1139.0647.2681.0893.3974-.0246-.008-.1217-.0649-.1294-.0649-.0166.0973-.0168.2273-.0248.3326-.0083.0813-.0807.154-.089.2432 0 .0493.0566.0814.0486.1627h.0645c0-.162.0734-.308.0734-.4786h.0238c.0083.0162.0328.0328.0248.0408-.0162.0893-.0494.1865-.0408.2758 0 .0487.0402.0972.0248.1539-.0166.0493-.0246.0976-.0329.1705-.0083-.0406-.0162-.0565-.0162-.0808-.008 0-.081-.008-.0894-.008-.0079.0487.057.0973.0486.138-.0079.008-.016.008-.0323.0161l-.2673-.3896a81.9295 81.9295 0 0 1-.6322-.9328 1.9488 1.9488 0 0 1-.1464-.2432c-.251-.4305-.5265-.8442-.8344-1.2416-.2346-.3-.4218-.6251-.6403-.9407-.202-.3002-.4046-.5925-.6071-.893-.073-.097-.162-.1862-.227-.2918-.2102-.3326-.397-.6734-.607-1.006-.1786-.276-.3727-.5439-.5592-.8115-.0647-.0893-.1294-.187-.1947-.2843-.0079-.0153-.016-.0314-.016-.0558-.0163-.1785-.0325-.3572-.0405-.5275 0-.1623.0163-.3244.0163-.495v-.1468c0-.0407.0076-.073.0076-.1138.0077-.008.016-.0243.024-.0323-.2348 0-.478-.009-.713 0-.154.008-.2348-.0573-.34-.1709-.308-.3488-.535-.7462-.8022-1.1193-.2512-.3572-.5105-.7063-.7698-1.0551-.2109-.2839-.4219-.5596-.6322-.8435-.2352-.3245-.4617-.649-.7049-.9736-.2919-.3891-.5918-.779-.8914-1.1682-.1385-.1786-.2924-.3488-.4464-.5357zm-.7518.4258c.0173.003.0337.0175.0499.0378.2186.2759.437.5598.6556.8357.1626.2032.3247.3972.4787.6084.1863.2598.3644.5194.551.779.2106.3.4212.6004.6237.9083.308.4547.5995.909.9074 1.3632.227.3325.4537.6573.6723.9899h-.4137c-.3806-.008-.7698-.0401-1.1503-.0241-.5185.0246-1.045.0813-1.5634.122-.6564.0568-1.3207.0644-1.9765.0644-.2355 0-.4703.033-.705.0492-.2838.0161-.5595.0324-.843.0401-.3326.0166-.6558.0246-.9883.033-.1866.008-.3808 0-.5833 0v-.002c.2586-.3572.5265-.7141.7857-1.079.081-.1062.1457-.2198.2266-.325.0247-.0327.0572-.049.0975-.0816l-.0081-.0153c.0323-.041.0645-.0739.0809-.106.0412-.0646.0658-.1379.098-.2109.008-.0153.0324-.0316.0324-.0316.1139.0567.1138-.0647.1539-.1056a5.568 5.568 0 0 0 .2106-.2514c.0486-.0647.0973-.1217.138-.1946.0078-.0246-.0165-.0646-.0249-.0975h-.0238c.0246-.016.0487-.0401.073-.0567.008 0 .008-.0002.0161-.008a4.632 4.632 0 0 1 .1457-.211c.097-.1293.2023-.2594.3156-.3727-.016.04-.0322.0808-.0485.1132.0083 0 .0083.008.0162.008.0973-.13.2027-.2516.3-.3818-.0083-.008-.0164-.016-.0248-.016-.04.0406-.0725.0813-.1132.122-.0079-.008-.0162-.0163-.0247-.0163.0815-.1056.1625-.211.2432-.3326.0162.0246.0325.0567.0645.1217.033-.081.0654-.1377.0894-.1947-.024.0246-.0562.0487-.0806.0734L9.998 3.504l.146-.2184c.154-.2193.3078-.4466.4617-.6658.057-.081.1294-.1457.1787-.227.154-.3078.3973-.5518.5833-.8356.0406-.0567.097-.1053.1457-.154.02-.0245.0382-.033.0554-.03zM9.2843 4.5345c-.0484.0323-.0893.0567-.1376.0893l-.0004.0004c-.0083.008-.0164.008-.0085.008.0083.04.0083.073.0163.1294.057-.0816.0971-.1463.1464-.211zm6.8378 3.3417c.0727 0 .1133.0247.154.0893.0726.1216.1456.2432.2265.3652.0083.016.0248.0399.0248.0645 0 .1785-.0002.3652.0077.5438.0077.1866.025.3651.0323.5517 0 .1866-.0164.3812-.0081.5758.0083.2762.0162.5602.0162.8435l.0013.0006v.0734c-.0079 0-.016.008-.0322.008-.0324-.1139-.0647-.2356-.1054-.3492-.0809-.2355-.1703-.4711-.3162-.6817-.1626-.227-.308-.462-.4705-.6975-.04-.0569-.0974-.1055-.146-.1538-.1703-.187-.3403-.3818-.559-.5194a6.6159 6.6159 0 0 0-1.013-.5198c-.0972-.04-.1863-.0894-.2833-.146h.194L15.2306 7.9c.2999-.008.5918-.008.8914-.0241zm-6.084.2116c.0587-.001.1174.0008.178.008-.1293.0653-.2594.1303-.3727.2113-.146.0973-.2831.227-.4294.3325-.1462.1053-.2758.2354-.3971.3734-.154.1862-.3242.3483-.4865.5269-.1139.1299-.243.2517-.34.3896-.1377.1786-.2594.3723-.389.5755.0406-.771.0894-1.5331.0567-2.312l.0007.0006c.3808-.0162.7451-.0407 1.1183-.057.291-.0163.591-.0249.8823-.0409.0608-.004.12-.008.1787-.008zm2.0326.4147c.2423.008.4854.008.7284.0241.1052.008.2026.0322.3.0645.1212.041.2508.0975.3644.154.1377.0738.2672.1545.3972.2438.2349.154.4537.3244.6886.4623.2269.138.405.3245.551.5357.1786.2513.3807.4786.4617.7868l.1213.5357c.0246.0973.0814.1945.057.3078-.041.2032-.0733.4143-.1056.6172-.016.0816-.0321.1632-.0238.2432.0153.2525-.0817.4709-.1787.698-.0326.073-.0813.1464-.1216.2273.0079.008.0565.0326.0645.0326l.073-.1457c.0084 0 .0084-.0002.0163.008-.0406.1133-.0728.2353-.1138.3489-.0967.2515-.194.5109-.3156.7541-.0647.138-.1785.2516-.2592.3818-.0807.1133-.1456.2351-.2266.3407-.073.0893-.1456.1786-.2432.2433-.2186.1622-.4456.3246-.6805.4545-.1456.0893-.316.1377-.478.1783l.0022-.001c-.2595.0647-.5264.1382-.7942.1706-.2266.0326-.4619.0245-.6968.0245-.2112 0-.4138-.008-.6244-.0245-.235-.024-.4699-.0486-.6968-.1542-.1948-.0893-.3971-.1701-.591-.2677-.1953-.0973-.3895-.2108-.5358-.3893-.1047-.1303-.2509-.2353-.3805-.3489a.3826.3826 0 0 0 .1702.235c-.0406.0488-.0974.0247-.1787-.1056-.024.0162-.0482.0246-.0645.0326.0246-.057.0487-.1137.073-.162-.0323-.0647-.073-.1382-.1053-.2035a6.823 6.823 0 0 1-.1865-.324c-.0162-.0247-.0162-.0488-.0323-.073-.0406-.0488-.0811-.0975-.1138-.1461-.0646-.097-.1211-.2024-.2021-.3 0 .0246.0081.0485.0081.0812-.0083 0-.0162.008-.0162.008l-.1705-.4137c-.008 0-.008-.0002-.016.008l.1453.5357c-.0079 0-.0158.008-.0244.008-.0237-.032-.048-.0646-.0646-.1047-.016-.0653-.065-.0654-.105-.041-.0246.0161-.0409.0731-.0326.0974.057.138.122.2758.1869.4138a.965.965 0 0 0 .0564.1379c.0083.0162.0326.032.0326.0564.0326.0647.0571.1295.0975.1868.073.0973.154.1945.2269.2918.0724.0973.1369.2033.2018.3003.008.0162.0324.0162.0401.0245.041.1216.1786.2107.2759.162.0246.1866.2268.2515.3077.4301a3.702 3.702 0 0 1-.2347-.1056c-.0083.008-.0083.016-.0166.0323.0973.0486.1947.0972.2833.1539.0816.0493.1625.0979.2354.1542.0973.0893.211.1385.348.1705-.0075-.0247-.0154-.0329-.0154-.0329.2266.1056.4618.2191.6397.3078-.8427.0166-1.742.0329-2.6739.0492 0-.154-.0081-.3003-.0081-.4545 0-.0647.0162-.1216.0077-.1865-.0246-.3726-.0247-.7464-.073-1.1115-.0483-.3892-.0484-.7707-.04-1.1608.0077-.2102-.0084-.4291-.0167-.6403 0-.2839.0002-.5602.0089-.8435 0-.0407.0162-.0732.0326-.1141h.0248c.0077.0166-.0001.0409.0153.0492.0246.0246.0652.0647.0815.0567.0483-.0326.1213-.0645.1376-.1138.04-.097.0567-.2027.0567-.3 0-.0727.0325-.1212.0645-.1702.0166-.0246.0248-.0485.0411-.0808-.0323-.0246-.0647-.0407-.1053-.073.0327-.0893.0245-.1949.146-.2432.0161-.008.0163-.0494.0249-.0734.0077-.0656.015-.1385.0238-.2031.016.0246.0247.0322.04.0483.0087-.0161.0167-.0248.0167-.0248 0-.032-.008-.097 0-.097.0973-.0161.0566-.1215.1053-.1701.0077-.009-.0081-.033-.0081-.0492 0-.0161-.0002-.0401.0077-.0401.113-.0246.097-.1462.1699-.2031.0246-.0162.0325-.0402.0649-.0812.0646.1133-.0488.1704-.0568.2513.1374-.081.1779-.2756.0969-.3325a.4815.4815 0 0 0 .0893-.0893c.0893-.0973.1861-.1864.2674-.2837.057-.0727.0894-.1621.146-.235.0327-.0407.0972-.073.1458-.0976.146-.0807.2834-.1698.3727-.3078.0162-.0162.0405-.0326.0645-.0489.0247-.0162.0732-.016.0812-.0404.0083-.016-.016-.0569-.0323-.0812.032-.0162.0648-.0485.1295-.0812-.0247.0487-.0323.0811-.0486.1138l.0398.0401c.0732-.0566.1865-.1212.2595-.1698 0-.008-.0404-.0401-.0404-.0401-.0484.0246-.1214.0648-.194.0975.0153-.0246.0153-.041.0244-.049.113-.073.2263-.1458.348-.203.2832-.1294.567-.2593.8506-.3809.0486-.0246.1141-.008.1705-.008.024 0 .04-.0001.0645-.008.1293-.0407.2594-.0812.389-.1138a.6768.6768 0 0 1 .1784-.024zm-.3153.1207c-.089.0409-.1618.073-.2348.1056h-.0003c0 .008-.0403.073-.0326.073.0406-.008.1297-.0729.1783-.0812.0243 0 .0569.008.0815.0166 0-.0326-.0001-.0655.0077-.1141zm5.858 1.3811c.081.1053.17.2031.2267.3078.1866.3411.4294.6334.6563.9416.1946.2679.3728.5598.5514.8357.2186.3325.429.6648.6478.9974.162.2518.3328.5034.5021.747.154.2185.3164.4297.4784.641.1373.1865.2833.3732.4209.5598.1622.2272.3242.454.4864.6733.0807.1133.17.2267.2586.3404.0493.0647.1219.1142.1705.1542a.0627.0627 0 0 1-.032-.008c.0247.0323.0402.0567.0568.073.0893.0487.0972.0973.0486.1705l.0006-.002c-.0079.0162-.0246.0326-.0323.0492-.0083-.0166-.0083-.0408-.0162-.0737-.0486.1302-.154.0652-.227.0652-.4371.008-.883.008-1.3207.008-.4212 0-.8504.0001-1.2716.008-.138 0-.284.0324-.422.0408-.3318.0161-.6641.0246-.9963.0323-.0247 0-.0484-.0401-.089-.0727-.008.0162-.025.0407-.049.073-.0087-.016-.0244-.0321-.0407-.0564a.4478.4478 0 0 1-.0248.0645h-.0235c-.0162-.1133-.0486-.2187-.0486-.3326 0-.2432.0246-.4861.0323-.73.0083-.1133 0-.2188 0-.3247.0327.0246.057.0412.0894.0649a.692.692 0 0 1 .0485-.0802s-.0162-.008-.0326-.0245c.0153-.008.0323-.0246.0323-.0326.0079-.0246.0245-.049.0245-.065 0-.057-.0165-.1055-.0245-.1538.0079 0 .0159.0001.0245-.008l.0482.2432h.0248c-.0326-.0563.0727-.1055-.0162-.1702-.008-.008.0077-.0569.0077-.0812-.0247-.0483-.04-.097-.0646-.162.008-.008.0324-.0162.0567-.0245-.0323-.0161-.0568-.0321-.0811-.0401.081-.0733.081-.114.008-.195.0167-.008.0327-.008.0327-.0153 0-.0733 0-.1461-.016-.2185-.0163-.0819.0247-.1786-.0972-.2279a.2307.2307 0 0 0 .0322.0645s-.0245.008-.0485.0248c-.1053-.0976-.0403-.228-.065-.3736.0567.0162.0973.0326.1377.0492-.0163-.0573-.0566-.122-.0809-.195h-.033v-.5357c0 .008.0568.008.0894.0166 0-.008.0076-.0164.0076-.0248-.0246-.0323-.0567-.0647-.089-.1053l.0162-.0162c-.0646-.0807-.0322-.1938-.0322-.2185v-.568c.0813.0814-.0401.1865.0812.2351v-.0808h-.0085c-.008-.1216-.008-.2432-.016-.3651h-.0161c-.0083.0166-.0083.0244-.0166.0408h-.016zm-13.6516.6635c-.0966.1136-.1859.2274-.2751.3404h-.001c.016.008.0401.0652.0568.0815.089-.1216.2106-.2757.3-.3896-.0084-.008-.0729-.0243-.0806-.0323zm-.5428.3978c-.0487.0727-.1698.2029-.2185.2758.008.008.097-.0324.105-.0238.0486-.073.0972-.1544.1458-.2276-.0159-.008-.024-.0166-.0323-.0245zm.0323.0245l.0003.0003v-.0006l-.0003.0003zm.1372.0968c-.0483.0333-.0967.074-.1454.1063.0162.016.0162.0247.0162.0408-.0646-.008-.0893.0245-.1216.1131-.008.0246-.0487.0325-.0893.0645-.008.0166-.0159.0575-.0323.0978l.0081.008a.1243.1243 0 0 1-.0404.0248c-.0487.0483-.1056.0893-.1542.1376-.008.0246-.016.0487-.016.073.0569-.0567.1539-.1623.2269-.2273l.0084.008c.0324-.0487.0567-.097.0894-.1457.0077.008.0077.0159.016.0245-.0246.0647-.0487.1375-.073.2025-.017.008-.0414.0246-.0414.0162-.0323.0246-.0567.0565-.0894.0808l-.1454.097c-.081.073-.162.1378-.2514.211-.0566.0893-.113.1703-.1783.2759.0976-.0246.1218.0166.1138.0978.1133.016.1215-.073.1539-.138.008-.0165.0162-.0493.0323-.0573.073-.0647.154-.1213.235-.1862.0163-.0162.0163-.0494.0163-.0734 0-.008-.041-.008-.0653-.0162.073-.0813.1784-.2185.2511-.3078.0407-.0246.0812-.0575.0812-.0818-.0066-.0745.032-.1036.0828-.1301-.0378.1753-.144.3252-.252.356.0323.0162.0647.0328.0893.0248.024-.008.0401-.0494.0564-.0734l.2185-.3162.0733-.122-.0323-.0326-.0003.001c-.0323.0567-.0648.1054-.0971.1624l-.0277-.014c.0009-.0005.0018-.001.0027-.002-.0326-.0246-.041-.0484-.041-.0564l.0003-.001c.0086-.0246.0247-.0487.041-.073.0161 0 .0402-.008.0402-.008.033-.0567.0329-.0974.0652-.146-.008-.008-.0164-.008-.0248-.0163zm14.0586.998l-.0007.0004c-.0006.002 0 .004-.0006.006.0006-.002.0005-.004.0013-.006zm-.0013.006a.229.229 0 0 0-.0072.0668c0-.0223.001-.0447.0072-.0668zm-.0072.1474v.008c.0083.008.009.008.016.0006-.0079 0-.0079.0002-.016-.008zm0 .0162c-.0237.008-.0483.008-.0809.0162.0397.0151.0791.0238.0809.0391zm0 .0554v.002l.0006-.0006c0-.0004-.0006-.0007-.0006-.001zm-1.1914 1.4219c-.0162.9249.0893 1.8333.2106 2.7502-.9153.0323-1.8474.0645-2.787.0972l.0003-.0003c.3642-.154.664-.3726.939-.6244.041-.0406.0814-.0808.1301-.1138.3405-.2106.5912-.5027.8184-.8272.2592-.3731.4294-.7952.6403-1.1927a.8439.8439 0 0 1 .0483-.089zm1.1343.0734a.5457.5457 0 0 1 .0326.0812c.04-.008.0567-.008.0727-.0162 0-.008-.0001-.0159.0081-.0245l-.0003-.0003c-.024-.008-.0562-.0238-.1132-.0401zm.0235.0737c-.001 0-.0031.002-.0072.006l.0003.001c.0077 0 .016.008.016.008l-.008-.009c0-.004 0-.006-.001-.006zm-16.535.0316c-.0161 0-.065.0246-.073.0326.0324.081.073.1704.1054.2517.0079-.008.0565-.0323.0645-.0323-.0325-.081-.0646-.1703-.0968-.252zm-.2275.3329c-.024.0407-.0484.0808-.04.1128 0 .0243.0402.0484.0648.073.0002-.008.0078-.0159.016-.0235-.016-.0569-.0241-.1057-.0407-.1624zm21.6571.008c0 .0161.008.0398 0 .0564zm-21.2358.1784c-.008 0-.0647.0243-.0727.0326.0646.1376.1293.284.194.4219l.0003-.0004c.0083 0 .073-.0323.073-.0323-.0652-.1385-.1053-.2926-.1946-.4219zm-.1617.3244c0 .032-.0408.024-.0408.0564-.048 0-.0886-.008-.1291-.008-.008.008.0243.0569.0326.0652h.1699c0-.041-.0078-.0731-.0078-.1138zm7.453.3162c.0894.138.179.2679.276.3972h.0003l-.0081.008c-.017-.008-.0414-.0161-.0574-.0323l-.1943-.2925c-.016-.024-.025-.0485-.0163-.0809zm9.043.4383l-.0003.0003c-.0079.0973-.0162.1703-.0162.2432 0 .0162.0164.0483.0248.0483.016.009.0482-.008.0645-.0153.008-.008.016-.0243.016-.0326-.0243-.0166-.048-.0245-.0726-.0414.1539-.081 0-.1215-.016-.2025zM3.4845 20.2004c.0884.0976.1777.195.2667.3006-.0487-.0246-.1054-.0407-.1294-.0734-.0567-.0647-.1051-.1378-.1618-.2025zm.34.2843c.0247.0406.0406.0893.0646.138-.1133-.008-.17-.057-.1376-.1217.0246-.008.0491-.008.073-.0162zm15.4349 1.2422c-.0653.0153-.114.0241-.154.0401-.0165.0326-.0329.0567-.0492.089.0083 0 .0164.008.0248.0162.0487-.0487.105-.089.1784-.1454zm-.4145.226c-.0892.057-.1862.1136-.2755.1702.008.008.008.0168.0166.0248.1133-.0243.2026-.0814.2918-.146l-.0003-.0007c-.0079-.0162-.0243-.033-.0326-.0483zm-3.9686 1.5425c-.3726.1053-.4944.1212-.535.0645.1864-.0246.3571-.0406.535-.0645zm-.5517.0727c.0083.0161.0083.0322.0162.0482-.0486 0-.081.0168-.1216.0245l-.0003-.0003c-.113.0246-.2346.0411-.3479.0574-.0407.008-.0893.0488-.1053-.0245-.0162.008-.0326.008-.0486.0166.04.1213.1378.0237.2188.0724-.1786.0246-.3479.0409-.5184.0649v-.0161c.0492-.008.1055-.0164.1539-.0248v-.0241c-.0807-.008-.1617-.0162-.2433-.0162-.0237 0-.0565.0328-.0808.0408-.0324.008-.0647.0162-.1053.0162-.1377.008-.275.008-.405.0161-.0083 0-.0246-.008-.0326-.008v-.0248c.5428-.0727 1.0773-.1455 1.6201-.2185zm-1.6932.2103v.0238a4.3587 4.3587 0 0 1-.4535.0486v-.0238c.154-.016.2996-.0326.4535-.0486z"/></svg>""",
    guidelines=None,
    license=None,
)
