"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeoRestriction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Controls the countries in which content is distributed.
 */
class GeoRestriction {
    /**
     * Creates an instance of GeoRestriction for internal use
     *
     * @param restrictionType Specifies the restriction type to impose
     * @param locations Two-letter, uppercase country code for a country
     * that you want to allow/deny. Include one element for each country.
     * See ISO 3166-1-alpha-2 code on the *International Organization for Standardization* website
     */
    constructor(restrictionType, locations) {
        this.restrictionType = restrictionType;
        this.locations = locations;
    }
    /**
     * Allow specific countries which you want CloudFront to distribute your content.
     *
     * @param locations Two-letter, uppercase country code for a country
     * that you want to allow. Include one element for each country.
     * See ISO 3166-1-alpha-2 code on the *International Organization for Standardization* website
     */
    static allowlist(...locations) {
        return new GeoRestriction('whitelist', GeoRestriction.validateLocations(locations));
    }
    /**
     * Deny specific countries which you don't want CloudFront to distribute your content.
     *
     * @param locations Two-letter, uppercase country code for a country
     * that you want to deny. Include one element for each country.
     * See ISO 3166-1-alpha-2 code on the *International Organization for Standardization* website
     */
    static denylist(...locations) {
        return new GeoRestriction('blacklist', GeoRestriction.validateLocations(locations));
    }
    /**
     * DEPRECATED
     * @deprecated use `allowlist`
     */
    static whitelist(...locations) {
        jsiiDeprecationWarnings.print("@aws-cdk/aws-cloudfront.GeoRestriction#whitelist", "use `allowlist`");
        return GeoRestriction.allowlist(...locations);
    }
    /**
     * DEPRECATED
     * @deprecated use `denylist`
     */
    static blacklist(...locations) {
        jsiiDeprecationWarnings.print("@aws-cdk/aws-cloudfront.GeoRestriction#blacklist", "use `denylist`");
        return GeoRestriction.denylist(...locations);
    }
    static validateLocations(locations) {
        if (locations.length === 0) {
            throw new Error('Should provide at least 1 location');
        }
        locations.forEach(location => {
            if (!GeoRestriction.LOCATION_REGEX.test(location)) {
                // eslint-disable-next-line max-len
                throw new Error(`Invalid location format for location: ${location}, location should be two-letter and uppercase country ISO 3166-1-alpha-2 code`);
            }
        });
        return locations;
    }
}
exports.GeoRestriction = GeoRestriction;
_a = JSII_RTTI_SYMBOL_1;
GeoRestriction[_a] = { fqn: "@aws-cdk/aws-cloudfront.GeoRestriction", version: "1.149.0" };
GeoRestriction.LOCATION_REGEX = /^[A-Z]{2}$/;
//# sourceMappingURL=data:application/json;base64,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