# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ncbi.datasets.openapi.api_client import ApiClient
from ncbi.datasets.openapi.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class GenomeApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def assembly_descriptors_by_accessions(self, accessions, **kwargs):  # noqa: E501
        """Get genome metadata by accession  # noqa: E501

        Get detailed metadata for assembled genomes by accession in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assembly_descriptors_by_accessions(accessions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] accessions: (required)
        :param bool filters_reference_only: If true, only return reference and representative (GCF_ and GCA_) genome assemblies.
        :param str filters_assembly_source: Return only RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :param bool filters_has_annotation: Return only annotated genome assemblies.
        :param list[str] filters_assembly_level: Only return genome assemblies that have one of the specified assembly levels.
        :param datetime filters_first_release_date: Only return genome assemblies that were released on or after the specified date.
        :param datetime filters_last_release_date: Only return genome assemblies that were released on or before to the specified date.
        :param list[str] filters_search_text: Only return results whose fields contain the specified search terms in their taxon, infraspecific, assembly name or submitter fields.
        :param int page_size: The maximum number of genome assemblies to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size,  `page_token` can be used to retrieve the remaining results.
        :param str page_token: A page token is returned from an `AssemblyMetadataRequest` call with more than `page_size` results. Use this token, along with the previous  `AssemblyMetadataRequest` parameters, to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1AssemblyMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.assembly_descriptors_by_accessions_with_http_info(accessions, **kwargs)  # noqa: E501

    def assembly_descriptors_by_accessions_with_http_info(self, accessions, **kwargs):  # noqa: E501
        """Get genome metadata by accession  # noqa: E501

        Get detailed metadata for assembled genomes by accession in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assembly_descriptors_by_accessions_with_http_info(accessions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] accessions: (required)
        :param bool filters_reference_only: If true, only return reference and representative (GCF_ and GCA_) genome assemblies.
        :param str filters_assembly_source: Return only RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :param bool filters_has_annotation: Return only annotated genome assemblies.
        :param list[str] filters_assembly_level: Only return genome assemblies that have one of the specified assembly levels.
        :param datetime filters_first_release_date: Only return genome assemblies that were released on or after the specified date.
        :param datetime filters_last_release_date: Only return genome assemblies that were released on or before to the specified date.
        :param list[str] filters_search_text: Only return results whose fields contain the specified search terms in their taxon, infraspecific, assembly name or submitter fields.
        :param int page_size: The maximum number of genome assemblies to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size,  `page_token` can be used to retrieve the remaining results.
        :param str page_token: A page token is returned from an `AssemblyMetadataRequest` call with more than `page_size` results. Use this token, along with the previous  `AssemblyMetadataRequest` parameters, to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1AssemblyMetadata, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'accessions',
            'filters_reference_only',
            'filters_assembly_source',
            'filters_has_annotation',
            'filters_assembly_level',
            'filters_first_release_date',
            'filters_last_release_date',
            'filters_search_text',
            'page_size',
            'page_token'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assembly_descriptors_by_accessions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'accessions' is set
        if self.api_client.client_side_validation and ('accessions' not in local_var_params or  # noqa: E501
                                                        local_var_params['accessions'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `accessions` when calling `assembly_descriptors_by_accessions`")  # noqa: E501

        if self.api_client.client_side_validation and ('accessions' in local_var_params and  # noqa: E501
                                                        len(local_var_params['accessions']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `accessions` when calling `assembly_descriptors_by_accessions`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'accessions' in local_var_params:
            path_params['accessions'] = local_var_params['accessions']  # noqa: E501
            collection_formats['accessions'] = 'csv'  # noqa: E501

        query_params = []
        if 'filters_reference_only' in local_var_params and local_var_params['filters_reference_only'] is not None:  # noqa: E501
            query_params.append(('filters.reference_only', local_var_params['filters_reference_only']))  # noqa: E501
        if 'filters_assembly_source' in local_var_params and local_var_params['filters_assembly_source'] is not None:  # noqa: E501
            query_params.append(('filters.assembly_source', local_var_params['filters_assembly_source']))  # noqa: E501
        if 'filters_has_annotation' in local_var_params and local_var_params['filters_has_annotation'] is not None:  # noqa: E501
            query_params.append(('filters.has_annotation', local_var_params['filters_has_annotation']))  # noqa: E501
        if 'filters_assembly_level' in local_var_params and local_var_params['filters_assembly_level'] is not None:  # noqa: E501
            query_params.append(('filters.assembly_level', local_var_params['filters_assembly_level']))  # noqa: E501
            collection_formats['filters.assembly_level'] = 'multi'  # noqa: E501
        if 'filters_first_release_date' in local_var_params and local_var_params['filters_first_release_date'] is not None:  # noqa: E501
            query_params.append(('filters.first_release_date', local_var_params['filters_first_release_date']))  # noqa: E501
        if 'filters_last_release_date' in local_var_params and local_var_params['filters_last_release_date'] is not None:  # noqa: E501
            query_params.append(('filters.last_release_date', local_var_params['filters_last_release_date']))  # noqa: E501
        if 'filters_search_text' in local_var_params and local_var_params['filters_search_text'] is not None:  # noqa: E501
            query_params.append(('filters.search_text', local_var_params['filters_search_text']))  # noqa: E501
            collection_formats['filters.search_text'] = 'multi'  # noqa: E501
        if 'page_size' in local_var_params and local_var_params['page_size'] is not None:  # noqa: E501
            query_params.append(('page_size', local_var_params['page_size']))  # noqa: E501
        if 'page_token' in local_var_params and local_var_params['page_token'] is not None:  # noqa: E501
            query_params.append(('page_token', local_var_params['page_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/genome/accession/{accessions}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1AssemblyMetadata',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def assembly_descriptors_by_bioproject(self, accessions, **kwargs):  # noqa: E501
        """Get genome metadata by bioproject accession  # noqa: E501

        Get detailed metadata for assembled genomes by bioproject accession in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assembly_descriptors_by_bioproject(accessions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] accessions: (required)
        :param bool filters_reference_only: If true, only return reference and representative (GCF_ and GCA_) genome assemblies.
        :param str filters_assembly_source: Return only RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :param bool filters_has_annotation: Return only annotated genome assemblies.
        :param list[str] filters_assembly_level: Only return genome assemblies that have one of the specified assembly levels.
        :param datetime filters_first_release_date: Only return genome assemblies that were released on or after the specified date.
        :param datetime filters_last_release_date: Only return genome assemblies that were released on or before to the specified date.
        :param list[str] filters_search_text: Only return results whose fields contain the specified search terms in their taxon, infraspecific, assembly name or submitter fields.
        :param str returned_content: Return either assembly accessions, or entire assembly-metadata records.
        :param int page_size: The maximum number of genome assemblies to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size,  `page_token` can be used to retrieve the remaining results.
        :param str page_token: A page token is returned from an `AssemblyMetadataRequest` call with more than `page_size` results. Use this token, along with the previous  `AssemblyMetadataRequest` parameters, to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1AssemblyMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.assembly_descriptors_by_bioproject_with_http_info(accessions, **kwargs)  # noqa: E501

    def assembly_descriptors_by_bioproject_with_http_info(self, accessions, **kwargs):  # noqa: E501
        """Get genome metadata by bioproject accession  # noqa: E501

        Get detailed metadata for assembled genomes by bioproject accession in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assembly_descriptors_by_bioproject_with_http_info(accessions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] accessions: (required)
        :param bool filters_reference_only: If true, only return reference and representative (GCF_ and GCA_) genome assemblies.
        :param str filters_assembly_source: Return only RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :param bool filters_has_annotation: Return only annotated genome assemblies.
        :param list[str] filters_assembly_level: Only return genome assemblies that have one of the specified assembly levels.
        :param datetime filters_first_release_date: Only return genome assemblies that were released on or after the specified date.
        :param datetime filters_last_release_date: Only return genome assemblies that were released on or before to the specified date.
        :param list[str] filters_search_text: Only return results whose fields contain the specified search terms in their taxon, infraspecific, assembly name or submitter fields.
        :param str returned_content: Return either assembly accessions, or entire assembly-metadata records.
        :param int page_size: The maximum number of genome assemblies to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size,  `page_token` can be used to retrieve the remaining results.
        :param str page_token: A page token is returned from an `AssemblyMetadataRequest` call with more than `page_size` results. Use this token, along with the previous  `AssemblyMetadataRequest` parameters, to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1AssemblyMetadata, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'accessions',
            'filters_reference_only',
            'filters_assembly_source',
            'filters_has_annotation',
            'filters_assembly_level',
            'filters_first_release_date',
            'filters_last_release_date',
            'filters_search_text',
            'returned_content',
            'page_size',
            'page_token'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assembly_descriptors_by_bioproject" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'accessions' is set
        if self.api_client.client_side_validation and ('accessions' not in local_var_params or  # noqa: E501
                                                        local_var_params['accessions'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `accessions` when calling `assembly_descriptors_by_bioproject`")  # noqa: E501

        if self.api_client.client_side_validation and ('accessions' in local_var_params and  # noqa: E501
                                                        len(local_var_params['accessions']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `accessions` when calling `assembly_descriptors_by_bioproject`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'accessions' in local_var_params:
            path_params['accessions'] = local_var_params['accessions']  # noqa: E501
            collection_formats['accessions'] = 'csv'  # noqa: E501

        query_params = []
        if 'filters_reference_only' in local_var_params and local_var_params['filters_reference_only'] is not None:  # noqa: E501
            query_params.append(('filters.reference_only', local_var_params['filters_reference_only']))  # noqa: E501
        if 'filters_assembly_source' in local_var_params and local_var_params['filters_assembly_source'] is not None:  # noqa: E501
            query_params.append(('filters.assembly_source', local_var_params['filters_assembly_source']))  # noqa: E501
        if 'filters_has_annotation' in local_var_params and local_var_params['filters_has_annotation'] is not None:  # noqa: E501
            query_params.append(('filters.has_annotation', local_var_params['filters_has_annotation']))  # noqa: E501
        if 'filters_assembly_level' in local_var_params and local_var_params['filters_assembly_level'] is not None:  # noqa: E501
            query_params.append(('filters.assembly_level', local_var_params['filters_assembly_level']))  # noqa: E501
            collection_formats['filters.assembly_level'] = 'multi'  # noqa: E501
        if 'filters_first_release_date' in local_var_params and local_var_params['filters_first_release_date'] is not None:  # noqa: E501
            query_params.append(('filters.first_release_date', local_var_params['filters_first_release_date']))  # noqa: E501
        if 'filters_last_release_date' in local_var_params and local_var_params['filters_last_release_date'] is not None:  # noqa: E501
            query_params.append(('filters.last_release_date', local_var_params['filters_last_release_date']))  # noqa: E501
        if 'filters_search_text' in local_var_params and local_var_params['filters_search_text'] is not None:  # noqa: E501
            query_params.append(('filters.search_text', local_var_params['filters_search_text']))  # noqa: E501
            collection_formats['filters.search_text'] = 'multi'  # noqa: E501
        if 'returned_content' in local_var_params and local_var_params['returned_content'] is not None:  # noqa: E501
            query_params.append(('returned_content', local_var_params['returned_content']))  # noqa: E501
        if 'page_size' in local_var_params and local_var_params['page_size'] is not None:  # noqa: E501
            query_params.append(('page_size', local_var_params['page_size']))  # noqa: E501
        if 'page_token' in local_var_params and local_var_params['page_token'] is not None:  # noqa: E501
            query_params.append(('page_token', local_var_params['page_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/genome/bioproject/{accessions}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1AssemblyMetadata',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def assembly_descriptors_by_taxon(self, taxon, **kwargs):  # noqa: E501
        """Get genome metadata by taxonomic identifier  # noqa: E501

        Get detailed metadata on all assembled genomes for a specified NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assembly_descriptors_by_taxon(taxon, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :param bool filters_reference_only: If true, only return reference and representative (GCF_ and GCA_) genome assemblies.
        :param str filters_assembly_source: Return only RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :param bool filters_has_annotation: Return only annotated genome assemblies.
        :param list[str] filters_assembly_level: Only return genome assemblies that have one of the specified assembly levels.
        :param datetime filters_first_release_date: Only return genome assemblies that were released on or after the specified date.
        :param datetime filters_last_release_date: Only return genome assemblies that were released on or before to the specified date.
        :param list[str] filters_search_text: Only return results whose fields contain the specified search terms in their taxon, infraspecific, assembly name or submitter fields.
        :param bool tax_exact_match: If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too. Ignored for assembly_accession request.
        :param str returned_content: Return either assembly accessions, or entire assembly-metadata records.
        :param int page_size: The maximum number of genome assemblies to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size,  `page_token` can be used to retrieve the remaining results.
        :param str page_token: A page token is returned from an `AssemblyMetadataRequest` call with more than `page_size` results. Use this token, along with the previous  `AssemblyMetadataRequest` parameters, to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1AssemblyMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.assembly_descriptors_by_taxon_with_http_info(taxon, **kwargs)  # noqa: E501

    def assembly_descriptors_by_taxon_with_http_info(self, taxon, **kwargs):  # noqa: E501
        """Get genome metadata by taxonomic identifier  # noqa: E501

        Get detailed metadata on all assembled genomes for a specified NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assembly_descriptors_by_taxon_with_http_info(taxon, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :param bool filters_reference_only: If true, only return reference and representative (GCF_ and GCA_) genome assemblies.
        :param str filters_assembly_source: Return only RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :param bool filters_has_annotation: Return only annotated genome assemblies.
        :param list[str] filters_assembly_level: Only return genome assemblies that have one of the specified assembly levels.
        :param datetime filters_first_release_date: Only return genome assemblies that were released on or after the specified date.
        :param datetime filters_last_release_date: Only return genome assemblies that were released on or before to the specified date.
        :param list[str] filters_search_text: Only return results whose fields contain the specified search terms in their taxon, infraspecific, assembly name or submitter fields.
        :param bool tax_exact_match: If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too. Ignored for assembly_accession request.
        :param str returned_content: Return either assembly accessions, or entire assembly-metadata records.
        :param int page_size: The maximum number of genome assemblies to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size,  `page_token` can be used to retrieve the remaining results.
        :param str page_token: A page token is returned from an `AssemblyMetadataRequest` call with more than `page_size` results. Use this token, along with the previous  `AssemblyMetadataRequest` parameters, to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1AssemblyMetadata, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'taxon',
            'filters_reference_only',
            'filters_assembly_source',
            'filters_has_annotation',
            'filters_assembly_level',
            'filters_first_release_date',
            'filters_last_release_date',
            'filters_search_text',
            'tax_exact_match',
            'returned_content',
            'page_size',
            'page_token'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assembly_descriptors_by_taxon" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'taxon' is set
        if self.api_client.client_side_validation and ('taxon' not in local_var_params or  # noqa: E501
                                                        local_var_params['taxon'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `taxon` when calling `assembly_descriptors_by_taxon`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'taxon' in local_var_params:
            path_params['taxon'] = local_var_params['taxon']  # noqa: E501

        query_params = []
        if 'filters_reference_only' in local_var_params and local_var_params['filters_reference_only'] is not None:  # noqa: E501
            query_params.append(('filters.reference_only', local_var_params['filters_reference_only']))  # noqa: E501
        if 'filters_assembly_source' in local_var_params and local_var_params['filters_assembly_source'] is not None:  # noqa: E501
            query_params.append(('filters.assembly_source', local_var_params['filters_assembly_source']))  # noqa: E501
        if 'filters_has_annotation' in local_var_params and local_var_params['filters_has_annotation'] is not None:  # noqa: E501
            query_params.append(('filters.has_annotation', local_var_params['filters_has_annotation']))  # noqa: E501
        if 'filters_assembly_level' in local_var_params and local_var_params['filters_assembly_level'] is not None:  # noqa: E501
            query_params.append(('filters.assembly_level', local_var_params['filters_assembly_level']))  # noqa: E501
            collection_formats['filters.assembly_level'] = 'multi'  # noqa: E501
        if 'filters_first_release_date' in local_var_params and local_var_params['filters_first_release_date'] is not None:  # noqa: E501
            query_params.append(('filters.first_release_date', local_var_params['filters_first_release_date']))  # noqa: E501
        if 'filters_last_release_date' in local_var_params and local_var_params['filters_last_release_date'] is not None:  # noqa: E501
            query_params.append(('filters.last_release_date', local_var_params['filters_last_release_date']))  # noqa: E501
        if 'filters_search_text' in local_var_params and local_var_params['filters_search_text'] is not None:  # noqa: E501
            query_params.append(('filters.search_text', local_var_params['filters_search_text']))  # noqa: E501
            collection_formats['filters.search_text'] = 'multi'  # noqa: E501
        if 'tax_exact_match' in local_var_params and local_var_params['tax_exact_match'] is not None:  # noqa: E501
            query_params.append(('tax_exact_match', local_var_params['tax_exact_match']))  # noqa: E501
        if 'returned_content' in local_var_params and local_var_params['returned_content'] is not None:  # noqa: E501
            query_params.append(('returned_content', local_var_params['returned_content']))  # noqa: E501
        if 'page_size' in local_var_params and local_var_params['page_size'] is not None:  # noqa: E501
            query_params.append(('page_size', local_var_params['page_size']))  # noqa: E501
        if 'page_token' in local_var_params and local_var_params['page_token'] is not None:  # noqa: E501
            query_params.append(('page_token', local_var_params['page_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/genome/taxon/{taxon}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1AssemblyMetadata',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def check_assembly_availability(self, accessions, **kwargs):  # noqa: E501
        """Check the validity of genome accessions  # noqa: E501

        The 'GET' version of check is limited by the size of the GET URL (2KB, which works out to about 140 genomic accessions).  The POST operation is provided to allow users to supply a larger number of accessions in a single request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.check_assembly_availability(accessions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] accessions: NCBI genome assembly accessions (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1AssemblyDatasetAvailability
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.check_assembly_availability_with_http_info(accessions, **kwargs)  # noqa: E501

    def check_assembly_availability_with_http_info(self, accessions, **kwargs):  # noqa: E501
        """Check the validity of genome accessions  # noqa: E501

        The 'GET' version of check is limited by the size of the GET URL (2KB, which works out to about 140 genomic accessions).  The POST operation is provided to allow users to supply a larger number of accessions in a single request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.check_assembly_availability_with_http_info(accessions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] accessions: NCBI genome assembly accessions (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1AssemblyDatasetAvailability, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'accessions'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method check_assembly_availability" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'accessions' is set
        if self.api_client.client_side_validation and ('accessions' not in local_var_params or  # noqa: E501
                                                        local_var_params['accessions'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `accessions` when calling `check_assembly_availability`")  # noqa: E501

        if self.api_client.client_side_validation and ('accessions' in local_var_params and  # noqa: E501
                                                        len(local_var_params['accessions']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `accessions` when calling `check_assembly_availability`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'accessions' in local_var_params:
            path_params['accessions'] = local_var_params['accessions']  # noqa: E501
            collection_formats['accessions'] = 'csv'  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/genome/accession/{accessions}/check', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1AssemblyDatasetAvailability',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def check_assembly_availability_post(self, body, **kwargs):  # noqa: E501
        """Check the validity of many genome accessions in a single request  # noqa: E501

        The 'GET' version of check is limited by the size of the GET URL (2KB, which works out to about 140 genomic accessions).  The POST operation is provided to allow users to supply a larger number of accessions in a single request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.check_assembly_availability_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param V1alpha1AssemblyDatasetRequest body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1AssemblyDatasetAvailability
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.check_assembly_availability_post_with_http_info(body, **kwargs)  # noqa: E501

    def check_assembly_availability_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Check the validity of many genome accessions in a single request  # noqa: E501

        The 'GET' version of check is limited by the size of the GET URL (2KB, which works out to about 140 genomic accessions).  The POST operation is provided to allow users to supply a larger number of accessions in a single request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.check_assembly_availability_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param V1alpha1AssemblyDatasetRequest body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1AssemblyDatasetAvailability, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method check_assembly_availability_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `check_assembly_availability_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/genome/check', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1AssemblyDatasetAvailability',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_assembly_package(self, accessions, **kwargs):  # noqa: E501
        """Get a genome dataset by accession  # noqa: E501

        Download a genome dataset including fasta sequence, annotation and a detailed data report by accession.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_assembly_package(accessions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] accessions: NCBI genome assembly accessions (required)
        :param list[str] chromosomes: The default setting is all chromosome. Specify individual chromosome by string (1,2,MT or chr1,chr2.chrMT). Unplaced sequences are treated like their own chromosome ('Un'). The filter only applies to fasta sequence.
        :param bool exclude_sequence: Set to true to omit the genomic sequence.
        :param list[str] include_annotation_type: Select additional types of annotation to include in the data package.  If unset, no annotation is provided.
        :param str hydrated: Set to DATA_REPORT_ONLY, to only retrieve data-reports.
        :param str filename: Output file name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.download_assembly_package_with_http_info(accessions, **kwargs)  # noqa: E501

    def download_assembly_package_with_http_info(self, accessions, **kwargs):  # noqa: E501
        """Get a genome dataset by accession  # noqa: E501

        Download a genome dataset including fasta sequence, annotation and a detailed data report by accession.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_assembly_package_with_http_info(accessions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] accessions: NCBI genome assembly accessions (required)
        :param list[str] chromosomes: The default setting is all chromosome. Specify individual chromosome by string (1,2,MT or chr1,chr2.chrMT). Unplaced sequences are treated like their own chromosome ('Un'). The filter only applies to fasta sequence.
        :param bool exclude_sequence: Set to true to omit the genomic sequence.
        :param list[str] include_annotation_type: Select additional types of annotation to include in the data package.  If unset, no annotation is provided.
        :param str hydrated: Set to DATA_REPORT_ONLY, to only retrieve data-reports.
        :param str filename: Output file name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'accessions',
            'chromosomes',
            'exclude_sequence',
            'include_annotation_type',
            'hydrated',
            'filename'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_assembly_package" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'accessions' is set
        if self.api_client.client_side_validation and ('accessions' not in local_var_params or  # noqa: E501
                                                        local_var_params['accessions'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `accessions` when calling `download_assembly_package`")  # noqa: E501

        if self.api_client.client_side_validation and ('accessions' in local_var_params and  # noqa: E501
                                                        len(local_var_params['accessions']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `accessions` when calling `download_assembly_package`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'accessions' in local_var_params:
            path_params['accessions'] = local_var_params['accessions']  # noqa: E501
            collection_formats['accessions'] = 'csv'  # noqa: E501

        query_params = []
        if 'chromosomes' in local_var_params and local_var_params['chromosomes'] is not None:  # noqa: E501
            query_params.append(('chromosomes', local_var_params['chromosomes']))  # noqa: E501
            collection_formats['chromosomes'] = 'multi'  # noqa: E501
        if 'exclude_sequence' in local_var_params and local_var_params['exclude_sequence'] is not None:  # noqa: E501
            query_params.append(('exclude_sequence', local_var_params['exclude_sequence']))  # noqa: E501
        if 'include_annotation_type' in local_var_params and local_var_params['include_annotation_type'] is not None:  # noqa: E501
            query_params.append(('include_annotation_type', local_var_params['include_annotation_type']))  # noqa: E501
            collection_formats['include_annotation_type'] = 'multi'  # noqa: E501
        if 'hydrated' in local_var_params and local_var_params['hydrated'] is not None:  # noqa: E501
            query_params.append(('hydrated', local_var_params['hydrated']))  # noqa: E501
        if 'filename' in local_var_params and local_var_params['filename'] is not None:  # noqa: E501
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/zip'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/genome/accession/{accessions}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_assembly_package_post(self, body, **kwargs):  # noqa: E501
        """Get a genome dataset by post  # noqa: E501

        The 'GET' version of download is limited by the size of the GET URL (2KB, which works out to about 140 genomic accessions).  The POST operation is provided to allow users to supply a larger number of accessions in a single request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_assembly_package_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param V1alpha1AssemblyDatasetRequest body: (required)
        :param str filename: Output file name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.download_assembly_package_post_with_http_info(body, **kwargs)  # noqa: E501

    def download_assembly_package_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get a genome dataset by post  # noqa: E501

        The 'GET' version of download is limited by the size of the GET URL (2KB, which works out to about 140 genomic accessions).  The POST operation is provided to allow users to supply a larger number of accessions in a single request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_assembly_package_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param V1alpha1AssemblyDatasetRequest body: (required)
        :param str filename: Output file name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'body',
            'filename'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_assembly_package_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `download_assembly_package_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filename' in local_var_params and local_var_params['filename'] is not None:  # noqa: E501
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/zip'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/genome/download', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def genome_download_summary(self, accessions, **kwargs):  # noqa: E501
        """Preview genome dataset download  # noqa: E501

        Get a download summary by accession in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.genome_download_summary(accessions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] accessions: NCBI genome assembly accessions (required)
        :param list[str] chromosomes: The default setting is all chromosome. Specify individual chromosome by string (1,2,MT or chr1,chr2.chrMT). Unplaced sequences are treated like their own chromosome ('Un'). The filter only applies to fasta sequence.
        :param bool exclude_sequence: Set to true to omit the genomic sequence.
        :param list[str] include_annotation_type: Select additional types of annotation to include in the data package.  If unset, no annotation is provided.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1DownloadSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.genome_download_summary_with_http_info(accessions, **kwargs)  # noqa: E501

    def genome_download_summary_with_http_info(self, accessions, **kwargs):  # noqa: E501
        """Preview genome dataset download  # noqa: E501

        Get a download summary by accession in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.genome_download_summary_with_http_info(accessions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] accessions: NCBI genome assembly accessions (required)
        :param list[str] chromosomes: The default setting is all chromosome. Specify individual chromosome by string (1,2,MT or chr1,chr2.chrMT). Unplaced sequences are treated like their own chromosome ('Un'). The filter only applies to fasta sequence.
        :param bool exclude_sequence: Set to true to omit the genomic sequence.
        :param list[str] include_annotation_type: Select additional types of annotation to include in the data package.  If unset, no annotation is provided.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1DownloadSummary, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'accessions',
            'chromosomes',
            'exclude_sequence',
            'include_annotation_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method genome_download_summary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'accessions' is set
        if self.api_client.client_side_validation and ('accessions' not in local_var_params or  # noqa: E501
                                                        local_var_params['accessions'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `accessions` when calling `genome_download_summary`")  # noqa: E501

        if self.api_client.client_side_validation and ('accessions' in local_var_params and  # noqa: E501
                                                        len(local_var_params['accessions']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `accessions` when calling `genome_download_summary`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'accessions' in local_var_params:
            path_params['accessions'] = local_var_params['accessions']  # noqa: E501
            collection_formats['accessions'] = 'csv'  # noqa: E501

        query_params = []
        if 'chromosomes' in local_var_params and local_var_params['chromosomes'] is not None:  # noqa: E501
            query_params.append(('chromosomes', local_var_params['chromosomes']))  # noqa: E501
            collection_formats['chromosomes'] = 'multi'  # noqa: E501
        if 'exclude_sequence' in local_var_params and local_var_params['exclude_sequence'] is not None:  # noqa: E501
            query_params.append(('exclude_sequence', local_var_params['exclude_sequence']))  # noqa: E501
        if 'include_annotation_type' in local_var_params and local_var_params['include_annotation_type'] is not None:  # noqa: E501
            query_params.append(('include_annotation_type', local_var_params['include_annotation_type']))  # noqa: E501
            collection_formats['include_annotation_type'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/genome/accession/{accessions}/download_summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1DownloadSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def genome_download_summary_by_post(self, body, **kwargs):  # noqa: E501
        """Preview genome dataset download by POST  # noqa: E501

        The 'GET' version of download summary is limited by the size of the GET URL (2KB, which works out to about 140 genomic accessions).  The POST operation is provided to allow users to supply a larger number of accessions in a single request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.genome_download_summary_by_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param V1alpha1AssemblyDatasetRequest body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1DownloadSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.genome_download_summary_by_post_with_http_info(body, **kwargs)  # noqa: E501

    def genome_download_summary_by_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Preview genome dataset download by POST  # noqa: E501

        The 'GET' version of download summary is limited by the size of the GET URL (2KB, which works out to about 140 genomic accessions).  The POST operation is provided to allow users to supply a larger number of accessions in a single request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.genome_download_summary_by_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param V1alpha1AssemblyDatasetRequest body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1DownloadSummary, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method genome_download_summary_by_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `genome_download_summary_by_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/genome/download_summary', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1DownloadSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def genome_metadata_by_post(self, body, **kwargs):  # noqa: E501
        """Get genome metadata by accession  # noqa: E501

        Get detailed metadata for assembled genomes by accession in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.genome_metadata_by_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param V1alpha1AssemblyMetadataRequest body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1AssemblyMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.genome_metadata_by_post_with_http_info(body, **kwargs)  # noqa: E501

    def genome_metadata_by_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get genome metadata by accession  # noqa: E501

        Get detailed metadata for assembled genomes by accession in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.genome_metadata_by_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param V1alpha1AssemblyMetadataRequest body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1AssemblyMetadata, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method genome_metadata_by_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `genome_metadata_by_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/genome', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1AssemblyMetadata',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def genome_tax_name_query(self, taxon_query, **kwargs):  # noqa: E501
        """Get a list of taxonomy names and IDs found in the assembly dataset given a partial taxonomic name.  # noqa: E501

        This endpoint retrieves a list of taxonomy names and IDs found in the assembly dataset given a partial taxonomic name of any rank.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.genome_tax_name_query(taxon_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str taxon_query: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :param str tax_rank_filter: Set the scope of searched tax ranks.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1SciNameAndIds
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.genome_tax_name_query_with_http_info(taxon_query, **kwargs)  # noqa: E501

    def genome_tax_name_query_with_http_info(self, taxon_query, **kwargs):  # noqa: E501
        """Get a list of taxonomy names and IDs found in the assembly dataset given a partial taxonomic name.  # noqa: E501

        This endpoint retrieves a list of taxonomy names and IDs found in the assembly dataset given a partial taxonomic name of any rank.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.genome_tax_name_query_with_http_info(taxon_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str taxon_query: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :param str tax_rank_filter: Set the scope of searched tax ranks.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1SciNameAndIds, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'taxon_query',
            'tax_rank_filter'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method genome_tax_name_query" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'taxon_query' is set
        if self.api_client.client_side_validation and ('taxon_query' not in local_var_params or  # noqa: E501
                                                        local_var_params['taxon_query'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `taxon_query` when calling `genome_tax_name_query`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'taxon_query' in local_var_params:
            path_params['taxon_query'] = local_var_params['taxon_query']  # noqa: E501

        query_params = []
        if 'tax_rank_filter' in local_var_params and local_var_params['tax_rank_filter'] is not None:  # noqa: E501
            query_params.append(('tax_rank_filter', local_var_params['tax_rank_filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/genome/taxon_suggest/{taxon_query}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1SciNameAndIds',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def genome_tax_tree(self, taxon, **kwargs):  # noqa: E501
        """Get a taxonomic subtree by taxonomic identifier  # noqa: E501

        Using a NCBI Taxonomy ID or name (common or scientific) at any rank, get a subtree filtered for species with assembled genomes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.genome_tax_tree(taxon, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :param bool children_only: Only report the children of the requested taxon and not their descendants.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1Organism
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.genome_tax_tree_with_http_info(taxon, **kwargs)  # noqa: E501

    def genome_tax_tree_with_http_info(self, taxon, **kwargs):  # noqa: E501
        """Get a taxonomic subtree by taxonomic identifier  # noqa: E501

        Using a NCBI Taxonomy ID or name (common or scientific) at any rank, get a subtree filtered for species with assembled genomes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.genome_tax_tree_with_http_info(taxon, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :param bool children_only: Only report the children of the requested taxon and not their descendants.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1Organism, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'taxon',
            'children_only'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method genome_tax_tree" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'taxon' is set
        if self.api_client.client_side_validation and ('taxon' not in local_var_params or  # noqa: E501
                                                        local_var_params['taxon'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `taxon` when calling `genome_tax_tree`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'taxon' in local_var_params:
            path_params['taxon'] = local_var_params['taxon']  # noqa: E501

        query_params = []
        if 'children_only' in local_var_params and local_var_params['children_only'] is not None:  # noqa: E501
            query_params.append(('children_only', local_var_params['children_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/genome/taxon/{taxon}/tree', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1Organism',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
