# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Subnet(pulumi.CustomResource):
    internet_id: pulumi.Output[str]
    """
    The id of the switch+router resource that the subnet belongs
    """
    ip_addresses: pulumi.Output[list]
    """
    A list of assigned global address to the subnet
    """
    max_ip_address: pulumi.Output[str]
    """
    Maximum IP address in assigned global addresses to the subnet
    """
    min_ip_address: pulumi.Output[str]
    """
    Minimum IP address in assigned global addresses to the subnet
    """
    netmask: pulumi.Output[float]
    """
    The bit length of the subnet to assign to the Subnet. This must be in the range [`26`-`28`]
    """
    network_address: pulumi.Output[str]
    """
    The IPv4 network address assigned to the Subnet
    """
    next_hop: pulumi.Output[str]
    """
    The ip address of the next-hop at the subnet
    """
    switch_id: pulumi.Output[str]
    """
    The id of the switch connected from the Subnet
    """
    zone: pulumi.Output[str]
    """
    The name of zone that the Subnet will be created (e.g. `is1a`, `tk1a`)
    """
    def __init__(__self__, resource_name, opts=None, internet_id=None, netmask=None, next_hop=None, zone=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a Subnet resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] internet_id: The id of the switch+router resource that the subnet belongs
        :param pulumi.Input[float] netmask: The bit length of the subnet to assign to the Subnet. This must be in the range [`26`-`28`]
        :param pulumi.Input[str] next_hop: The ip address of the next-hop at the subnet
        :param pulumi.Input[str] zone: The name of zone that the Subnet will be created (e.g. `is1a`, `tk1a`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if internet_id is None:
                raise TypeError("Missing required property 'internet_id'")
            __props__['internet_id'] = internet_id
            __props__['netmask'] = netmask
            if next_hop is None:
                raise TypeError("Missing required property 'next_hop'")
            __props__['next_hop'] = next_hop
            __props__['zone'] = zone
            __props__['ip_addresses'] = None
            __props__['max_ip_address'] = None
            __props__['min_ip_address'] = None
            __props__['network_address'] = None
            __props__['switch_id'] = None
        super(Subnet, __self__).__init__(
            'sakuracloud:index/subnet:Subnet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, internet_id=None, ip_addresses=None, max_ip_address=None, min_ip_address=None, netmask=None, network_address=None, next_hop=None, switch_id=None, zone=None):
        """
        Get an existing Subnet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] internet_id: The id of the switch+router resource that the subnet belongs
        :param pulumi.Input[list] ip_addresses: A list of assigned global address to the subnet
        :param pulumi.Input[str] max_ip_address: Maximum IP address in assigned global addresses to the subnet
        :param pulumi.Input[str] min_ip_address: Minimum IP address in assigned global addresses to the subnet
        :param pulumi.Input[float] netmask: The bit length of the subnet to assign to the Subnet. This must be in the range [`26`-`28`]
        :param pulumi.Input[str] network_address: The IPv4 network address assigned to the Subnet
        :param pulumi.Input[str] next_hop: The ip address of the next-hop at the subnet
        :param pulumi.Input[str] switch_id: The id of the switch connected from the Subnet
        :param pulumi.Input[str] zone: The name of zone that the Subnet will be created (e.g. `is1a`, `tk1a`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["internet_id"] = internet_id
        __props__["ip_addresses"] = ip_addresses
        __props__["max_ip_address"] = max_ip_address
        __props__["min_ip_address"] = min_ip_address
        __props__["netmask"] = netmask
        __props__["network_address"] = network_address
        __props__["next_hop"] = next_hop
        __props__["switch_id"] = switch_id
        __props__["zone"] = zone
        return Subnet(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

