# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class SimpleMonitor(pulumi.CustomResource):
    delay_loop: pulumi.Output[float]
    """
    The interval in seconds between checks. This must be in the range [`60`-`3600`]
    """
    description: pulumi.Output[str]
    """
    The description of the SimpleMonitor. The length of this value must be in the range [`1`-`512`]
    """
    enabled: pulumi.Output[bool]
    """
    The flag to enable monitoring by the simple monitor
    """
    health_check: pulumi.Output[dict]
    icon_id: pulumi.Output[str]
    """
    The icon id to attach to the SimpleMonitor
    """
    notify_email_enabled: pulumi.Output[bool]
    """
    The flag to enable notification by email
    """
    notify_email_html: pulumi.Output[bool]
    """
    The flag to enable HTML format instead of text format
    """
    notify_interval: pulumi.Output[float]
    """
    The interval in hours between notification. This must be in the range [`1`-`72`]
    """
    notify_slack_enabled: pulumi.Output[bool]
    """
    The flag to enable notification by slack/discord
    """
    notify_slack_webhook: pulumi.Output[str]
    """
    The webhook URL for sending notification by slack/discord
    """
    tags: pulumi.Output[list]
    """
    Any tags to assign to the SimpleMonitor
    """
    target: pulumi.Output[str]
    """
    The monitoring target of the simple monitor. This must be IP address or FQDN
    """
    def __init__(__self__, resource_name, opts=None, delay_loop=None, description=None, enabled=None, health_check=None, icon_id=None, notify_email_enabled=None, notify_email_html=None, notify_interval=None, notify_slack_enabled=None, notify_slack_webhook=None, tags=None, target=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a SimpleMonitor resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] delay_loop: The interval in seconds between checks. This must be in the range [`60`-`3600`]
        :param pulumi.Input[str] description: The description of the SimpleMonitor. The length of this value must be in the range [`1`-`512`]
        :param pulumi.Input[bool] enabled: The flag to enable monitoring by the simple monitor
        :param pulumi.Input[str] icon_id: The icon id to attach to the SimpleMonitor
        :param pulumi.Input[bool] notify_email_enabled: The flag to enable notification by email
        :param pulumi.Input[bool] notify_email_html: The flag to enable HTML format instead of text format
        :param pulumi.Input[float] notify_interval: The interval in hours between notification. This must be in the range [`1`-`72`]
        :param pulumi.Input[bool] notify_slack_enabled: The flag to enable notification by slack/discord
        :param pulumi.Input[str] notify_slack_webhook: The webhook URL for sending notification by slack/discord
        :param pulumi.Input[list] tags: Any tags to assign to the SimpleMonitor
        :param pulumi.Input[str] target: The monitoring target of the simple monitor. This must be IP address or FQDN

        The **health_check** object supports the following:

          * `community` (`pulumi.Input[str]`)
          * `excepctedData` (`pulumi.Input[str]`)
          * `hostHeader` (`pulumi.Input[str]`)
          * `oid` (`pulumi.Input[str]`)
          * `password` (`pulumi.Input[str]`)
          * `path` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)
          * `protocol` (`pulumi.Input[str]`)
          * `qname` (`pulumi.Input[str]`)
          * `remainingDays` (`pulumi.Input[float]`)
          * `sni` (`pulumi.Input[bool]`)
          * `snmpVersion` (`pulumi.Input[str]`)
          * `status` (`pulumi.Input[float]`)
          * `username` (`pulumi.Input[str]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['delay_loop'] = delay_loop
            __props__['description'] = description
            __props__['enabled'] = enabled
            if health_check is None:
                raise TypeError("Missing required property 'health_check'")
            __props__['health_check'] = health_check
            __props__['icon_id'] = icon_id
            __props__['notify_email_enabled'] = notify_email_enabled
            __props__['notify_email_html'] = notify_email_html
            __props__['notify_interval'] = notify_interval
            __props__['notify_slack_enabled'] = notify_slack_enabled
            __props__['notify_slack_webhook'] = notify_slack_webhook
            __props__['tags'] = tags
            if target is None:
                raise TypeError("Missing required property 'target'")
            __props__['target'] = target
        super(SimpleMonitor, __self__).__init__(
            'sakuracloud:index/simpleMonitor:SimpleMonitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, delay_loop=None, description=None, enabled=None, health_check=None, icon_id=None, notify_email_enabled=None, notify_email_html=None, notify_interval=None, notify_slack_enabled=None, notify_slack_webhook=None, tags=None, target=None):
        """
        Get an existing SimpleMonitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] delay_loop: The interval in seconds between checks. This must be in the range [`60`-`3600`]
        :param pulumi.Input[str] description: The description of the SimpleMonitor. The length of this value must be in the range [`1`-`512`]
        :param pulumi.Input[bool] enabled: The flag to enable monitoring by the simple monitor
        :param pulumi.Input[str] icon_id: The icon id to attach to the SimpleMonitor
        :param pulumi.Input[bool] notify_email_enabled: The flag to enable notification by email
        :param pulumi.Input[bool] notify_email_html: The flag to enable HTML format instead of text format
        :param pulumi.Input[float] notify_interval: The interval in hours between notification. This must be in the range [`1`-`72`]
        :param pulumi.Input[bool] notify_slack_enabled: The flag to enable notification by slack/discord
        :param pulumi.Input[str] notify_slack_webhook: The webhook URL for sending notification by slack/discord
        :param pulumi.Input[list] tags: Any tags to assign to the SimpleMonitor
        :param pulumi.Input[str] target: The monitoring target of the simple monitor. This must be IP address or FQDN

        The **health_check** object supports the following:

          * `community` (`pulumi.Input[str]`)
          * `excepctedData` (`pulumi.Input[str]`)
          * `hostHeader` (`pulumi.Input[str]`)
          * `oid` (`pulumi.Input[str]`)
          * `password` (`pulumi.Input[str]`)
          * `path` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)
          * `protocol` (`pulumi.Input[str]`)
          * `qname` (`pulumi.Input[str]`)
          * `remainingDays` (`pulumi.Input[float]`)
          * `sni` (`pulumi.Input[bool]`)
          * `snmpVersion` (`pulumi.Input[str]`)
          * `status` (`pulumi.Input[float]`)
          * `username` (`pulumi.Input[str]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["delay_loop"] = delay_loop
        __props__["description"] = description
        __props__["enabled"] = enabled
        __props__["health_check"] = health_check
        __props__["icon_id"] = icon_id
        __props__["notify_email_enabled"] = notify_email_enabled
        __props__["notify_email_html"] = notify_email_html
        __props__["notify_interval"] = notify_interval
        __props__["notify_slack_enabled"] = notify_slack_enabled
        __props__["notify_slack_webhook"] = notify_slack_webhook
        __props__["tags"] = tags
        __props__["target"] = target
        return SimpleMonitor(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

