# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class ProxyLB(pulumi.CustomResource):
    bind_ports: pulumi.Output[list]
    certificate: pulumi.Output[dict]
    description: pulumi.Output[str]
    """
    The description of the ProxyLB. The length of this value must be in the range [`1`-`512`]
    """
    fqdn: pulumi.Output[str]
    """
    The FQDN for accessing to the ProxyLB. This is typically used as value of CNAME record
    """
    health_check: pulumi.Output[dict]
    icon_id: pulumi.Output[str]
    """
    The icon id to attach to the ProxyLB
    """
    name: pulumi.Output[str]
    """
    The name of the ProxyLB. The length of this value must be in the range [`1`-`64`]
    """
    plan: pulumi.Output[float]
    """
    The plan name of the ProxyLB. This must be one of [`100`/`500`/`1000`/`5000`/`10000`/`50000`/`100000`]
    """
    proxy_networks: pulumi.Output[list]
    """
    A list of CIDR block used by the ProxyLB to access the server
    """
    region: pulumi.Output[str]
    """
    The name of region that the proxy LB is in. This must be one of [`tk1`/`is1`/`anycast`]
    """
    rules: pulumi.Output[list]
    servers: pulumi.Output[list]
    sorry_server: pulumi.Output[dict]
    sticky_session: pulumi.Output[bool]
    """
    The flag to enable sticky session
    """
    tags: pulumi.Output[list]
    """
    Any tags to assign to the ProxyLB
    """
    timeout: pulumi.Output[float]
    """
    The timeout duration in seconds
    """
    vip: pulumi.Output[str]
    """
    The virtual IP address assigned to the ProxyLB
    """
    vip_failover: pulumi.Output[bool]
    """
    The flag to enable VIP fail-over
    """
    def __init__(__self__, resource_name, opts=None, bind_ports=None, certificate=None, description=None, health_check=None, icon_id=None, name=None, plan=None, region=None, rules=None, servers=None, sorry_server=None, sticky_session=None, tags=None, timeout=None, vip_failover=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a ProxyLB resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the ProxyLB. The length of this value must be in the range [`1`-`512`]
        :param pulumi.Input[str] icon_id: The icon id to attach to the ProxyLB
        :param pulumi.Input[str] name: The name of the ProxyLB. The length of this value must be in the range [`1`-`64`]
        :param pulumi.Input[float] plan: The plan name of the ProxyLB. This must be one of [`100`/`500`/`1000`/`5000`/`10000`/`50000`/`100000`]
        :param pulumi.Input[str] region: The name of region that the proxy LB is in. This must be one of [`tk1`/`is1`/`anycast`]
        :param pulumi.Input[bool] sticky_session: The flag to enable sticky session
        :param pulumi.Input[list] tags: Any tags to assign to the ProxyLB
        :param pulumi.Input[float] timeout: The timeout duration in seconds
        :param pulumi.Input[bool] vip_failover: The flag to enable VIP fail-over

        The **bind_ports** object supports the following:

          * `port` (`pulumi.Input[float]`)
          * `proxyMode` (`pulumi.Input[str]`)
          * `redirectToHttps` (`pulumi.Input[bool]`)
          * `responseHeaders` (`pulumi.Input[list]`)
            * `header` (`pulumi.Input[str]`)
            * `value` (`pulumi.Input[str]`)

          * `supportHttp2` (`pulumi.Input[bool]`)

        The **certificate** object supports the following:

          * `additionalCertificates` (`pulumi.Input[list]`)
            * `intermediateCert` (`pulumi.Input[str]`)
            * `private_key` (`pulumi.Input[str]`)
            * `serverCert` (`pulumi.Input[str]`)

          * `intermediateCert` (`pulumi.Input[str]`)
          * `private_key` (`pulumi.Input[str]`)
          * `serverCert` (`pulumi.Input[str]`)

        The **health_check** object supports the following:

          * `delay_loop` (`pulumi.Input[float]`)
          * `hostHeader` (`pulumi.Input[str]`)
          * `path` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)
          * `protocol` (`pulumi.Input[str]`)

        The **rules** object supports the following:

          * `group` (`pulumi.Input[str]`)
          * `host` (`pulumi.Input[str]`)
          * `path` (`pulumi.Input[str]`)

        The **servers** object supports the following:

          * `enabled` (`pulumi.Input[bool]`)
          * `group` (`pulumi.Input[str]`)
          * `ip_address` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)

        The **sorry_server** object supports the following:

          * `ip_address` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if bind_ports is None:
                raise TypeError("Missing required property 'bind_ports'")
            __props__['bind_ports'] = bind_ports
            __props__['certificate'] = certificate
            __props__['description'] = description
            if health_check is None:
                raise TypeError("Missing required property 'health_check'")
            __props__['health_check'] = health_check
            __props__['icon_id'] = icon_id
            __props__['name'] = name
            __props__['plan'] = plan
            __props__['region'] = region
            __props__['rules'] = rules
            __props__['servers'] = servers
            __props__['sorry_server'] = sorry_server
            __props__['sticky_session'] = sticky_session
            __props__['tags'] = tags
            __props__['timeout'] = timeout
            __props__['vip_failover'] = vip_failover
            __props__['fqdn'] = None
            __props__['proxy_networks'] = None
            __props__['vip'] = None
        super(ProxyLB, __self__).__init__(
            'sakuracloud:index/proxyLB:ProxyLB',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, bind_ports=None, certificate=None, description=None, fqdn=None, health_check=None, icon_id=None, name=None, plan=None, proxy_networks=None, region=None, rules=None, servers=None, sorry_server=None, sticky_session=None, tags=None, timeout=None, vip=None, vip_failover=None):
        """
        Get an existing ProxyLB resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the ProxyLB. The length of this value must be in the range [`1`-`512`]
        :param pulumi.Input[str] fqdn: The FQDN for accessing to the ProxyLB. This is typically used as value of CNAME record
        :param pulumi.Input[str] icon_id: The icon id to attach to the ProxyLB
        :param pulumi.Input[str] name: The name of the ProxyLB. The length of this value must be in the range [`1`-`64`]
        :param pulumi.Input[float] plan: The plan name of the ProxyLB. This must be one of [`100`/`500`/`1000`/`5000`/`10000`/`50000`/`100000`]
        :param pulumi.Input[list] proxy_networks: A list of CIDR block used by the ProxyLB to access the server
        :param pulumi.Input[str] region: The name of region that the proxy LB is in. This must be one of [`tk1`/`is1`/`anycast`]
        :param pulumi.Input[bool] sticky_session: The flag to enable sticky session
        :param pulumi.Input[list] tags: Any tags to assign to the ProxyLB
        :param pulumi.Input[float] timeout: The timeout duration in seconds
        :param pulumi.Input[str] vip: The virtual IP address assigned to the ProxyLB
        :param pulumi.Input[bool] vip_failover: The flag to enable VIP fail-over

        The **bind_ports** object supports the following:

          * `port` (`pulumi.Input[float]`)
          * `proxyMode` (`pulumi.Input[str]`)
          * `redirectToHttps` (`pulumi.Input[bool]`)
          * `responseHeaders` (`pulumi.Input[list]`)
            * `header` (`pulumi.Input[str]`)
            * `value` (`pulumi.Input[str]`)

          * `supportHttp2` (`pulumi.Input[bool]`)

        The **certificate** object supports the following:

          * `additionalCertificates` (`pulumi.Input[list]`)
            * `intermediateCert` (`pulumi.Input[str]`)
            * `private_key` (`pulumi.Input[str]`)
            * `serverCert` (`pulumi.Input[str]`)

          * `intermediateCert` (`pulumi.Input[str]`)
          * `private_key` (`pulumi.Input[str]`)
          * `serverCert` (`pulumi.Input[str]`)

        The **health_check** object supports the following:

          * `delay_loop` (`pulumi.Input[float]`)
          * `hostHeader` (`pulumi.Input[str]`)
          * `path` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)
          * `protocol` (`pulumi.Input[str]`)

        The **rules** object supports the following:

          * `group` (`pulumi.Input[str]`)
          * `host` (`pulumi.Input[str]`)
          * `path` (`pulumi.Input[str]`)

        The **servers** object supports the following:

          * `enabled` (`pulumi.Input[bool]`)
          * `group` (`pulumi.Input[str]`)
          * `ip_address` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)

        The **sorry_server** object supports the following:

          * `ip_address` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["bind_ports"] = bind_ports
        __props__["certificate"] = certificate
        __props__["description"] = description
        __props__["fqdn"] = fqdn
        __props__["health_check"] = health_check
        __props__["icon_id"] = icon_id
        __props__["name"] = name
        __props__["plan"] = plan
        __props__["proxy_networks"] = proxy_networks
        __props__["region"] = region
        __props__["rules"] = rules
        __props__["servers"] = servers
        __props__["sorry_server"] = sorry_server
        __props__["sticky_session"] = sticky_session
        __props__["tags"] = tags
        __props__["timeout"] = timeout
        __props__["vip"] = vip
        __props__["vip_failover"] = vip_failover
        return ProxyLB(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

