# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Internet(pulumi.CustomResource):
    band_width: pulumi.Output[float]
    """
    The bandwidth of the network connected to the Internet in Mbps.
    `100`/`250`/`500`/`1000`/`1500`/`2000`/`2500`/`3000`/`5000`
    """
    description: pulumi.Output[str]
    """
    The description of the Switch+Router. The length of this value must be in the range [`1`-`512`]
    """
    enable_ipv6: pulumi.Output[bool]
    """
    The flag to enable IPv6
    """
    gateway: pulumi.Output[str]
    """
    The IP address of the gateway used by the Switch+Router
    """
    icon_id: pulumi.Output[str]
    """
    The icon id to attach to the Switch+Router
    """
    ip_addresses: pulumi.Output[list]
    """
    A list of assigned global address to the Switch+Router
    """
    ipv6_network_address: pulumi.Output[str]
    """
    The IPv6 network address assigned to the Switch+Router
    """
    ipv6_prefix: pulumi.Output[str]
    """
    The network prefix of assigned IPv6 addresses to the Switch+Router
    """
    ipv6_prefix_len: pulumi.Output[float]
    """
    The bit length of IPv6 network prefix
    """
    max_ip_address: pulumi.Output[str]
    """
    Maximum IP address in assigned global addresses to the Switch+Router
    """
    min_ip_address: pulumi.Output[str]
    """
    Minimum IP address in assigned global addresses to the Switch+Router
    """
    name: pulumi.Output[str]
    """
    The name of the Switch+Router. The length of this value must be in the range [`1`-`64`]
    """
    netmask: pulumi.Output[float]
    """
    The bit length of the subnet assigned to the Switch+Router. `26`/`27`/`28`
    """
    network_address: pulumi.Output[str]
    """
    The IPv4 network address assigned to the Switch+Router
    """
    server_ids: pulumi.Output[list]
    """
    A list of the ID of Servers connected to the Switch+Router
    """
    switch_id: pulumi.Output[str]
    """
    The id of the switch
    """
    tags: pulumi.Output[list]
    """
    Any tags to assign to the Switch+Router
    """
    zone: pulumi.Output[str]
    """
    The name of zone that the Switch+Router will be created (e.g. `is1a`, `tk1a`)
    """
    def __init__(__self__, resource_name, opts=None, band_width=None, description=None, enable_ipv6=None, icon_id=None, name=None, netmask=None, tags=None, zone=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a Internet resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] band_width: The bandwidth of the network connected to the Internet in Mbps.
               `100`/`250`/`500`/`1000`/`1500`/`2000`/`2500`/`3000`/`5000`
        :param pulumi.Input[str] description: The description of the Switch+Router. The length of this value must be in the range [`1`-`512`]
        :param pulumi.Input[bool] enable_ipv6: The flag to enable IPv6
        :param pulumi.Input[str] icon_id: The icon id to attach to the Switch+Router
        :param pulumi.Input[str] name: The name of the Switch+Router. The length of this value must be in the range [`1`-`64`]
        :param pulumi.Input[float] netmask: The bit length of the subnet assigned to the Switch+Router. `26`/`27`/`28`
        :param pulumi.Input[list] tags: Any tags to assign to the Switch+Router
        :param pulumi.Input[str] zone: The name of zone that the Switch+Router will be created (e.g. `is1a`, `tk1a`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['band_width'] = band_width
            __props__['description'] = description
            __props__['enable_ipv6'] = enable_ipv6
            __props__['icon_id'] = icon_id
            __props__['name'] = name
            __props__['netmask'] = netmask
            __props__['tags'] = tags
            __props__['zone'] = zone
            __props__['gateway'] = None
            __props__['ip_addresses'] = None
            __props__['ipv6_network_address'] = None
            __props__['ipv6_prefix'] = None
            __props__['ipv6_prefix_len'] = None
            __props__['max_ip_address'] = None
            __props__['min_ip_address'] = None
            __props__['network_address'] = None
            __props__['server_ids'] = None
            __props__['switch_id'] = None
        super(Internet, __self__).__init__(
            'sakuracloud:index/internet:Internet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, band_width=None, description=None, enable_ipv6=None, gateway=None, icon_id=None, ip_addresses=None, ipv6_network_address=None, ipv6_prefix=None, ipv6_prefix_len=None, max_ip_address=None, min_ip_address=None, name=None, netmask=None, network_address=None, server_ids=None, switch_id=None, tags=None, zone=None):
        """
        Get an existing Internet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] band_width: The bandwidth of the network connected to the Internet in Mbps.
               `100`/`250`/`500`/`1000`/`1500`/`2000`/`2500`/`3000`/`5000`
        :param pulumi.Input[str] description: The description of the Switch+Router. The length of this value must be in the range [`1`-`512`]
        :param pulumi.Input[bool] enable_ipv6: The flag to enable IPv6
        :param pulumi.Input[str] gateway: The IP address of the gateway used by the Switch+Router
        :param pulumi.Input[str] icon_id: The icon id to attach to the Switch+Router
        :param pulumi.Input[list] ip_addresses: A list of assigned global address to the Switch+Router
        :param pulumi.Input[str] ipv6_network_address: The IPv6 network address assigned to the Switch+Router
        :param pulumi.Input[str] ipv6_prefix: The network prefix of assigned IPv6 addresses to the Switch+Router
        :param pulumi.Input[float] ipv6_prefix_len: The bit length of IPv6 network prefix
        :param pulumi.Input[str] max_ip_address: Maximum IP address in assigned global addresses to the Switch+Router
        :param pulumi.Input[str] min_ip_address: Minimum IP address in assigned global addresses to the Switch+Router
        :param pulumi.Input[str] name: The name of the Switch+Router. The length of this value must be in the range [`1`-`64`]
        :param pulumi.Input[float] netmask: The bit length of the subnet assigned to the Switch+Router. `26`/`27`/`28`
        :param pulumi.Input[str] network_address: The IPv4 network address assigned to the Switch+Router
        :param pulumi.Input[list] server_ids: A list of the ID of Servers connected to the Switch+Router
        :param pulumi.Input[str] switch_id: The id of the switch
        :param pulumi.Input[list] tags: Any tags to assign to the Switch+Router
        :param pulumi.Input[str] zone: The name of zone that the Switch+Router will be created (e.g. `is1a`, `tk1a`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["band_width"] = band_width
        __props__["description"] = description
        __props__["enable_ipv6"] = enable_ipv6
        __props__["gateway"] = gateway
        __props__["icon_id"] = icon_id
        __props__["ip_addresses"] = ip_addresses
        __props__["ipv6_network_address"] = ipv6_network_address
        __props__["ipv6_prefix"] = ipv6_prefix
        __props__["ipv6_prefix_len"] = ipv6_prefix_len
        __props__["max_ip_address"] = max_ip_address
        __props__["min_ip_address"] = min_ip_address
        __props__["name"] = name
        __props__["netmask"] = netmask
        __props__["network_address"] = network_address
        __props__["server_ids"] = server_ids
        __props__["switch_id"] = switch_id
        __props__["tags"] = tags
        __props__["zone"] = zone
        return Internet(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

