# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class IPv4Ptr(pulumi.CustomResource):
    hostname: pulumi.Output[str]
    """
    The value of the PTR record. This must be FQDN
    """
    ip_address: pulumi.Output[str]
    """
    The IP address to which the PTR record is set
    """
    retry_interval: pulumi.Output[float]
    """
    The wait interval(in seconds) for retrying API call used when SakuraCloud API returns any errors
    """
    retry_max: pulumi.Output[float]
    """
    The maximum number of API call retries used when SakuraCloud API returns any errors
    """
    zone: pulumi.Output[str]
    """
    The name of zone that the IPv4 PTR will be created (e.g. `is1a`, `tk1a`)
    """
    def __init__(__self__, resource_name, opts=None, hostname=None, ip_address=None, retry_interval=None, retry_max=None, zone=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a IPv4Ptr resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] hostname: The value of the PTR record. This must be FQDN
        :param pulumi.Input[str] ip_address: The IP address to which the PTR record is set
        :param pulumi.Input[float] retry_interval: The wait interval(in seconds) for retrying API call used when SakuraCloud API returns any errors
        :param pulumi.Input[float] retry_max: The maximum number of API call retries used when SakuraCloud API returns any errors
        :param pulumi.Input[str] zone: The name of zone that the IPv4 PTR will be created (e.g. `is1a`, `tk1a`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if hostname is None:
                raise TypeError("Missing required property 'hostname'")
            __props__['hostname'] = hostname
            if ip_address is None:
                raise TypeError("Missing required property 'ip_address'")
            __props__['ip_address'] = ip_address
            __props__['retry_interval'] = retry_interval
            __props__['retry_max'] = retry_max
            __props__['zone'] = zone
        super(IPv4Ptr, __self__).__init__(
            'sakuracloud:index/iPv4Ptr:IPv4Ptr',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, hostname=None, ip_address=None, retry_interval=None, retry_max=None, zone=None):
        """
        Get an existing IPv4Ptr resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] hostname: The value of the PTR record. This must be FQDN
        :param pulumi.Input[str] ip_address: The IP address to which the PTR record is set
        :param pulumi.Input[float] retry_interval: The wait interval(in seconds) for retrying API call used when SakuraCloud API returns any errors
        :param pulumi.Input[float] retry_max: The maximum number of API call retries used when SakuraCloud API returns any errors
        :param pulumi.Input[str] zone: The name of zone that the IPv4 PTR will be created (e.g. `is1a`, `tk1a`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["hostname"] = hostname
        __props__["ip_address"] = ip_address
        __props__["retry_interval"] = retry_interval
        __props__["retry_max"] = retry_max
        __props__["zone"] = zone
        return IPv4Ptr(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

