# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class GSLB(pulumi.CustomResource):
    description: pulumi.Output[str]
    """
    The description of the GSLB. The length of this value must be in the range [`1`-`512`]
    """
    fqdn: pulumi.Output[str]
    """
    The FQDN for accessing to the GSLB. This is typically used as value of CNAME record
    """
    health_check: pulumi.Output[dict]
    icon_id: pulumi.Output[str]
    """
    The icon id to attach to the GSLB
    """
    name: pulumi.Output[str]
    """
    The name of the GSLB. The length of this value must be in the range [`1`-`64`]
    """
    servers: pulumi.Output[list]
    sorry_server: pulumi.Output[str]
    """
    The IP address of the SorryServer. This will be used when all servers are down
    """
    tags: pulumi.Output[list]
    """
    Any tags to assign to the GSLB
    """
    weighted: pulumi.Output[bool]
    """
    The flag to enable weighted load-balancing
    """
    def __init__(__self__, resource_name, opts=None, description=None, health_check=None, icon_id=None, name=None, servers=None, sorry_server=None, tags=None, weighted=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a GSLB resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the GSLB. The length of this value must be in the range [`1`-`512`]
        :param pulumi.Input[str] icon_id: The icon id to attach to the GSLB
        :param pulumi.Input[str] name: The name of the GSLB. The length of this value must be in the range [`1`-`64`]
        :param pulumi.Input[str] sorry_server: The IP address of the SorryServer. This will be used when all servers are down
        :param pulumi.Input[list] tags: Any tags to assign to the GSLB
        :param pulumi.Input[bool] weighted: The flag to enable weighted load-balancing

        The **health_check** object supports the following:

          * `delay_loop` (`pulumi.Input[float]`)
          * `hostHeader` (`pulumi.Input[str]`)
          * `path` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)
          * `protocol` (`pulumi.Input[str]`)
          * `status` (`pulumi.Input[str]`)

        The **servers** object supports the following:

          * `enabled` (`pulumi.Input[bool]`)
          * `ip_address` (`pulumi.Input[str]`)
          * `weight` (`pulumi.Input[float]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            if health_check is None:
                raise TypeError("Missing required property 'health_check'")
            __props__['health_check'] = health_check
            __props__['icon_id'] = icon_id
            __props__['name'] = name
            __props__['servers'] = servers
            __props__['sorry_server'] = sorry_server
            __props__['tags'] = tags
            __props__['weighted'] = weighted
            __props__['fqdn'] = None
        super(GSLB, __self__).__init__(
            'sakuracloud:index/gSLB:GSLB',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, description=None, fqdn=None, health_check=None, icon_id=None, name=None, servers=None, sorry_server=None, tags=None, weighted=None):
        """
        Get an existing GSLB resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the GSLB. The length of this value must be in the range [`1`-`512`]
        :param pulumi.Input[str] fqdn: The FQDN for accessing to the GSLB. This is typically used as value of CNAME record
        :param pulumi.Input[str] icon_id: The icon id to attach to the GSLB
        :param pulumi.Input[str] name: The name of the GSLB. The length of this value must be in the range [`1`-`64`]
        :param pulumi.Input[str] sorry_server: The IP address of the SorryServer. This will be used when all servers are down
        :param pulumi.Input[list] tags: Any tags to assign to the GSLB
        :param pulumi.Input[bool] weighted: The flag to enable weighted load-balancing

        The **health_check** object supports the following:

          * `delay_loop` (`pulumi.Input[float]`)
          * `hostHeader` (`pulumi.Input[str]`)
          * `path` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)
          * `protocol` (`pulumi.Input[str]`)
          * `status` (`pulumi.Input[str]`)

        The **servers** object supports the following:

          * `enabled` (`pulumi.Input[bool]`)
          * `ip_address` (`pulumi.Input[str]`)
          * `weight` (`pulumi.Input[float]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["description"] = description
        __props__["fqdn"] = fqdn
        __props__["health_check"] = health_check
        __props__["icon_id"] = icon_id
        __props__["name"] = name
        __props__["servers"] = servers
        __props__["sorry_server"] = sorry_server
        __props__["tags"] = tags
        __props__["weighted"] = weighted
        return GSLB(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

