# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class BucketObject(pulumi.CustomResource):
    access_key: pulumi.Output[str]
    """
    The access key for using SakuraCloud Object Storage API
    """
    bucket: pulumi.Output[str]
    """
    The name of the bucket
    """
    content: pulumi.Output[str]
    """
    The content to upload to as the bucket object. This conflicts with [`source`]
    """
    content_type: pulumi.Output[str]
    """
    The content-type of the bucket object
    """
    etag: pulumi.Output[str]
    """
    The etag of the bucket object
    """
    http_cache_url: pulumi.Output[str]
    """
    The URL for cached access to the bucket object via HTTP
    """
    http_path_url: pulumi.Output[str]
    """
    The URL with path-format for accessing the bucket object via HTTP
    """
    http_url: pulumi.Output[str]
    """
    The URL for accessing the bucket object via HTTP
    """
    https_cache_url: pulumi.Output[str]
    """
    The URL for cached access to the bucket object via HTTPS
    """
    https_path_url: pulumi.Output[str]
    """
    The URL with path-format for accessing the bucket object via HTTPS
    """
    https_url: pulumi.Output[str]
    """
    The URL for accessing the bucket object via HTTPS
    """
    key: pulumi.Output[str]
    """
    The name of the bucket object
    """
    last_modified: pulumi.Output[str]
    """
    The time when the bucket object last modified
    """
    secret_key: pulumi.Output[str]
    """
    The secret key for using SakuraCloud Object Storage API
    """
    size: pulumi.Output[float]
    """
    The size of the bucket object in bytes
    """
    source: pulumi.Output[str]
    """
    The file path to upload to as the bucket object. This conflicts with [`content`]
    """
    def __init__(__self__, resource_name, opts=None, access_key=None, bucket=None, content=None, content_type=None, etag=None, key=None, secret_key=None, source=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a BucketObject resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_key: The access key for using SakuraCloud Object Storage API
        :param pulumi.Input[str] bucket: The name of the bucket
        :param pulumi.Input[str] content: The content to upload to as the bucket object. This conflicts with [`source`]
        :param pulumi.Input[str] content_type: The content-type of the bucket object
        :param pulumi.Input[str] etag: The etag of the bucket object
        :param pulumi.Input[str] key: The name of the bucket object
        :param pulumi.Input[str] secret_key: The secret key for using SakuraCloud Object Storage API
        :param pulumi.Input[str] source: The file path to upload to as the bucket object. This conflicts with [`content`]
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if access_key is None:
                raise TypeError("Missing required property 'access_key'")
            __props__['access_key'] = access_key
            if bucket is None:
                raise TypeError("Missing required property 'bucket'")
            __props__['bucket'] = bucket
            __props__['content'] = content
            __props__['content_type'] = content_type
            __props__['etag'] = etag
            if key is None:
                raise TypeError("Missing required property 'key'")
            __props__['key'] = key
            if secret_key is None:
                raise TypeError("Missing required property 'secret_key'")
            __props__['secret_key'] = secret_key
            __props__['source'] = source
            __props__['http_cache_url'] = None
            __props__['http_path_url'] = None
            __props__['http_url'] = None
            __props__['https_cache_url'] = None
            __props__['https_path_url'] = None
            __props__['https_url'] = None
            __props__['last_modified'] = None
            __props__['size'] = None
        super(BucketObject, __self__).__init__(
            'sakuracloud:index/bucketObject:BucketObject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, access_key=None, bucket=None, content=None, content_type=None, etag=None, http_cache_url=None, http_path_url=None, http_url=None, https_cache_url=None, https_path_url=None, https_url=None, key=None, last_modified=None, secret_key=None, size=None, source=None):
        """
        Get an existing BucketObject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_key: The access key for using SakuraCloud Object Storage API
        :param pulumi.Input[str] bucket: The name of the bucket
        :param pulumi.Input[str] content: The content to upload to as the bucket object. This conflicts with [`source`]
        :param pulumi.Input[str] content_type: The content-type of the bucket object
        :param pulumi.Input[str] etag: The etag of the bucket object
        :param pulumi.Input[str] http_cache_url: The URL for cached access to the bucket object via HTTP
        :param pulumi.Input[str] http_path_url: The URL with path-format for accessing the bucket object via HTTP
        :param pulumi.Input[str] http_url: The URL for accessing the bucket object via HTTP
        :param pulumi.Input[str] https_cache_url: The URL for cached access to the bucket object via HTTPS
        :param pulumi.Input[str] https_path_url: The URL with path-format for accessing the bucket object via HTTPS
        :param pulumi.Input[str] https_url: The URL for accessing the bucket object via HTTPS
        :param pulumi.Input[str] key: The name of the bucket object
        :param pulumi.Input[str] last_modified: The time when the bucket object last modified
        :param pulumi.Input[str] secret_key: The secret key for using SakuraCloud Object Storage API
        :param pulumi.Input[float] size: The size of the bucket object in bytes
        :param pulumi.Input[str] source: The file path to upload to as the bucket object. This conflicts with [`content`]
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["access_key"] = access_key
        __props__["bucket"] = bucket
        __props__["content"] = content
        __props__["content_type"] = content_type
        __props__["etag"] = etag
        __props__["http_cache_url"] = http_cache_url
        __props__["http_path_url"] = http_path_url
        __props__["http_url"] = http_url
        __props__["https_cache_url"] = https_cache_url
        __props__["https_path_url"] = https_path_url
        __props__["https_url"] = https_url
        __props__["key"] = key
        __props__["last_modified"] = last_modified
        __props__["secret_key"] = secret_key
        __props__["size"] = size
        __props__["source"] = source
        return BucketObject(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

