"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bucket = void 0;
const cdk = require("@aws-cdk/core");
const s3 = require("@aws-cdk/aws-s3");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const cr = require("@aws-cdk/custom-resources");
const path = require("path");
class Bucket extends cdk.Construct {
    constructor(scope, id, props) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s;
        super(scope, id);
        // S3 bucket to host K3s token + kubeconfig file 
        this.s3Bucket = new s3.Bucket(this, 'Bucket', {
            accessControl: (_a = props === null || props === void 0 ? void 0 : props.accessControl) !== null && _a !== void 0 ? _a : undefined,
            blockPublicAccess: (_b = props === null || props === void 0 ? void 0 : props.blockPublicAccess) !== null && _b !== void 0 ? _b : undefined,
            bucketName: (_c = props === null || props === void 0 ? void 0 : props.bucketName) !== null && _c !== void 0 ? _c : undefined,
            cors: (_d = props === null || props === void 0 ? void 0 : props.cors) !== null && _d !== void 0 ? _d : undefined,
            encryption: (_e = props === null || props === void 0 ? void 0 : props.encryption) !== null && _e !== void 0 ? _e : undefined,
            encryptionKey: (_f = props === null || props === void 0 ? void 0 : props.encryptionKey) !== null && _f !== void 0 ? _f : undefined,
            inventories: (_g = props === null || props === void 0 ? void 0 : props.inventories) !== null && _g !== void 0 ? _g : undefined,
            lifecycleRules: (_h = props === null || props === void 0 ? void 0 : props.lifecycleRules) !== null && _h !== void 0 ? _h : undefined,
            metrics: (_j = props === null || props === void 0 ? void 0 : props.metrics) !== null && _j !== void 0 ? _j : undefined,
            publicReadAccess: (_k = props === null || props === void 0 ? void 0 : props.publicReadAccess) !== null && _k !== void 0 ? _k : undefined,
            removalPolicy: (_l = props === null || props === void 0 ? void 0 : props.removalPolicy) !== null && _l !== void 0 ? _l : undefined,
            serverAccessLogsBucket: (_m = props === null || props === void 0 ? void 0 : props.serverAccessLogsBucket) !== null && _m !== void 0 ? _m : undefined,
            serverAccessLogsPrefix: (_o = props === null || props === void 0 ? void 0 : props.serverAccessLogsPrefix) !== null && _o !== void 0 ? _o : undefined,
            versioned: (_p = props === null || props === void 0 ? void 0 : props.versioned) !== null && _p !== void 0 ? _p : undefined,
            websiteErrorDocument: (_q = props === null || props === void 0 ? void 0 : props.websiteErrorDocument) !== null && _q !== void 0 ? _q : undefined,
            websiteRedirect: (_r = props === null || props === void 0 ? void 0 : props.websiteRedirect) !== null && _r !== void 0 ? _r : undefined,
            websiteRoutingRules: (_s = props === null || props === void 0 ? void 0 : props.websiteRoutingRules) !== null && _s !== void 0 ? _s : undefined,
        });
        // Delete S3 Object CustomResource
        if ((props === null || props === void 0 ? void 0 : props.removalPolicy) === cdk.RemovalPolicy.DESTROY) {
            const onEvent = new lambda.Function(this, 'onEventHandler', {
                runtime: lambda.Runtime.PYTHON_3_8,
                code: lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
                handler: 'index.on_event',
            });
            const deleteS3ObjectProvider = new cr.Provider(this, 'deleteS3ObjectProvider', {
                onEventHandler: onEvent,
                logRetention: logs.RetentionDays.ONE_DAY,
            });
            const CRdeleteS3ObjectProvider = new cdk.CustomResource(this, 'CRdeleteS3ObjectProvider', {
                serviceToken: deleteS3ObjectProvider.serviceToken,
                properties: {
                    Bucket: this.s3Bucket.bucketName,
                },
            });
            CRdeleteS3ObjectProvider.node.addDependency(this.s3Bucket);
            this.s3Bucket.grantDelete(onEvent);
            this.s3Bucket.grantReadWrite(onEvent);
        }
    }
}
exports.Bucket = Bucket;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEscUNBQXFDO0FBQ3JDLHNDQUFzQztBQUN0Qyw4Q0FBOEM7QUFDOUMsMENBQTBDO0FBQzFDLGdEQUFnRDtBQUNoRCw2QkFBNkI7QUFFN0IsTUFBYSxNQUFPLFNBQVEsR0FBRyxDQUFDLFNBQVM7SUFNdkMsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUFzQjs7UUFDbEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixpREFBaUQ7UUFDakQsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLEVBQUUsQ0FBQyxNQUFNLENBQUMsSUFBSSxFQUFFLFFBQVEsRUFBRTtZQUM1QyxhQUFhLFFBQUUsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLGFBQWEsbUNBQUksU0FBUztZQUNoRCxpQkFBaUIsUUFBRSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsaUJBQWlCLG1DQUFJLFNBQVM7WUFDeEQsVUFBVSxRQUFFLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxVQUFVLG1DQUFJLFNBQVM7WUFDMUMsSUFBSSxRQUFFLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxJQUFJLG1DQUFJLFNBQVM7WUFDOUIsVUFBVSxRQUFFLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxVQUFVLG1DQUFJLFNBQVM7WUFDMUMsYUFBYSxRQUFFLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxhQUFhLG1DQUFJLFNBQVM7WUFDaEQsV0FBVyxRQUFFLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxXQUFXLG1DQUFJLFNBQVM7WUFDNUMsY0FBYyxRQUFFLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxjQUFjLG1DQUFJLFNBQVM7WUFDbEQsT0FBTyxRQUFFLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxPQUFPLG1DQUFJLFNBQVM7WUFDcEMsZ0JBQWdCLFFBQUUsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLGdCQUFnQixtQ0FBSSxTQUFTO1lBQ3RELGFBQWEsUUFBRSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsYUFBYSxtQ0FBSSxTQUFTO1lBQ2hELHNCQUFzQixRQUFFLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxzQkFBc0IsbUNBQUksU0FBUztZQUNsRSxzQkFBc0IsUUFBRSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsc0JBQXNCLG1DQUFJLFNBQVM7WUFDbEUsU0FBUyxRQUFFLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxTQUFTLG1DQUFJLFNBQVM7WUFDeEMsb0JBQW9CLFFBQUUsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLG9CQUFvQixtQ0FBSSxTQUFTO1lBQzlELGVBQWUsUUFBRSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsZUFBZSxtQ0FBSSxTQUFTO1lBQ3BELG1CQUFtQixRQUFFLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxtQkFBbUIsbUNBQUksU0FBUztTQUM3RCxDQUFDLENBQUM7UUFFSCxrQ0FBa0M7UUFDbEMsSUFBRyxDQUFBLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxhQUFhLE1BQUssR0FBRyxDQUFDLGFBQWEsQ0FBQyxPQUFPLEVBQUM7WUFDcEQsTUFBTSxPQUFPLEdBQUcsSUFBSSxNQUFNLENBQUMsUUFBUSxDQUFDLElBQUksRUFBRSxnQkFBZ0IsRUFBRTtnQkFDMUQsT0FBTyxFQUFFLE1BQU0sQ0FBQyxPQUFPLENBQUMsVUFBVTtnQkFDbEMsSUFBSSxFQUFFLE1BQU0sQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLDRCQUE0QixDQUFDLENBQUM7Z0JBQy9FLE9BQU8sRUFBRSxnQkFBZ0I7YUFDMUIsQ0FBQyxDQUFDO1lBRUgsTUFBTSxzQkFBc0IsR0FBRyxJQUFJLEVBQUUsQ0FBQyxRQUFRLENBQUMsSUFBSSxFQUFFLHdCQUF3QixFQUFFO2dCQUM3RSxjQUFjLEVBQUUsT0FBTztnQkFDdkIsWUFBWSxFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsT0FBTzthQUN6QyxDQUFDLENBQUM7WUFFSCxNQUFNLHdCQUF3QixHQUFHLElBQUksR0FBRyxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUsMEJBQTBCLEVBQUU7Z0JBQ3hGLFlBQVksRUFBRSxzQkFBc0IsQ0FBQyxZQUFZO2dCQUNqRCxVQUFVLEVBQUU7b0JBQ1YsTUFBTSxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsVUFBVTtpQkFDakM7YUFDRixDQUFDLENBQUM7WUFFSCx3QkFBd0IsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQTtZQUUxRCxJQUFJLENBQUMsUUFBUSxDQUFDLFdBQVcsQ0FBQyxPQUFPLENBQUMsQ0FBQztZQUNuQyxJQUFJLENBQUMsUUFBUSxDQUFDLGNBQWMsQ0FBQyxPQUFPLENBQUMsQ0FBQztTQUN2QztJQUNILENBQUM7Q0FDRjtBQXhERCx3QkF3REMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyBzMyBmcm9tICdAYXdzLWNkay9hd3MtczMnO1xuaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0ICogYXMgbG9ncyBmcm9tICdAYXdzLWNkay9hd3MtbG9ncyc7XG5pbXBvcnQgKiBhcyBjciBmcm9tICdAYXdzLWNkay9jdXN0b20tcmVzb3VyY2VzJztcbmltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5cbmV4cG9ydCBjbGFzcyBCdWNrZXQgZXh0ZW5kcyBjZGsuQ29uc3RydWN0IHtcbiAgLyoqXG4gICAqIHJldHVyZSBTMyBidWNrZXQgc2VsZlxuICAgKi9cbiAgcmVhZG9ubHkgczNCdWNrZXQ6IHMzLklCdWNrZXQ7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzPzogczMuQnVja2V0UHJvcHMgKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIC8vIFMzIGJ1Y2tldCB0byBob3N0IEszcyB0b2tlbiArIGt1YmVjb25maWcgZmlsZSBcbiAgICB0aGlzLnMzQnVja2V0ID0gbmV3IHMzLkJ1Y2tldCh0aGlzLCAnQnVja2V0Jywge1xuICAgICAgYWNjZXNzQ29udHJvbDogcHJvcHM/LmFjY2Vzc0NvbnRyb2wgPz8gdW5kZWZpbmVkLFxuICAgICAgYmxvY2tQdWJsaWNBY2Nlc3M6IHByb3BzPy5ibG9ja1B1YmxpY0FjY2VzcyA/PyB1bmRlZmluZWQsXG4gICAgICBidWNrZXROYW1lOiBwcm9wcz8uYnVja2V0TmFtZSA/PyB1bmRlZmluZWQsXG4gICAgICBjb3JzOiBwcm9wcz8uY29ycyA/PyB1bmRlZmluZWQsXG4gICAgICBlbmNyeXB0aW9uOiBwcm9wcz8uZW5jcnlwdGlvbiA/PyB1bmRlZmluZWQsXG4gICAgICBlbmNyeXB0aW9uS2V5OiBwcm9wcz8uZW5jcnlwdGlvbktleSA/PyB1bmRlZmluZWQsXG4gICAgICBpbnZlbnRvcmllczogcHJvcHM/LmludmVudG9yaWVzID8/IHVuZGVmaW5lZCxcbiAgICAgIGxpZmVjeWNsZVJ1bGVzOiBwcm9wcz8ubGlmZWN5Y2xlUnVsZXMgPz8gdW5kZWZpbmVkLFxuICAgICAgbWV0cmljczogcHJvcHM/Lm1ldHJpY3MgPz8gdW5kZWZpbmVkLFxuICAgICAgcHVibGljUmVhZEFjY2VzczogcHJvcHM/LnB1YmxpY1JlYWRBY2Nlc3MgPz8gdW5kZWZpbmVkLFxuICAgICAgcmVtb3ZhbFBvbGljeTogcHJvcHM/LnJlbW92YWxQb2xpY3kgPz8gdW5kZWZpbmVkLFxuICAgICAgc2VydmVyQWNjZXNzTG9nc0J1Y2tldDogcHJvcHM/LnNlcnZlckFjY2Vzc0xvZ3NCdWNrZXQgPz8gdW5kZWZpbmVkLFxuICAgICAgc2VydmVyQWNjZXNzTG9nc1ByZWZpeDogcHJvcHM/LnNlcnZlckFjY2Vzc0xvZ3NQcmVmaXggPz8gdW5kZWZpbmVkLFxuICAgICAgdmVyc2lvbmVkOiBwcm9wcz8udmVyc2lvbmVkID8/IHVuZGVmaW5lZCxcbiAgICAgIHdlYnNpdGVFcnJvckRvY3VtZW50OiBwcm9wcz8ud2Vic2l0ZUVycm9yRG9jdW1lbnQgPz8gdW5kZWZpbmVkLFxuICAgICAgd2Vic2l0ZVJlZGlyZWN0OiBwcm9wcz8ud2Vic2l0ZVJlZGlyZWN0ID8/IHVuZGVmaW5lZCxcbiAgICAgIHdlYnNpdGVSb3V0aW5nUnVsZXM6IHByb3BzPy53ZWJzaXRlUm91dGluZ1J1bGVzID8/IHVuZGVmaW5lZCxcbiAgICB9KTtcblxuICAgIC8vIERlbGV0ZSBTMyBPYmplY3QgQ3VzdG9tUmVzb3VyY2VcbiAgICBpZihwcm9wcz8ucmVtb3ZhbFBvbGljeSA9PT0gY2RrLlJlbW92YWxQb2xpY3kuREVTVFJPWSl7XG4gICAgICBjb25zdCBvbkV2ZW50ID0gbmV3IGxhbWJkYS5GdW5jdGlvbih0aGlzLCAnb25FdmVudEhhbmRsZXInLCB7XG4gICAgICAgIHJ1bnRpbWU6IGxhbWJkYS5SdW50aW1lLlBZVEhPTl8zXzgsXG4gICAgICAgIGNvZGU6IGxhbWJkYS5Db2RlLmZyb21Bc3NldChwYXRoLmpvaW4oX19kaXJuYW1lLCAnLi4vY3VzdG9tLXJlc291cmNlLWhhbmRsZXInKSksXG4gICAgICAgIGhhbmRsZXI6ICdpbmRleC5vbl9ldmVudCcsXG4gICAgICB9KTtcbiAgXG4gICAgICBjb25zdCBkZWxldGVTM09iamVjdFByb3ZpZGVyID0gbmV3IGNyLlByb3ZpZGVyKHRoaXMsICdkZWxldGVTM09iamVjdFByb3ZpZGVyJywge1xuICAgICAgICBvbkV2ZW50SGFuZGxlcjogb25FdmVudCxcbiAgICAgICAgbG9nUmV0ZW50aW9uOiBsb2dzLlJldGVudGlvbkRheXMuT05FX0RBWSxcbiAgICAgIH0pO1xuICBcbiAgICAgIGNvbnN0IENSZGVsZXRlUzNPYmplY3RQcm92aWRlciA9IG5ldyBjZGsuQ3VzdG9tUmVzb3VyY2UodGhpcywgJ0NSZGVsZXRlUzNPYmplY3RQcm92aWRlcicsIHtcbiAgICAgICAgc2VydmljZVRva2VuOiBkZWxldGVTM09iamVjdFByb3ZpZGVyLnNlcnZpY2VUb2tlbixcbiAgICAgICAgcHJvcGVydGllczoge1xuICAgICAgICAgIEJ1Y2tldDogdGhpcy5zM0J1Y2tldC5idWNrZXROYW1lLFxuICAgICAgICB9LFxuICAgICAgfSk7XG4gIFxuICAgICAgQ1JkZWxldGVTM09iamVjdFByb3ZpZGVyLm5vZGUuYWRkRGVwZW5kZW5jeSh0aGlzLnMzQnVja2V0KVxuICBcbiAgICAgIHRoaXMuczNCdWNrZXQuZ3JhbnREZWxldGUob25FdmVudCk7XG4gICAgICB0aGlzLnMzQnVja2V0LmdyYW50UmVhZFdyaXRlKG9uRXZlbnQpO1xuICAgIH1cbiAgfVxufSJdfQ==