import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Schema for Module Fragment of type Logzio::MyService::MyName::MODULE
 *
 * @schema CfnMyNameModuleProps
 */
export interface CfnMyNameModuleProps {
    /**
     * @schema CfnMyNameModuleProps#Parameters
     */
    readonly parameters?: CfnMyNameModulePropsParameters;
    /**
     * @schema CfnMyNameModuleProps#Resources
     */
    readonly resources?: CfnMyNameModulePropsResources;
}
/**
 * Converts an object of type 'CfnMyNameModuleProps' to JSON representation.
 */
export declare function toJson_CfnMyNameModuleProps(obj: CfnMyNameModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMyNameModulePropsParameters
 */
export interface CfnMyNameModulePropsParameters {
    /**
     * Your Logz.io operations token
     *
     * @schema CfnMyNameModulePropsParameters#logzioOperationsToken
     */
    readonly logzioOperationsToken?: CfnMyNameModulePropsParametersLogzioOperationsToken;
    /**
     * Your Logz.io listener with port 8070/8071. For example https://listener.logz.io:8071
     *
     * @schema CfnMyNameModulePropsParameters#logzioListener
     */
    readonly logzioListener?: CfnMyNameModulePropsParametersLogzioListener;
    /**
     * Log level for the function
     *
     * @schema CfnMyNameModulePropsParameters#logzioLogLevel
     */
    readonly logzioLogLevel?: CfnMyNameModulePropsParametersLogzioLogLevel;
}
/**
 * Converts an object of type 'CfnMyNameModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnMyNameModulePropsParameters(obj: CfnMyNameModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMyNameModulePropsResources
 */
export interface CfnMyNameModulePropsResources {
    /**
     * @schema CfnMyNameModulePropsResources#logzioSecurityHubCollector
     */
    readonly logzioSecurityHubCollector?: CfnMyNameModulePropsResourcesLogzioSecurityHubCollector;
    /**
     * @schema CfnMyNameModulePropsResources#eventRule
     */
    readonly eventRule?: CfnMyNameModulePropsResourcesEventRule;
    /**
     * @schema CfnMyNameModulePropsResources#lambdaPermissions
     */
    readonly lambdaPermissions?: CfnMyNameModulePropsResourcesLambdaPermissions;
    /**
     * @schema CfnMyNameModulePropsResources#lambdaIamRole
     */
    readonly lambdaIamRole?: CfnMyNameModulePropsResourcesLambdaIamRole;
}
/**
 * Converts an object of type 'CfnMyNameModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnMyNameModulePropsResources(obj: CfnMyNameModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * Your Logz.io operations token
 *
 * @schema CfnMyNameModulePropsParametersLogzioOperationsToken
 */
export interface CfnMyNameModulePropsParametersLogzioOperationsToken {
    /**
     * @schema CfnMyNameModulePropsParametersLogzioOperationsToken#Type
     */
    readonly type: string;
    /**
     * @schema CfnMyNameModulePropsParametersLogzioOperationsToken#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnMyNameModulePropsParametersLogzioOperationsToken' to JSON representation.
 */
export declare function toJson_CfnMyNameModulePropsParametersLogzioOperationsToken(obj: CfnMyNameModulePropsParametersLogzioOperationsToken | undefined): Record<string, any> | undefined;
/**
 * Your Logz.io listener with port 8070/8071. For example https://listener.logz.io:8071
 *
 * @schema CfnMyNameModulePropsParametersLogzioListener
 */
export interface CfnMyNameModulePropsParametersLogzioListener {
    /**
     * @schema CfnMyNameModulePropsParametersLogzioListener#Type
     */
    readonly type: string;
    /**
     * @schema CfnMyNameModulePropsParametersLogzioListener#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnMyNameModulePropsParametersLogzioListener' to JSON representation.
 */
export declare function toJson_CfnMyNameModulePropsParametersLogzioListener(obj: CfnMyNameModulePropsParametersLogzioListener | undefined): Record<string, any> | undefined;
/**
 * Log level for the function
 *
 * @schema CfnMyNameModulePropsParametersLogzioLogLevel
 */
export interface CfnMyNameModulePropsParametersLogzioLogLevel {
    /**
     * @schema CfnMyNameModulePropsParametersLogzioLogLevel#Type
     */
    readonly type: string;
    /**
     * @schema CfnMyNameModulePropsParametersLogzioLogLevel#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnMyNameModulePropsParametersLogzioLogLevel' to JSON representation.
 */
export declare function toJson_CfnMyNameModulePropsParametersLogzioLogLevel(obj: CfnMyNameModulePropsParametersLogzioLogLevel | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMyNameModulePropsResourcesLogzioSecurityHubCollector
 */
export interface CfnMyNameModulePropsResourcesLogzioSecurityHubCollector {
    /**
     * @schema CfnMyNameModulePropsResourcesLogzioSecurityHubCollector#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMyNameModulePropsResourcesLogzioSecurityHubCollector#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMyNameModulePropsResourcesLogzioSecurityHubCollector' to JSON representation.
 */
export declare function toJson_CfnMyNameModulePropsResourcesLogzioSecurityHubCollector(obj: CfnMyNameModulePropsResourcesLogzioSecurityHubCollector | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMyNameModulePropsResourcesEventRule
 */
export interface CfnMyNameModulePropsResourcesEventRule {
    /**
     * @schema CfnMyNameModulePropsResourcesEventRule#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMyNameModulePropsResourcesEventRule#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMyNameModulePropsResourcesEventRule' to JSON representation.
 */
export declare function toJson_CfnMyNameModulePropsResourcesEventRule(obj: CfnMyNameModulePropsResourcesEventRule | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMyNameModulePropsResourcesLambdaPermissions
 */
export interface CfnMyNameModulePropsResourcesLambdaPermissions {
    /**
     * @schema CfnMyNameModulePropsResourcesLambdaPermissions#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMyNameModulePropsResourcesLambdaPermissions#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMyNameModulePropsResourcesLambdaPermissions' to JSON representation.
 */
export declare function toJson_CfnMyNameModulePropsResourcesLambdaPermissions(obj: CfnMyNameModulePropsResourcesLambdaPermissions | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMyNameModulePropsResourcesLambdaIamRole
 */
export interface CfnMyNameModulePropsResourcesLambdaIamRole {
    /**
     * @schema CfnMyNameModulePropsResourcesLambdaIamRole#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMyNameModulePropsResourcesLambdaIamRole#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMyNameModulePropsResourcesLambdaIamRole' to JSON representation.
 */
export declare function toJson_CfnMyNameModulePropsResourcesLambdaIamRole(obj: CfnMyNameModulePropsResourcesLambdaIamRole | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Logzio::MyService::MyName::MODULE`
 *
 * @cloudformationResource Logzio::MyService::MyName::MODULE
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnMyNameModule extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Logzio::MyService::MyName::MODULE";
    /**
     * Resource props.
     */
    readonly props: CfnMyNameModuleProps;
    /**
     * Create a new `Logzio::MyService::MyName::MODULE`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnMyNameModuleProps);
}
