"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TargetType = exports.MSTeamsIncomingWebhook = exports.SlackChannel = exports.SnsTopic = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_event_sources_1 = require("@aws-cdk/aws-lambda-event-sources");
const aws_sns_1 = require("@aws-cdk/aws-sns");
class SnsTopic {
    constructor(topic) {
        this.topic = topic;
    }
    bind(_scope, _rule) {
        this.topic.grantPublish(new aws_iam_1.ServicePrincipal('codestar-notifications.amazonaws.com'));
        return {
            targetType: TargetType.SNS,
            targetAddress: this.topic.topicArn,
        };
    }
}
exports.SnsTopic = SnsTopic;
_a = JSII_RTTI_SYMBOL_1;
SnsTopic[_a] = { fqn: "@cloudcomponents/cdk-developer-tools-notifications.SnsTopic", version: "1.46.0" };
class SlackChannel {
    constructor(channel) {
        this.channel = channel;
    }
    bind(_scope, _rule) {
        return {
            targetType: TargetType.AWS_CHATBOT_SLACK,
            targetAddress: this.channel.configurationArn,
        };
    }
}
exports.SlackChannel = SlackChannel;
_b = JSII_RTTI_SYMBOL_1;
SlackChannel[_b] = { fqn: "@cloudcomponents/cdk-developer-tools-notifications.SlackChannel", version: "1.46.0" };
class MSTeamsIncomingWebhook {
    constructor(webhook) {
        this.webhook = webhook;
    }
    bind(scope, _rule) {
        const msTeamsTopic = new aws_sns_1.Topic(scope, `${scope.node.id}MSTeamsTopic`);
        msTeamsTopic.grantPublish(new aws_iam_1.ServicePrincipal('codestar-notifications.amazonaws.com'));
        this.webhook.addEventSource(new aws_lambda_event_sources_1.SnsEventSource(msTeamsTopic));
        return {
            targetType: TargetType.SNS,
            targetAddress: msTeamsTopic.topicArn,
        };
    }
}
exports.MSTeamsIncomingWebhook = MSTeamsIncomingWebhook;
_c = JSII_RTTI_SYMBOL_1;
MSTeamsIncomingWebhook[_c] = { fqn: "@cloudcomponents/cdk-developer-tools-notifications.MSTeamsIncomingWebhook", version: "1.46.0" };
var TargetType;
(function (TargetType) {
    TargetType["SNS"] = "SNS";
    TargetType["AWS_CHATBOT_SLACK"] = "AWSChatbotSlack";
})(TargetType = exports.TargetType || (exports.TargetType = {}));
//# sourceMappingURL=data:application/json;base64,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