<p align="center" style="font-size:80px; margin:0px 10px 0px 10px">
    <em>MPPT</em>
</p>
<p align="center", style="font-size: 40px">
    <em>A Modern Python Package Template
</em>
</p>

<center>

[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![Ruff](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/astral-sh/ruff/main/assets/badge/v2.json)](https://github.com/astral-sh/ruff)
[![Imports: isort](https://img.shields.io/badge/%20imports-isort-%231674b1?style=flat&labelColor=ef8336)](https://pycqa.github.io/isort/)
[![Checked with mypy](https://www.mypy-lang.org/static/mypy_badge.svg)](https://mypy-lang.org/)
[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit)](https://github.com/pre-commit/pre-commit)
[![Build Docs](https://github.com/shenxiangzhuang/mppt/actions/workflows/build_docs.yaml/badge.svg)](https://github.com/shenxiangzhuang/mppt/actions/workflows/build_docs.yaml)
![Test](https://github.com/shenxiangzhuang/mppt/actions/workflows/test.yaml/badge.svg)
![Codecov](https://codecov.io/gh/shenxiangzhuang/mppt/branch/master/graph/badge.svg)
[![Python](https://img.shields.io/badge/Python-3.8,%203.9,%203.10,%203.11-blue)]()
[![PyPI](https://img.shields.io/pypi/v/mppt)](https://pypi.org/project/mppt/)
![GitHub License](https://img.shields.io/github/license/shenxiangzhuang/mppt)

</center>

# About
[MPPT](https://github.com/shenxiangzhuang/mppt): A **M**odern **P**ython **P**ackage **T**emplate.

# Documentation

[https://datahonor.com/mppt/](https://datahonor.com/mppt/)

# Features
- Package Management: Poetry
- Documentation: Mkdocs with Material theme
- Linters&Formatters: Black, Isort, Flake8, Ruff, Mypy, Pre-commit, SonarLint
- Testing: Pytest, Hypothesis, Codecov
- Task runner: Makefile, Duty, Taskfile
- Miscellaneous: Changelog, License, Semantic Versioning, Contributing


## Package Management
- Poetry

## Documentation

- Mkdocs with Material theme

## Linters

- Black
- Isort
- Flake8
- Mypy
- SonarLint
- Pre-commit


## Testing

- Pytest: pytest, pytest-cov, pytest-sugar
- Hypothesis
- Codecov

## Task runner

- Makefile
- Duty
- Taskfile

## Miscellaneous

- Change Log: [Keep a Changelog](https://keepachangelog.com/en/1.1.0/)
- Versioning: [Semantic Versioning](https://semver.org/)
- License: [Choose an open source license](https://choosealicense.com/)
- Badge: [Shields.io](https://shields.io/)
- Contributing: [Contributing to Open Source on GitHub](https://guides.github.com/activities/contributing-to-open-source/)
