# coding: utf-8

# flake8: noqa
"""
    Cythereal MAGIC API

     The API for accessing Cythereal MAGIC products and services.  # API Clients  We provide clients in several languages for accessing the MAGIC API. https://bitbucket.org/cythereal/magic-clients  These clients are provided to make integration of the MAGIC API into your existing applications as easy as possible.  If you want to use a language that is not currently supported, please contact us at support@cythereal.com and we will be glad to help.  # Example Inputs  Here are some example inputs that can be used for testing the service:  * Binary SHA1: `ff9790d7902fea4c910b182f6e0b00221a40d616`   * Can be used for `file_hash` parameters. * Procedure RVA: `0x1000`   * Use with the above SHA1 for `proc_rva` parameters.   # API Conventions  Properties MUST be named using `snake_case`.  This API is inspired by the [google json style guide](https://google.github.io/styleguide/jsoncstyleguide.xml). Any questions about conventions not documented here should be addressed by this style guide.  **All responses** MUST be of type `APIResponse` and contain the following fields:  * `api_version` |  The current api version * `success` | Boolean value indicating if the operation succeeded. * `code` | Status code. Typically corresponds to the HTTP status code.  * `message` | A human readable message providing more details about the operation. Can be null or empty.  **Successful operations** MUST return a `SuccessResponse`, which extends `APIResponse` by adding:  * `data` | Properties containing the response object. * `success` | MUST equal True  When returning objects from a successful response, the `data` object SHOULD contain a property named after the requested object type. For example, the `/matches` endpoint should return a response object with `data.matches`. This property SHOULD  contain a list of the returned objects. For the `/matches` endpoint, the `data.matches` property contains a list of MagicMatch objects. See the `/matches` endpoint documentation for an example.  **Failed Operations** MUST return an `ErrorResponse`, which extends `APIResponse` by adding:  * `errors` | Array of error objects. An error object contains the following properties:     * `ErrorObject.reason` | Unique identifier for this error. Example: \"FileNotFoundError\".     * `ErrorObject.message`| Human readable error message. * `success` | MUST equal False.   # noqa: E501

    OpenAPI spec version: 1
    Contact: support@cythereal.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

# import models into model package
from cythereal_magic.models.analysis_status import AnalysisStatus
from cythereal_magic.models.api_response import ApiResponse
from cythereal_magic.models.binary_genomics import BinaryGenomics
from cythereal_magic.models.binary_similarity import BinarySimilarity
from cythereal_magic.models.binary_similarity_binaries import BinarySimilarityBinaries
from cythereal_magic.models.block_genomics import BlockGenomics
from cythereal_magic.models.campaign_id import CampaignId
from cythereal_magic.models.campaign_info_response_data import CampaignInfoResponseData
from cythereal_magic.models.campaign_members_response_data import CampaignMembersResponseData
from cythereal_magic.models.campaign_members_response_data_members import CampaignMembersResponseDataMembers
from cythereal_magic.models.child_info import ChildInfo
from cythereal_magic.models.control_flow_graph import ControlFlowGraph
from cythereal_magic.models.email_object import EmailObject
from cythereal_magic.models.emails_list import EmailsList
from cythereal_magic.models.emails_list_inner import EmailsListInner
from cythereal_magic.models.emails_list_inner_attachment_files import EmailsListInnerAttachmentFiles
from cythereal_magic.models.emails_list_inner_ioc_objects import EmailsListInnerIocObjects
from cythereal_magic.models.file_added import FileAdded
from cythereal_magic.models.file_info import FileInfo
from cythereal_magic.models.file_status import FileStatus
from cythereal_magic.models.file_upload_response_data import FileUploadResponseData
from cythereal_magic.models.files_list import FilesList
from cythereal_magic.models.files_list_files import FilesListFiles
from cythereal_magic.models.io_c_object import IoCObject
from cythereal_magic.models.io_cs_list import IoCsList
from cythereal_magic.models.ioc_file_response_data import IocFileResponseData
from cythereal_magic.models.ioc_files_response_data import IocFilesResponseData
from cythereal_magic.models.magic_categories import MagicCategories
from cythereal_magic.models.magic_category import MagicCategory
from cythereal_magic.models.magic_category_list import MagicCategoryList
from cythereal_magic.models.magic_label import MagicLabel
from cythereal_magic.models.magic_labels import MagicLabels
from cythereal_magic.models.magic_matches import MagicMatches
from cythereal_magic.models.magic_matches_match_subtypes import MagicMatchesMatchSubtypes
from cythereal_magic.models.magic_matches_matches import MagicMatchesMatches
from cythereal_magic.models.magic_report import MagicReport
from cythereal_magic.models.magic_report_detection_stats import MagicReportDetectionStats
from cythereal_magic.models.magic_yara_response_data import MagicYaraResponseData
from cythereal_magic.models.procedure_genomics import ProcedureGenomics
from cythereal_magic.models.procedure_info_list import ProcedureInfoList
from cythereal_magic.models.procedure_info_list_inner import ProcedureInfoListInner
from cythereal_magic.models.procedure_info_list_inner_blocks import ProcedureInfoListInnerBlocks
from cythereal_magic.models.procedure_report_response_data import ProcedureReportResponseData
from cythereal_magic.models.procedure_signature import ProcedureSignature
from cythereal_magic.models.procedure_signature_list import ProcedureSignatureList
from cythereal_magic.models.procedure_signatures_response_data import ProcedureSignaturesResponseData
from cythereal_magic.models.procedure_similarity import ProcedureSimilarity
from cythereal_magic.models.procedure_similarity_procedures import ProcedureSimilarityProcedures
from cythereal_magic.models.search_file_response_data import SearchFileResponseData
from cythereal_magic.models.search_file_response_data_associated_files import SearchFileResponseDataAssociatedFiles
from cythereal_magic.models.search_response_data import SearchResponseData
from cythereal_magic.models.search_response_data_results import SearchResponseDataResults
from cythereal_magic.models.error_response import ErrorResponse
from cythereal_magic.models.success_response import SuccessResponse
from cythereal_magic.models.binary_genomics_response import BinaryGenomicsResponse
from cythereal_magic.models.binary_similarity_response import BinarySimilarityResponse
from cythereal_magic.models.campaign_id_response import CampaignIdResponse
from cythereal_magic.models.campaign_info_response import CampaignInfoResponse
from cythereal_magic.models.campaign_members_response import CampaignMembersResponse
from cythereal_magic.models.email_response import EmailResponse
from cythereal_magic.models.emails_response import EmailsResponse
from cythereal_magic.models.file_details_response import FileDetailsResponse
from cythereal_magic.models.file_info_response import FileInfoResponse
from cythereal_magic.models.file_status_response import FileStatusResponse
from cythereal_magic.models.file_upload_response import FileUploadResponse
from cythereal_magic.models.files_added_response import FilesAddedResponse
from cythereal_magic.models.io_c_upload_response import IoCUploadResponse
from cythereal_magic.models.io_cs_list_response import IoCsListResponse
from cythereal_magic.models.ioc_file_response import IocFileResponse
from cythereal_magic.models.ioc_files_response import IocFilesResponse
from cythereal_magic.models.magic_categories_response import MagicCategoriesResponse
from cythereal_magic.models.magic_labels_response import MagicLabelsResponse
from cythereal_magic.models.magic_matches_response import MagicMatchesResponse
from cythereal_magic.models.magic_report_response import MagicReportResponse
from cythereal_magic.models.magic_yara_response import MagicYaraResponse
from cythereal_magic.models.owned_files_list_response import OwnedFilesListResponse
from cythereal_magic.models.procedure_genomics_response import ProcedureGenomicsResponse
from cythereal_magic.models.procedure_report_response import ProcedureReportResponse
from cythereal_magic.models.procedure_signatures_response import ProcedureSignaturesResponse
from cythereal_magic.models.procedure_similarity_response import ProcedureSimilarityResponse
from cythereal_magic.models.search_file_response import SearchFileResponse
from cythereal_magic.models.search_response import SearchResponse
