# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._dynatrace_observability_enums import *


class AccountInfo(msrest.serialization.Model):
    """Dynatrace Account Information.

    :ivar account_id: Account Id of the account this environment is linked to.
    :vartype account_id: str
    :ivar region_id: Region in which the account is created.
    :vartype region_id: str
    """

    _attribute_map = {
        'account_id': {'key': 'accountId', 'type': 'str'},
        'region_id': {'key': 'regionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        account_id: Optional[str] = None,
        region_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword account_id: Account Id of the account this environment is linked to.
        :paramtype account_id: str
        :keyword region_id: Region in which the account is created.
        :paramtype region_id: str
        """
        super(AccountInfo, self).__init__(**kwargs)
        self.account_id = account_id
        self.region_id = region_id


class AccountInfoSecure(msrest.serialization.Model):
    """Dynatrace account API Key.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_id: Account Id of the account this environment is linked to.
    :vartype account_id: str
    :ivar api_key: API Key of the user account.
    :vartype api_key: str
    :ivar region_id: Region in which the account is created.
    :vartype region_id: str
    """

    _validation = {
        'account_id': {'readonly': True},
        'api_key': {'readonly': True},
        'region_id': {'readonly': True},
    }

    _attribute_map = {
        'account_id': {'key': 'accountId', 'type': 'str'},
        'api_key': {'key': 'apiKey', 'type': 'str'},
        'region_id': {'key': 'regionId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AccountInfoSecure, self).__init__(**kwargs)
        self.account_id = None
        self.api_key = None
        self.region_id = None


class AppServiceInfo(msrest.serialization.Model):
    """Details of App Services having Dynatrace OneAgent installed.

    :ivar resource_id: App service resource ID.
    :vartype resource_id: str
    :ivar version: Version of the Dynatrace agent installed on the App Service.
    :vartype version: str
    :ivar monitoring_type: The monitoring mode of OneAgent. Possible values include:
     "CLOUD_INFRASTRUCTURE", "FULL_STACK".
    :vartype monitoring_type: str or ~azure.mgmt.dynatrace.models.MonitoringType
    :ivar auto_update_setting: Update settings of OneAgent. Possible values include: "ENABLED",
     "DISABLED".
    :vartype auto_update_setting: str or ~azure.mgmt.dynatrace.models.AutoUpdateSetting
    :ivar update_status: The current update status of OneAgent. Possible values include:
     "INCOMPATIBLE", "OUTDATED", "SCHEDULED", "SUPPRESSED", "UNKNOWN", "UP2DATE",
     "UPDATE_IN_PROGRESS", "UPDATE_PENDING", "UPDATE_PROBLEM".
    :vartype update_status: str or ~azure.mgmt.dynatrace.models.UpdateStatus
    :ivar availability_state: The availability state of OneAgent. Possible values include:
     "CRASHED", "LOST", "MONITORED", "PRE_MONITORED", "SHUTDOWN", "UNEXPECTED_SHUTDOWN", "UNKNOWN",
     "UNMONITORED".
    :vartype availability_state: str or ~azure.mgmt.dynatrace.models.AvailabilityState
    :ivar log_module: Tells whether log modules are enabled or not. Possible values include:
     "ENABLED", "DISABLED".
    :vartype log_module: str or ~azure.mgmt.dynatrace.models.LogModule
    :ivar host_group: The name of the host group.
    :vartype host_group: str
    :ivar host_name: The name of the host.
    :vartype host_name: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'monitoring_type': {'key': 'monitoringType', 'type': 'str'},
        'auto_update_setting': {'key': 'autoUpdateSetting', 'type': 'str'},
        'update_status': {'key': 'updateStatus', 'type': 'str'},
        'availability_state': {'key': 'availabilityState', 'type': 'str'},
        'log_module': {'key': 'logModule', 'type': 'str'},
        'host_group': {'key': 'hostGroup', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        version: Optional[str] = None,
        monitoring_type: Optional[Union[str, "MonitoringType"]] = None,
        auto_update_setting: Optional[Union[str, "AutoUpdateSetting"]] = None,
        update_status: Optional[Union[str, "UpdateStatus"]] = None,
        availability_state: Optional[Union[str, "AvailabilityState"]] = None,
        log_module: Optional[Union[str, "LogModule"]] = None,
        host_group: Optional[str] = None,
        host_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword resource_id: App service resource ID.
        :paramtype resource_id: str
        :keyword version: Version of the Dynatrace agent installed on the App Service.
        :paramtype version: str
        :keyword monitoring_type: The monitoring mode of OneAgent. Possible values include:
         "CLOUD_INFRASTRUCTURE", "FULL_STACK".
        :paramtype monitoring_type: str or ~azure.mgmt.dynatrace.models.MonitoringType
        :keyword auto_update_setting: Update settings of OneAgent. Possible values include: "ENABLED",
         "DISABLED".
        :paramtype auto_update_setting: str or ~azure.mgmt.dynatrace.models.AutoUpdateSetting
        :keyword update_status: The current update status of OneAgent. Possible values include:
         "INCOMPATIBLE", "OUTDATED", "SCHEDULED", "SUPPRESSED", "UNKNOWN", "UP2DATE",
         "UPDATE_IN_PROGRESS", "UPDATE_PENDING", "UPDATE_PROBLEM".
        :paramtype update_status: str or ~azure.mgmt.dynatrace.models.UpdateStatus
        :keyword availability_state: The availability state of OneAgent. Possible values include:
         "CRASHED", "LOST", "MONITORED", "PRE_MONITORED", "SHUTDOWN", "UNEXPECTED_SHUTDOWN", "UNKNOWN",
         "UNMONITORED".
        :paramtype availability_state: str or ~azure.mgmt.dynatrace.models.AvailabilityState
        :keyword log_module: Tells whether log modules are enabled or not. Possible values include:
         "ENABLED", "DISABLED".
        :paramtype log_module: str or ~azure.mgmt.dynatrace.models.LogModule
        :keyword host_group: The name of the host group.
        :paramtype host_group: str
        :keyword host_name: The name of the host.
        :paramtype host_name: str
        """
        super(AppServiceInfo, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.version = version
        self.monitoring_type = monitoring_type
        self.auto_update_setting = auto_update_setting
        self.update_status = update_status
        self.availability_state = availability_state
        self.log_module = log_module
        self.host_group = host_group
        self.host_name = host_name


class AppServiceListResponse(msrest.serialization.Model):
    """Response of a list App Services Operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. The items on this page.
    :vartype value: list[~azure.mgmt.dynatrace.models.AppServiceInfo]
    :ivar next_link: Required. The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AppServiceInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["AppServiceInfo"],
        next_link: str,
        **kwargs
    ):
        """
        :keyword value: Required. The items on this page.
        :paramtype value: list[~azure.mgmt.dynatrace.models.AppServiceInfo]
        :keyword next_link: Required. The link to the next page of items.
        :paramtype next_link: str
        """
        super(AppServiceListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DynatraceEnvironmentProperties(msrest.serialization.Model):
    """Properties of the Dynatrace environment.

    :ivar user_id: User id.
    :vartype user_id: str
    :ivar account_info: Dynatrace Account Information.
    :vartype account_info: ~azure.mgmt.dynatrace.models.AccountInfo
    :ivar environment_info: Dynatrace Environment Information.
    :vartype environment_info: ~azure.mgmt.dynatrace.models.EnvironmentInfo
    :ivar single_sign_on_properties: The details of a Dynatrace single sign-on.
    :vartype single_sign_on_properties:
     ~azure.mgmt.dynatrace.models.DynatraceSingleSignOnProperties
    """

    _attribute_map = {
        'user_id': {'key': 'userId', 'type': 'str'},
        'account_info': {'key': 'accountInfo', 'type': 'AccountInfo'},
        'environment_info': {'key': 'environmentInfo', 'type': 'EnvironmentInfo'},
        'single_sign_on_properties': {'key': 'singleSignOnProperties', 'type': 'DynatraceSingleSignOnProperties'},
    }

    def __init__(
        self,
        *,
        user_id: Optional[str] = None,
        account_info: Optional["AccountInfo"] = None,
        environment_info: Optional["EnvironmentInfo"] = None,
        single_sign_on_properties: Optional["DynatraceSingleSignOnProperties"] = None,
        **kwargs
    ):
        """
        :keyword user_id: User id.
        :paramtype user_id: str
        :keyword account_info: Dynatrace Account Information.
        :paramtype account_info: ~azure.mgmt.dynatrace.models.AccountInfo
        :keyword environment_info: Dynatrace Environment Information.
        :paramtype environment_info: ~azure.mgmt.dynatrace.models.EnvironmentInfo
        :keyword single_sign_on_properties: The details of a Dynatrace single sign-on.
        :paramtype single_sign_on_properties:
         ~azure.mgmt.dynatrace.models.DynatraceSingleSignOnProperties
        """
        super(DynatraceEnvironmentProperties, self).__init__(**kwargs)
        self.user_id = user_id
        self.account_info = account_info
        self.environment_info = environment_info
        self.single_sign_on_properties = single_sign_on_properties


class DynatraceSingleSignOnProperties(msrest.serialization.Model):
    """The details of a Dynatrace single sign-on.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar single_sign_on_state: State of Single Sign On. Possible values include: "Initial",
     "Enable", "Disable", "Existing".
    :vartype single_sign_on_state: str or ~azure.mgmt.dynatrace.models.SingleSignOnStates
    :ivar enterprise_app_id: Version of the Dynatrace agent installed on the VM.
    :vartype enterprise_app_id: str
    :ivar single_sign_on_url: The login URL specific to this Dynatrace Environment.
    :vartype single_sign_on_url: str
    :ivar aad_domains: array of Aad(azure active directory) domains.
    :vartype aad_domains: list[str]
    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted",
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.dynatrace.models.ProvisioningState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'single_sign_on_state': {'key': 'singleSignOnState', 'type': 'str'},
        'enterprise_app_id': {'key': 'enterpriseAppId', 'type': 'str'},
        'single_sign_on_url': {'key': 'singleSignOnUrl', 'type': 'str'},
        'aad_domains': {'key': 'aadDomains', 'type': '[str]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        single_sign_on_state: Optional[Union[str, "SingleSignOnStates"]] = None,
        enterprise_app_id: Optional[str] = None,
        single_sign_on_url: Optional[str] = None,
        aad_domains: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword single_sign_on_state: State of Single Sign On. Possible values include: "Initial",
         "Enable", "Disable", "Existing".
        :paramtype single_sign_on_state: str or ~azure.mgmt.dynatrace.models.SingleSignOnStates
        :keyword enterprise_app_id: Version of the Dynatrace agent installed on the VM.
        :paramtype enterprise_app_id: str
        :keyword single_sign_on_url: The login URL specific to this Dynatrace Environment.
        :paramtype single_sign_on_url: str
        :keyword aad_domains: array of Aad(azure active directory) domains.
        :paramtype aad_domains: list[str]
        """
        super(DynatraceSingleSignOnProperties, self).__init__(**kwargs)
        self.single_sign_on_state = single_sign_on_state
        self.enterprise_app_id = enterprise_app_id
        self.single_sign_on_url = single_sign_on_url
        self.aad_domains = aad_domains
        self.provisioning_state = None


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ProxyResource, self).__init__(**kwargs)


class DynatraceSingleSignOnResource(ProxyResource):
    """Single sign-on configurations for a given monitor resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: System metadata for this resource.
    :vartype system_data: ~azure.mgmt.dynatrace.models.SystemData
    :ivar single_sign_on_state: State of Single Sign On. Possible values include: "Initial",
     "Enable", "Disable", "Existing".
    :vartype single_sign_on_state: str or ~azure.mgmt.dynatrace.models.SingleSignOnStates
    :ivar enterprise_app_id: Version of the Dynatrace agent installed on the VM.
    :vartype enterprise_app_id: str
    :ivar single_sign_on_url: The login URL specific to this Dynatrace Environment.
    :vartype single_sign_on_url: str
    :ivar aad_domains: array of Aad(azure active directory) domains.
    :vartype aad_domains: list[str]
    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted",
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.dynatrace.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'single_sign_on_state': {'key': 'properties.singleSignOnState', 'type': 'str'},
        'enterprise_app_id': {'key': 'properties.enterpriseAppId', 'type': 'str'},
        'single_sign_on_url': {'key': 'properties.singleSignOnUrl', 'type': 'str'},
        'aad_domains': {'key': 'properties.aadDomains', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        single_sign_on_state: Optional[Union[str, "SingleSignOnStates"]] = None,
        enterprise_app_id: Optional[str] = None,
        single_sign_on_url: Optional[str] = None,
        aad_domains: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword single_sign_on_state: State of Single Sign On. Possible values include: "Initial",
         "Enable", "Disable", "Existing".
        :paramtype single_sign_on_state: str or ~azure.mgmt.dynatrace.models.SingleSignOnStates
        :keyword enterprise_app_id: Version of the Dynatrace agent installed on the VM.
        :paramtype enterprise_app_id: str
        :keyword single_sign_on_url: The login URL specific to this Dynatrace Environment.
        :paramtype single_sign_on_url: str
        :keyword aad_domains: array of Aad(azure active directory) domains.
        :paramtype aad_domains: list[str]
        """
        super(DynatraceSingleSignOnResource, self).__init__(**kwargs)
        self.system_data = None
        self.single_sign_on_state = single_sign_on_state
        self.enterprise_app_id = enterprise_app_id
        self.single_sign_on_url = single_sign_on_url
        self.aad_domains = aad_domains
        self.provisioning_state = None


class DynatraceSingleSignOnResourceListResult(msrest.serialization.Model):
    """The response of a DynatraceSingleSignOnResource list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. The items on this page.
    :vartype value: list[~azure.mgmt.dynatrace.models.DynatraceSingleSignOnResource]
    :ivar next_link: Required. The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DynatraceSingleSignOnResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DynatraceSingleSignOnResource"],
        next_link: str,
        **kwargs
    ):
        """
        :keyword value: Required. The items on this page.
        :paramtype value: list[~azure.mgmt.dynatrace.models.DynatraceSingleSignOnResource]
        :keyword next_link: Required. The link to the next page of items.
        :paramtype next_link: str
        """
        super(DynatraceSingleSignOnResourceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EnvironmentInfo(msrest.serialization.Model):
    """Dynatrace Environment Information.

    :ivar environment_id: Id of the environment created.
    :vartype environment_id: str
    :ivar ingestion_key: Ingestion key of the environment.
    :vartype ingestion_key: str
    :ivar logs_ingestion_endpoint: Ingestion endpoint used for sending logs.
    :vartype logs_ingestion_endpoint: str
    :ivar landing_url: Landing URL for Dynatrace environment.
    :vartype landing_url: str
    """

    _attribute_map = {
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'ingestion_key': {'key': 'ingestionKey', 'type': 'str'},
        'logs_ingestion_endpoint': {'key': 'logsIngestionEndpoint', 'type': 'str'},
        'landing_url': {'key': 'landingURL', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        environment_id: Optional[str] = None,
        ingestion_key: Optional[str] = None,
        logs_ingestion_endpoint: Optional[str] = None,
        landing_url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword environment_id: Id of the environment created.
        :paramtype environment_id: str
        :keyword ingestion_key: Ingestion key of the environment.
        :paramtype ingestion_key: str
        :keyword logs_ingestion_endpoint: Ingestion endpoint used for sending logs.
        :paramtype logs_ingestion_endpoint: str
        :keyword landing_url: Landing URL for Dynatrace environment.
        :paramtype landing_url: str
        """
        super(EnvironmentInfo, self).__init__(**kwargs)
        self.environment_id = environment_id
        self.ingestion_key = ingestion_key
        self.logs_ingestion_endpoint = logs_ingestion_endpoint
        self.landing_url = landing_url


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.dynatrace.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.dynatrace.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.dynatrace.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.dynatrace.models.ErrorDetail
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class FilteringTag(msrest.serialization.Model):
    """The definition of a filtering tag. Filtering tags are used for capturing resources and include/exclude them from being monitored.

    :ivar name: The name (also known as the key) of the tag.
    :vartype name: str
    :ivar value: The value of the tag.
    :vartype value: str
    :ivar action: Valid actions for a filtering tag. Exclusion takes priority over inclusion.
     Possible values include: "Include", "Exclude".
    :vartype action: str or ~azure.mgmt.dynatrace.models.TagAction
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        action: Optional[Union[str, "TagAction"]] = None,
        **kwargs
    ):
        """
        :keyword name: The name (also known as the key) of the tag.
        :paramtype name: str
        :keyword value: The value of the tag.
        :paramtype value: str
        :keyword action: Valid actions for a filtering tag. Exclusion takes priority over inclusion.
         Possible values include: "Include", "Exclude".
        :paramtype action: str or ~azure.mgmt.dynatrace.models.TagAction
        """
        super(FilteringTag, self).__init__(**kwargs)
        self.name = name
        self.value = value
        self.action = action


class IdentityProperties(msrest.serialization.Model):
    """The properties of the managed service identities assigned to this resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The Active Directory tenant id of the principal.
    :vartype tenant_id: str
    :ivar principal_id: The active directory identifier of this principal.
    :vartype principal_id: str
    :ivar type: Required. The type of managed identity assigned to this resource. Possible values
     include: "SystemAssigned", "UserAssigned", "SystemAndUserAssigned".
    :vartype type: str or ~azure.mgmt.dynatrace.models.ManagedIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.dynatrace.models.UserAssignedIdentity]
    """

    _validation = {
        'tenant_id': {'readonly': True},
        'principal_id': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentity}'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "ManagedIdentityType"],
        user_assigned_identities: Optional[Dict[str, "UserAssignedIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword type: Required. The type of managed identity assigned to this resource. Possible
         values include: "SystemAssigned", "UserAssigned", "SystemAndUserAssigned".
        :paramtype type: str or ~azure.mgmt.dynatrace.models.ManagedIdentityType
        :keyword user_assigned_identities: The identities assigned to this resource by the user.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.dynatrace.models.UserAssignedIdentity]
        """
        super(IdentityProperties, self).__init__(**kwargs)
        self.tenant_id = None
        self.principal_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class LinkableEnvironmentListResponse(msrest.serialization.Model):
    """Response for getting all the linkable environments.

    :ivar value: List of environments for which user is an admin.
    :vartype value: list[~azure.mgmt.dynatrace.models.LinkableEnvironmentResponse]
    :ivar next_link: Link to the next set of results, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LinkableEnvironmentResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["LinkableEnvironmentResponse"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of environments for which user is an admin.
        :paramtype value: list[~azure.mgmt.dynatrace.models.LinkableEnvironmentResponse]
        :keyword next_link: Link to the next set of results, if any.
        :paramtype next_link: str
        """
        super(LinkableEnvironmentListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LinkableEnvironmentRequest(msrest.serialization.Model):
    """Request for getting all the linkable environments for a user.

    :ivar tenant_id: Tenant Id of the user in which they want to link the environment.
    :vartype tenant_id: str
    :ivar user_principal: user principal id of the user.
    :vartype user_principal: str
    :ivar region: Azure region in which we want to link the environment.
    :vartype region: str
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'user_principal': {'key': 'userPrincipal', 'type': 'str'},
        'region': {'key': 'region', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        user_principal: Optional[str] = None,
        region: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: Tenant Id of the user in which they want to link the environment.
        :paramtype tenant_id: str
        :keyword user_principal: user principal id of the user.
        :paramtype user_principal: str
        :keyword region: Azure region in which we want to link the environment.
        :paramtype region: str
        """
        super(LinkableEnvironmentRequest, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.user_principal = user_principal
        self.region = region


class LinkableEnvironmentResponse(msrest.serialization.Model):
    """Response for getting all the linkable environments.

    :ivar environment_id: environment id for which user is an admin.
    :vartype environment_id: str
    :ivar environment_name: Name of the environment.
    :vartype environment_name: str
    :ivar plan_data: Billing plan information.
    :vartype plan_data: ~azure.mgmt.dynatrace.models.PlanData
    """

    _attribute_map = {
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_name': {'key': 'environmentName', 'type': 'str'},
        'plan_data': {'key': 'planData', 'type': 'PlanData'},
    }

    def __init__(
        self,
        *,
        environment_id: Optional[str] = None,
        environment_name: Optional[str] = None,
        plan_data: Optional["PlanData"] = None,
        **kwargs
    ):
        """
        :keyword environment_id: environment id for which user is an admin.
        :paramtype environment_id: str
        :keyword environment_name: Name of the environment.
        :paramtype environment_name: str
        :keyword plan_data: Billing plan information.
        :paramtype plan_data: ~azure.mgmt.dynatrace.models.PlanData
        """
        super(LinkableEnvironmentResponse, self).__init__(**kwargs)
        self.environment_id = environment_id
        self.environment_name = environment_name
        self.plan_data = plan_data


class LogRules(msrest.serialization.Model):
    """Set of rules for sending logs for the Monitor resource.

    :ivar send_aad_logs: Flag specifying if AAD logs should be sent for the Monitor resource.
     Possible values include: "Enabled", "Disabled".
    :vartype send_aad_logs: str or ~azure.mgmt.dynatrace.models.SendAadLogsStatus
    :ivar send_subscription_logs: Flag specifying if subscription logs should be sent for the
     Monitor resource. Possible values include: "Enabled", "Disabled".
    :vartype send_subscription_logs: str or ~azure.mgmt.dynatrace.models.SendSubscriptionLogsStatus
    :ivar send_activity_logs: Flag specifying if activity logs from Azure resources should be sent
     for the Monitor resource. Possible values include: "Enabled", "Disabled".
    :vartype send_activity_logs: str or ~azure.mgmt.dynatrace.models.SendActivityLogsStatus
    :ivar filtering_tags: List of filtering tags to be used for capturing logs. This only takes
     effect if SendActivityLogs flag is enabled. If empty, all resources will be captured.
     If only Exclude action is specified, the rules will apply to the list of all available
     resources. If Include actions are specified, the rules will only include resources with the
     associated tags.
    :vartype filtering_tags: list[~azure.mgmt.dynatrace.models.FilteringTag]
    """

    _attribute_map = {
        'send_aad_logs': {'key': 'sendAadLogs', 'type': 'str'},
        'send_subscription_logs': {'key': 'sendSubscriptionLogs', 'type': 'str'},
        'send_activity_logs': {'key': 'sendActivityLogs', 'type': 'str'},
        'filtering_tags': {'key': 'filteringTags', 'type': '[FilteringTag]'},
    }

    def __init__(
        self,
        *,
        send_aad_logs: Optional[Union[str, "SendAadLogsStatus"]] = None,
        send_subscription_logs: Optional[Union[str, "SendSubscriptionLogsStatus"]] = None,
        send_activity_logs: Optional[Union[str, "SendActivityLogsStatus"]] = None,
        filtering_tags: Optional[List["FilteringTag"]] = None,
        **kwargs
    ):
        """
        :keyword send_aad_logs: Flag specifying if AAD logs should be sent for the Monitor resource.
         Possible values include: "Enabled", "Disabled".
        :paramtype send_aad_logs: str or ~azure.mgmt.dynatrace.models.SendAadLogsStatus
        :keyword send_subscription_logs: Flag specifying if subscription logs should be sent for the
         Monitor resource. Possible values include: "Enabled", "Disabled".
        :paramtype send_subscription_logs: str or
         ~azure.mgmt.dynatrace.models.SendSubscriptionLogsStatus
        :keyword send_activity_logs: Flag specifying if activity logs from Azure resources should be
         sent for the Monitor resource. Possible values include: "Enabled", "Disabled".
        :paramtype send_activity_logs: str or ~azure.mgmt.dynatrace.models.SendActivityLogsStatus
        :keyword filtering_tags: List of filtering tags to be used for capturing logs. This only takes
         effect if SendActivityLogs flag is enabled. If empty, all resources will be captured.
         If only Exclude action is specified, the rules will apply to the list of all available
         resources. If Include actions are specified, the rules will only include resources with the
         associated tags.
        :paramtype filtering_tags: list[~azure.mgmt.dynatrace.models.FilteringTag]
        """
        super(LogRules, self).__init__(**kwargs)
        self.send_aad_logs = send_aad_logs
        self.send_subscription_logs = send_subscription_logs
        self.send_activity_logs = send_activity_logs
        self.filtering_tags = filtering_tags


class MetricRules(msrest.serialization.Model):
    """Set of rules for sending metrics for the Monitor resource.

    :ivar filtering_tags: List of filtering tags to be used for capturing metrics. If empty, all
     resources will be captured. If only Exclude action is specified, the rules will apply to the
     list of all available resources. If Include actions are specified, the rules will only include
     resources with the associated tags.
    :vartype filtering_tags: list[~azure.mgmt.dynatrace.models.FilteringTag]
    """

    _attribute_map = {
        'filtering_tags': {'key': 'filteringTags', 'type': '[FilteringTag]'},
    }

    def __init__(
        self,
        *,
        filtering_tags: Optional[List["FilteringTag"]] = None,
        **kwargs
    ):
        """
        :keyword filtering_tags: List of filtering tags to be used for capturing metrics. If empty, all
         resources will be captured. If only Exclude action is specified, the rules will apply to the
         list of all available resources. If Include actions are specified, the rules will only include
         resources with the associated tags.
        :paramtype filtering_tags: list[~azure.mgmt.dynatrace.models.FilteringTag]
        """
        super(MetricRules, self).__init__(**kwargs)
        self.filtering_tags = filtering_tags


class MonitoredResource(msrest.serialization.Model):
    """Details of resource being monitored by Dynatrace monitor resource.

    :ivar id: The ARM id of the resource.
    :vartype id: str
    :ivar sending_metrics: Flag indicating if resource is sending metrics to Dynatrace. Possible
     values include: "Enabled", "Disabled".
    :vartype sending_metrics: str or ~azure.mgmt.dynatrace.models.SendingMetricsStatus
    :ivar reason_for_metrics_status: Reason for why the resource is sending metrics (or why it is
     not sending).
    :vartype reason_for_metrics_status: str
    :ivar sending_logs: Flag indicating if resource is sending logs to Dynatrace. Possible values
     include: "Enabled", "Disabled".
    :vartype sending_logs: str or ~azure.mgmt.dynatrace.models.SendingLogsStatus
    :ivar reason_for_logs_status: Reason for why the resource is sending logs (or why it is not
     sending).
    :vartype reason_for_logs_status: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'sending_metrics': {'key': 'sendingMetrics', 'type': 'str'},
        'reason_for_metrics_status': {'key': 'reasonForMetricsStatus', 'type': 'str'},
        'sending_logs': {'key': 'sendingLogs', 'type': 'str'},
        'reason_for_logs_status': {'key': 'reasonForLogsStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        sending_metrics: Optional[Union[str, "SendingMetricsStatus"]] = None,
        reason_for_metrics_status: Optional[str] = None,
        sending_logs: Optional[Union[str, "SendingLogsStatus"]] = None,
        reason_for_logs_status: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: The ARM id of the resource.
        :paramtype id: str
        :keyword sending_metrics: Flag indicating if resource is sending metrics to Dynatrace. Possible
         values include: "Enabled", "Disabled".
        :paramtype sending_metrics: str or ~azure.mgmt.dynatrace.models.SendingMetricsStatus
        :keyword reason_for_metrics_status: Reason for why the resource is sending metrics (or why it
         is not sending).
        :paramtype reason_for_metrics_status: str
        :keyword sending_logs: Flag indicating if resource is sending logs to Dynatrace. Possible
         values include: "Enabled", "Disabled".
        :paramtype sending_logs: str or ~azure.mgmt.dynatrace.models.SendingLogsStatus
        :keyword reason_for_logs_status: Reason for why the resource is sending logs (or why it is not
         sending).
        :paramtype reason_for_logs_status: str
        """
        super(MonitoredResource, self).__init__(**kwargs)
        self.id = id
        self.sending_metrics = sending_metrics
        self.reason_for_metrics_status = reason_for_metrics_status
        self.sending_logs = sending_logs
        self.reason_for_logs_status = reason_for_logs_status


class MonitoredResourceListResponse(msrest.serialization.Model):
    """List of all the resources being monitored by Dynatrace monitor resource.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. The items on this page.
    :vartype value: list[~azure.mgmt.dynatrace.models.MonitoredResource]
    :ivar next_link: Required. The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MonitoredResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["MonitoredResource"],
        next_link: str,
        **kwargs
    ):
        """
        :keyword value: Required. The items on this page.
        :paramtype value: list[~azure.mgmt.dynatrace.models.MonitoredResource]
        :keyword next_link: Required. The link to the next page of items.
        :paramtype next_link: str
        """
        super(MonitoredResourceListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        """
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class MonitorResource(TrackedResource):
    """Dynatrace Monitor Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: System metadata for this resource.
    :vartype system_data: ~azure.mgmt.dynatrace.models.SystemData
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.dynatrace.models.IdentityProperties
    :ivar monitoring_status: Status of the monitor. Possible values include: "Enabled", "Disabled".
    :vartype monitoring_status: str or ~azure.mgmt.dynatrace.models.MonitoringStatus
    :ivar marketplace_subscription_status: Marketplace subscription status. Possible values
     include: "Active", "Suspended".
    :vartype marketplace_subscription_status: str or
     ~azure.mgmt.dynatrace.models.MarketplaceSubscriptionStatus
    :ivar dynatrace_environment_properties: Properties of the Dynatrace environment.
    :vartype dynatrace_environment_properties:
     ~azure.mgmt.dynatrace.models.DynatraceEnvironmentProperties
    :ivar user_info: User info.
    :vartype user_info: ~azure.mgmt.dynatrace.models.UserInfo
    :ivar plan_data: Billing plan information.
    :vartype plan_data: ~azure.mgmt.dynatrace.models.PlanData
    :ivar liftr_resource_category: Liftr Resource category. Possible values include: "Unknown",
     "MonitorLogs".
    :vartype liftr_resource_category: str or ~azure.mgmt.dynatrace.models.LiftrResourceCategories
    :ivar liftr_resource_preference: The priority of the resource.
    :vartype liftr_resource_preference: int
    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted",
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.dynatrace.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'liftr_resource_category': {'readonly': True},
        'liftr_resource_preference': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'identity': {'key': 'identity', 'type': 'IdentityProperties'},
        'monitoring_status': {'key': 'properties.monitoringStatus', 'type': 'str'},
        'marketplace_subscription_status': {'key': 'properties.marketplaceSubscriptionStatus', 'type': 'str'},
        'dynatrace_environment_properties': {'key': 'properties.dynatraceEnvironmentProperties', 'type': 'DynatraceEnvironmentProperties'},
        'user_info': {'key': 'properties.userInfo', 'type': 'UserInfo'},
        'plan_data': {'key': 'properties.planData', 'type': 'PlanData'},
        'liftr_resource_category': {'key': 'properties.liftrResourceCategory', 'type': 'str'},
        'liftr_resource_preference': {'key': 'properties.liftrResourcePreference', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["IdentityProperties"] = None,
        monitoring_status: Optional[Union[str, "MonitoringStatus"]] = None,
        marketplace_subscription_status: Optional[Union[str, "MarketplaceSubscriptionStatus"]] = None,
        dynatrace_environment_properties: Optional["DynatraceEnvironmentProperties"] = None,
        user_info: Optional["UserInfo"] = None,
        plan_data: Optional["PlanData"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity: ~azure.mgmt.dynatrace.models.IdentityProperties
        :keyword monitoring_status: Status of the monitor. Possible values include: "Enabled",
         "Disabled".
        :paramtype monitoring_status: str or ~azure.mgmt.dynatrace.models.MonitoringStatus
        :keyword marketplace_subscription_status: Marketplace subscription status. Possible values
         include: "Active", "Suspended".
        :paramtype marketplace_subscription_status: str or
         ~azure.mgmt.dynatrace.models.MarketplaceSubscriptionStatus
        :keyword dynatrace_environment_properties: Properties of the Dynatrace environment.
        :paramtype dynatrace_environment_properties:
         ~azure.mgmt.dynatrace.models.DynatraceEnvironmentProperties
        :keyword user_info: User info.
        :paramtype user_info: ~azure.mgmt.dynatrace.models.UserInfo
        :keyword plan_data: Billing plan information.
        :paramtype plan_data: ~azure.mgmt.dynatrace.models.PlanData
        """
        super(MonitorResource, self).__init__(tags=tags, location=location, **kwargs)
        self.system_data = None
        self.identity = identity
        self.monitoring_status = monitoring_status
        self.marketplace_subscription_status = marketplace_subscription_status
        self.dynatrace_environment_properties = dynatrace_environment_properties
        self.user_info = user_info
        self.plan_data = plan_data
        self.liftr_resource_category = None
        self.liftr_resource_preference = None
        self.provisioning_state = None


class MonitorResourceListResult(msrest.serialization.Model):
    """The response of a MonitorResource list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. The items on this page.
    :vartype value: list[~azure.mgmt.dynatrace.models.MonitorResource]
    :ivar next_link: Required. The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MonitorResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["MonitorResource"],
        next_link: str,
        **kwargs
    ):
        """
        :keyword value: Required. The items on this page.
        :paramtype value: list[~azure.mgmt.dynatrace.models.MonitorResource]
        :keyword next_link: Required. The link to the next page of items.
        :paramtype next_link: str
        """
        super(MonitorResourceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MonitorResourceUpdate(msrest.serialization.Model):
    """The updatable properties of the MonitorResource.

    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar monitoring_status: Status of the monitor. Possible values include: "Enabled", "Disabled".
    :vartype monitoring_status: str or ~azure.mgmt.dynatrace.models.MonitoringStatus
    :ivar marketplace_subscription_status: Marketplace subscription status. Possible values
     include: "Active", "Suspended".
    :vartype marketplace_subscription_status: str or
     ~azure.mgmt.dynatrace.models.MarketplaceSubscriptionStatus
    :ivar dynatrace_environment_properties: Properties of the Dynatrace environment.
    :vartype dynatrace_environment_properties:
     ~azure.mgmt.dynatrace.models.DynatraceEnvironmentProperties
    :ivar user_info: User info.
    :vartype user_info: ~azure.mgmt.dynatrace.models.UserInfo
    :ivar plan_data: Billing plan information.
    :vartype plan_data: ~azure.mgmt.dynatrace.models.PlanData
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'monitoring_status': {'key': 'monitoringStatus', 'type': 'str'},
        'marketplace_subscription_status': {'key': 'marketplaceSubscriptionStatus', 'type': 'str'},
        'dynatrace_environment_properties': {'key': 'dynatraceEnvironmentProperties', 'type': 'DynatraceEnvironmentProperties'},
        'user_info': {'key': 'userInfo', 'type': 'UserInfo'},
        'plan_data': {'key': 'planData', 'type': 'PlanData'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        monitoring_status: Optional[Union[str, "MonitoringStatus"]] = None,
        marketplace_subscription_status: Optional[Union[str, "MarketplaceSubscriptionStatus"]] = None,
        dynatrace_environment_properties: Optional["DynatraceEnvironmentProperties"] = None,
        user_info: Optional["UserInfo"] = None,
        plan_data: Optional["PlanData"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword monitoring_status: Status of the monitor. Possible values include: "Enabled",
         "Disabled".
        :paramtype monitoring_status: str or ~azure.mgmt.dynatrace.models.MonitoringStatus
        :keyword marketplace_subscription_status: Marketplace subscription status. Possible values
         include: "Active", "Suspended".
        :paramtype marketplace_subscription_status: str or
         ~azure.mgmt.dynatrace.models.MarketplaceSubscriptionStatus
        :keyword dynatrace_environment_properties: Properties of the Dynatrace environment.
        :paramtype dynatrace_environment_properties:
         ~azure.mgmt.dynatrace.models.DynatraceEnvironmentProperties
        :keyword user_info: User info.
        :paramtype user_info: ~azure.mgmt.dynatrace.models.UserInfo
        :keyword plan_data: Billing plan information.
        :paramtype plan_data: ~azure.mgmt.dynatrace.models.PlanData
        """
        super(MonitorResourceUpdate, self).__init__(**kwargs)
        self.tags = tags
        self.monitoring_status = monitoring_status
        self.marketplace_subscription_status = marketplace_subscription_status
        self.dynatrace_environment_properties = dynatrace_environment_properties
        self.user_info = user_info
        self.plan_data = plan_data


class Operation(msrest.serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.dynatrace.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Possible values include: "user",
     "system", "user,system".
    :vartype origin: str or ~azure.mgmt.dynatrace.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. Possible values include: "Internal".
    :vartype action_type: str or ~azure.mgmt.dynatrace.models.ActionType
    """

    _validation = {
        'name': {'readonly': True},
        'is_data_action': {'readonly': True},
        'origin': {'readonly': True},
        'action_type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'action_type': {'key': 'actionType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.dynatrace.models.OperationDisplay
        """
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(msrest.serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.dynatrace.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PlanData(msrest.serialization.Model):
    """Billing plan information.

    :ivar usage_type: different usage type like PAYG/COMMITTED. this could be enum.
    :vartype usage_type: str
    :ivar billing_cycle: different billing cycles like MONTHLY/WEEKLY. this could be enum.
    :vartype billing_cycle: str
    :ivar plan_details: plan id as published by Dynatrace.
    :vartype plan_details: str
    :ivar effective_date: date when plan was applied.
    :vartype effective_date: ~datetime.datetime
    """

    _validation = {
        'usage_type': {'max_length': 50, 'min_length': 0},
        'billing_cycle': {'max_length': 50, 'min_length': 0},
        'plan_details': {'max_length': 50, 'min_length': 0},
    }

    _attribute_map = {
        'usage_type': {'key': 'usageType', 'type': 'str'},
        'billing_cycle': {'key': 'billingCycle', 'type': 'str'},
        'plan_details': {'key': 'planDetails', 'type': 'str'},
        'effective_date': {'key': 'effectiveDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        usage_type: Optional[str] = None,
        billing_cycle: Optional[str] = None,
        plan_details: Optional[str] = None,
        effective_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword usage_type: different usage type like PAYG/COMMITTED. this could be enum.
        :paramtype usage_type: str
        :keyword billing_cycle: different billing cycles like MONTHLY/WEEKLY. this could be enum.
        :paramtype billing_cycle: str
        :keyword plan_details: plan id as published by Dynatrace.
        :paramtype plan_details: str
        :keyword effective_date: date when plan was applied.
        :paramtype effective_date: ~datetime.datetime
        """
        super(PlanData, self).__init__(**kwargs)
        self.usage_type = usage_type
        self.billing_cycle = billing_cycle
        self.plan_details = plan_details
        self.effective_date = effective_date


class SSODetailsRequest(msrest.serialization.Model):
    """Request for getting sso details for a user.

    :ivar user_principal: user principal id of the user.
    :vartype user_principal: str
    """

    _attribute_map = {
        'user_principal': {'key': 'userPrincipal', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_principal: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword user_principal: user principal id of the user.
        :paramtype user_principal: str
        """
        super(SSODetailsRequest, self).__init__(**kwargs)
        self.user_principal = user_principal


class SSODetailsResponse(msrest.serialization.Model):
    """SSO details from the Dynatrace partner.

    :ivar is_sso_enabled: Whether the SSO is enabled for this resource or not. Possible values
     include: "Enabled", "Disabled".
    :vartype is_sso_enabled: str or ~azure.mgmt.dynatrace.models.SSOStatus
    :ivar metadata_url: URL for Azure AD metadata.
    :vartype metadata_url: str
    :ivar single_sign_on_url: The login URL specific to this Dynatrace Environment.
    :vartype single_sign_on_url: str
    :ivar aad_domains: array of Aad(azure active directory) domains.
    :vartype aad_domains: list[str]
    :ivar admin_users: Array of admin user emails.
    :vartype admin_users: list[str]
    """

    _attribute_map = {
        'is_sso_enabled': {'key': 'isSsoEnabled', 'type': 'str'},
        'metadata_url': {'key': 'metadataUrl', 'type': 'str'},
        'single_sign_on_url': {'key': 'singleSignOnUrl', 'type': 'str'},
        'aad_domains': {'key': 'aadDomains', 'type': '[str]'},
        'admin_users': {'key': 'adminUsers', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        is_sso_enabled: Optional[Union[str, "SSOStatus"]] = None,
        metadata_url: Optional[str] = None,
        single_sign_on_url: Optional[str] = None,
        aad_domains: Optional[List[str]] = None,
        admin_users: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword is_sso_enabled: Whether the SSO is enabled for this resource or not. Possible values
         include: "Enabled", "Disabled".
        :paramtype is_sso_enabled: str or ~azure.mgmt.dynatrace.models.SSOStatus
        :keyword metadata_url: URL for Azure AD metadata.
        :paramtype metadata_url: str
        :keyword single_sign_on_url: The login URL specific to this Dynatrace Environment.
        :paramtype single_sign_on_url: str
        :keyword aad_domains: array of Aad(azure active directory) domains.
        :paramtype aad_domains: list[str]
        :keyword admin_users: Array of admin user emails.
        :paramtype admin_users: list[str]
        """
        super(SSODetailsResponse, self).__init__(**kwargs)
        self.is_sso_enabled = is_sso_enabled
        self.metadata_url = metadata_url
        self.single_sign_on_url = single_sign_on_url
        self.aad_domains = aad_domains
        self.admin_users = admin_users


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure.mgmt.dynatrace.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.dynatrace.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~azure.mgmt.dynatrace.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.dynatrace.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagRule(ProxyResource):
    """Tag rules for a monitor resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: System metadata for this resource.
    :vartype system_data: ~azure.mgmt.dynatrace.models.SystemData
    :ivar log_rules: Set of rules for sending logs for the Monitor resource.
    :vartype log_rules: ~azure.mgmt.dynatrace.models.LogRules
    :ivar metric_rules: Set of rules for sending metrics for the Monitor resource.
    :vartype metric_rules: ~azure.mgmt.dynatrace.models.MetricRules
    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted",
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.dynatrace.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'log_rules': {'key': 'properties.logRules', 'type': 'LogRules'},
        'metric_rules': {'key': 'properties.metricRules', 'type': 'MetricRules'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        log_rules: Optional["LogRules"] = None,
        metric_rules: Optional["MetricRules"] = None,
        **kwargs
    ):
        """
        :keyword log_rules: Set of rules for sending logs for the Monitor resource.
        :paramtype log_rules: ~azure.mgmt.dynatrace.models.LogRules
        :keyword metric_rules: Set of rules for sending metrics for the Monitor resource.
        :paramtype metric_rules: ~azure.mgmt.dynatrace.models.MetricRules
        """
        super(TagRule, self).__init__(**kwargs)
        self.system_data = None
        self.log_rules = log_rules
        self.metric_rules = metric_rules
        self.provisioning_state = None


class TagRuleListResult(msrest.serialization.Model):
    """The response of a TagRule list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. The items on this page.
    :vartype value: list[~azure.mgmt.dynatrace.models.TagRule]
    :ivar next_link: Required. The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TagRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["TagRule"],
        next_link: str,
        **kwargs
    ):
        """
        :keyword value: Required. The items on this page.
        :paramtype value: list[~azure.mgmt.dynatrace.models.TagRule]
        :keyword next_link: Required. The link to the next page of items.
        :paramtype next_link: str
        """
        super(TagRuleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TagRuleUpdate(msrest.serialization.Model):
    """The updatable properties of the TagRule.

    :ivar log_rules: Set of rules for sending logs for the Monitor resource.
    :vartype log_rules: ~azure.mgmt.dynatrace.models.LogRules
    :ivar metric_rules: Set of rules for sending metrics for the Monitor resource.
    :vartype metric_rules: ~azure.mgmt.dynatrace.models.MetricRules
    """

    _attribute_map = {
        'log_rules': {'key': 'logRules', 'type': 'LogRules'},
        'metric_rules': {'key': 'metricRules', 'type': 'MetricRules'},
    }

    def __init__(
        self,
        *,
        log_rules: Optional["LogRules"] = None,
        metric_rules: Optional["MetricRules"] = None,
        **kwargs
    ):
        """
        :keyword log_rules: Set of rules for sending logs for the Monitor resource.
        :paramtype log_rules: ~azure.mgmt.dynatrace.models.LogRules
        :keyword metric_rules: Set of rules for sending metrics for the Monitor resource.
        :paramtype metric_rules: ~azure.mgmt.dynatrace.models.MetricRules
        """
        super(TagRuleUpdate, self).__init__(**kwargs)
        self.log_rules = log_rules
        self.metric_rules = metric_rules


class UserAssignedIdentity(msrest.serialization.Model):
    """A managed identity assigned by the user.

    All required parameters must be populated in order to send to Azure.

    :ivar client_id: Required. The active directory client identifier for this principal.
    :vartype client_id: str
    :ivar principal_id: Required. The active directory identifier for this principal.
    :vartype principal_id: str
    """

    _validation = {
        'client_id': {'required': True},
        'principal_id': {'required': True},
    }

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: str,
        principal_id: str,
        **kwargs
    ):
        """
        :keyword client_id: Required. The active directory client identifier for this principal.
        :paramtype client_id: str
        :keyword principal_id: Required. The active directory identifier for this principal.
        :paramtype principal_id: str
        """
        super(UserAssignedIdentity, self).__init__(**kwargs)
        self.client_id = client_id
        self.principal_id = principal_id


class UserInfo(msrest.serialization.Model):
    """User info.

    :ivar first_name: First Name of the user.
    :vartype first_name: str
    :ivar last_name: Last Name of the user.
    :vartype last_name: str
    :ivar email_address: Email of the user used by Dynatrace for contacting them if needed.
    :vartype email_address: str
    :ivar phone_number: Phone number of the user used by Dynatrace for contacting them if needed.
    :vartype phone_number: str
    :ivar country: Country of the user.
    :vartype country: str
    """

    _validation = {
        'first_name': {'max_length': 50, 'min_length': 0},
        'last_name': {'max_length': 50, 'min_length': 0},
        'email_address': {'pattern': r'^[A-Za-z0-9._%+-]+@(?:[A-Za-z0-9-]+\.)+[A-Za-z]{2,}$'},
        'phone_number': {'max_length': 40, 'min_length': 0},
    }

    _attribute_map = {
        'first_name': {'key': 'firstName', 'type': 'str'},
        'last_name': {'key': 'lastName', 'type': 'str'},
        'email_address': {'key': 'emailAddress', 'type': 'str'},
        'phone_number': {'key': 'phoneNumber', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        email_address: Optional[str] = None,
        phone_number: Optional[str] = None,
        country: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword first_name: First Name of the user.
        :paramtype first_name: str
        :keyword last_name: Last Name of the user.
        :paramtype last_name: str
        :keyword email_address: Email of the user used by Dynatrace for contacting them if needed.
        :paramtype email_address: str
        :keyword phone_number: Phone number of the user used by Dynatrace for contacting them if
         needed.
        :paramtype phone_number: str
        :keyword country: Country of the user.
        :paramtype country: str
        """
        super(UserInfo, self).__init__(**kwargs)
        self.first_name = first_name
        self.last_name = last_name
        self.email_address = email_address
        self.phone_number = phone_number
        self.country = country


class VMExtensionPayload(msrest.serialization.Model):
    """Response of payload to be passed while installing VM agent.

    :ivar ingestion_key: Ingestion key of the environment.
    :vartype ingestion_key: str
    :ivar environment_id: Id of the environment created.
    :vartype environment_id: str
    """

    _attribute_map = {
        'ingestion_key': {'key': 'ingestionKey', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ingestion_key: Optional[str] = None,
        environment_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword ingestion_key: Ingestion key of the environment.
        :paramtype ingestion_key: str
        :keyword environment_id: Id of the environment created.
        :paramtype environment_id: str
        """
        super(VMExtensionPayload, self).__init__(**kwargs)
        self.ingestion_key = ingestion_key
        self.environment_id = environment_id


class VMHostsListResponse(msrest.serialization.Model):
    """Response of a list VM Host Operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. The items on this page.
    :vartype value: list[~azure.mgmt.dynatrace.models.VMInfo]
    :ivar next_link: Required. The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VMInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["VMInfo"],
        next_link: str,
        **kwargs
    ):
        """
        :keyword value: Required. The items on this page.
        :paramtype value: list[~azure.mgmt.dynatrace.models.VMInfo]
        :keyword next_link: Required. The link to the next page of items.
        :paramtype next_link: str
        """
        super(VMHostsListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VMInfo(msrest.serialization.Model):
    """Details of VM Resource having Dynatrace OneAgent installed.

    :ivar resource_id: Azure VM resource ID.
    :vartype resource_id: str
    :ivar version: Version of the Dynatrace agent installed on the VM.
    :vartype version: str
    :ivar monitoring_type: The monitoring mode of OneAgent. Possible values include:
     "CLOUD_INFRASTRUCTURE", "FULL_STACK".
    :vartype monitoring_type: str or ~azure.mgmt.dynatrace.models.MonitoringType
    :ivar auto_update_setting: Update settings of OneAgent. Possible values include: "ENABLED",
     "DISABLED".
    :vartype auto_update_setting: str or ~azure.mgmt.dynatrace.models.AutoUpdateSetting
    :ivar update_status: The current update status of OneAgent. Possible values include:
     "INCOMPATIBLE", "OUTDATED", "SCHEDULED", "SUPPRESSED", "UNKNOWN", "UP2DATE",
     "UPDATE_IN_PROGRESS", "UPDATE_PENDING", "UPDATE_PROBLEM".
    :vartype update_status: str or ~azure.mgmt.dynatrace.models.UpdateStatus
    :ivar availability_state: The availability state of OneAgent. Possible values include:
     "CRASHED", "LOST", "MONITORED", "PRE_MONITORED", "SHUTDOWN", "UNEXPECTED_SHUTDOWN", "UNKNOWN",
     "UNMONITORED".
    :vartype availability_state: str or ~azure.mgmt.dynatrace.models.AvailabilityState
    :ivar log_module: Tells whether log modules are enabled or not. Possible values include:
     "ENABLED", "DISABLED".
    :vartype log_module: str or ~azure.mgmt.dynatrace.models.LogModule
    :ivar host_group: The name of the host group.
    :vartype host_group: str
    :ivar host_name: The name of the host.
    :vartype host_name: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'monitoring_type': {'key': 'monitoringType', 'type': 'str'},
        'auto_update_setting': {'key': 'autoUpdateSetting', 'type': 'str'},
        'update_status': {'key': 'updateStatus', 'type': 'str'},
        'availability_state': {'key': 'availabilityState', 'type': 'str'},
        'log_module': {'key': 'logModule', 'type': 'str'},
        'host_group': {'key': 'hostGroup', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        version: Optional[str] = None,
        monitoring_type: Optional[Union[str, "MonitoringType"]] = None,
        auto_update_setting: Optional[Union[str, "AutoUpdateSetting"]] = None,
        update_status: Optional[Union[str, "UpdateStatus"]] = None,
        availability_state: Optional[Union[str, "AvailabilityState"]] = None,
        log_module: Optional[Union[str, "LogModule"]] = None,
        host_group: Optional[str] = None,
        host_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword resource_id: Azure VM resource ID.
        :paramtype resource_id: str
        :keyword version: Version of the Dynatrace agent installed on the VM.
        :paramtype version: str
        :keyword monitoring_type: The monitoring mode of OneAgent. Possible values include:
         "CLOUD_INFRASTRUCTURE", "FULL_STACK".
        :paramtype monitoring_type: str or ~azure.mgmt.dynatrace.models.MonitoringType
        :keyword auto_update_setting: Update settings of OneAgent. Possible values include: "ENABLED",
         "DISABLED".
        :paramtype auto_update_setting: str or ~azure.mgmt.dynatrace.models.AutoUpdateSetting
        :keyword update_status: The current update status of OneAgent. Possible values include:
         "INCOMPATIBLE", "OUTDATED", "SCHEDULED", "SUPPRESSED", "UNKNOWN", "UP2DATE",
         "UPDATE_IN_PROGRESS", "UPDATE_PENDING", "UPDATE_PROBLEM".
        :paramtype update_status: str or ~azure.mgmt.dynatrace.models.UpdateStatus
        :keyword availability_state: The availability state of OneAgent. Possible values include:
         "CRASHED", "LOST", "MONITORED", "PRE_MONITORED", "SHUTDOWN", "UNEXPECTED_SHUTDOWN", "UNKNOWN",
         "UNMONITORED".
        :paramtype availability_state: str or ~azure.mgmt.dynatrace.models.AvailabilityState
        :keyword log_module: Tells whether log modules are enabled or not. Possible values include:
         "ENABLED", "DISABLED".
        :paramtype log_module: str or ~azure.mgmt.dynatrace.models.LogModule
        :keyword host_group: The name of the host group.
        :paramtype host_group: str
        :keyword host_name: The name of the host.
        :paramtype host_name: str
        """
        super(VMInfo, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.version = version
        self.monitoring_type = monitoring_type
        self.auto_update_setting = auto_update_setting
        self.update_status = update_status
        self.availability_state = availability_state
        self.log_module = log_module
        self.host_group = host_group
        self.host_name = host_name
