/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.http.sys;

import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Node;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.QueryException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.http.Params;
import org.apache.jena.sparql.exec.http.UpdateSendMode;
import org.apache.jena.sparql.syntax.syntaxtransform.UpdateTransformOps;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateException;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public abstract class ExecUpdateHTTPBuilder<X, Y> {
    protected String serviceURL;
    protected String updateString;
    private UpdateRequest updateOperations = null;
    protected Params params = Params.create();
    protected boolean allowCompression;
    protected Map<String, String> httpHeaders = new HashMap<String, String>();
    protected HttpClient httpClient;
    protected UpdateSendMode sendMode = UpdateSendMode.systemDefault;
    protected List<String> usingGraphURIs = null;
    protected List<String> usingNamedGraphURIs = null;
    protected Context context = null;
    protected Map<Var, Node> substitutionMap = new HashMap<Var, Node>();

    protected ExecUpdateHTTPBuilder() {
    }

    protected abstract Y thisBuilder();

    public Y endpoint(String serviceURL) {
        this.serviceURL = serviceURL;
        return this.thisBuilder();
    }

    public Y update(UpdateRequest updateRequest) {
        Objects.requireNonNull(updateRequest);
        this.ensureUpdateRequest();
        updateRequest.getOperations().forEach(this::update);
        this.updateString = null;
        return this.thisBuilder();
    }

    public Y update(String updateRequestString) {
        this.ensureUpdateRequest();
        UpdateRequest more = UpdateFactory.create(updateRequestString);
        more.getOperations().forEach(this::update);
        this.updateString = null;
        return this.thisBuilder();
    }

    public Y update(Update update) {
        Objects.requireNonNull(update);
        this.ensureUpdateRequest();
        this.updateOperations.add(update);
        this.updateString = null;
        return this.thisBuilder();
    }

    public Y updateString(String updateString) {
        Objects.requireNonNull(updateString);
        this.updateOperations = null;
        this.updateString = updateString;
        return this.thisBuilder();
    }

    public Y substitution(Binding binding) {
        binding.forEach(this.substitutionMap::put);
        return this.thisBuilder();
    }

    public Y substitution(String var, Node value) {
        return this.substitution(Var.alloc(var), value);
    }

    public Y substitution(Var var, Node value) {
        this.substitutionMap.put(var, value);
        return this.thisBuilder();
    }

    public Y httpClient(HttpClient httpClient) {
        this.httpClient = Objects.requireNonNull(httpClient);
        return this.thisBuilder();
    }

    public Y sendMode(UpdateSendMode mode) {
        this.sendMode = mode;
        return this.thisBuilder();
    }

    public Y addUsingGraphURI(String uri) {
        if (this.usingGraphURIs == null) {
            this.usingGraphURIs = new ArrayList<String>();
        }
        this.usingGraphURIs.add(uri);
        return this.thisBuilder();
    }

    public Y addUsingNamedGraphURI(String uri) {
        if (this.usingNamedGraphURIs == null) {
            this.usingNamedGraphURIs = new ArrayList<String>();
        }
        this.usingNamedGraphURIs.add(uri);
        return this.thisBuilder();
    }

    public Y param(String name) {
        Objects.requireNonNull(name);
        this.params.add(name);
        return this.thisBuilder();
    }

    public Y param(String name, String value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        this.params.add(name, value);
        return this.thisBuilder();
    }

    public Y httpHeader(String headerName, String headerValue) {
        Objects.requireNonNull(headerName);
        Objects.requireNonNull(headerValue);
        this.httpHeaders.put(headerName, headerValue);
        return this.thisBuilder();
    }

    public Y httpHeaders(Map<String, String> headers) {
        Objects.requireNonNull(headers);
        this.httpHeaders.putAll(headers);
        return this.thisBuilder();
    }

    public Y context(Context context2) {
        if (context2 == null) {
            return this.thisBuilder();
        }
        this.ensureContext();
        this.context.putAll(context2);
        return this.thisBuilder();
    }

    public Y set(Symbol symbol, Object value) {
        this.ensureContext();
        this.context.put(symbol, value);
        return this.thisBuilder();
    }

    public Y set(Symbol symbol, boolean value) {
        this.ensureContext();
        this.context.put(symbol, value);
        return this.thisBuilder();
    }

    private void ensureContext() {
        if (this.context == null) {
            this.context = new Context();
        }
    }

    private void ensureUpdateRequest() {
        if (this.updateOperations == null) {
            this.updateOperations = new UpdateRequest();
        }
    }

    public X build() {
        Objects.requireNonNull(this.serviceURL, "No service URL");
        if (this.updateOperations == null && this.updateString == null) {
            throw new QueryException("No update for UpdateExecutionHTTP");
        }
        if (this.updateOperations != null && this.updateString != null) {
            throw new InternalErrorException("UpdateRequest and update string");
        }
        HttpClient hClient = HttpEnv.getHttpClient(this.serviceURL, this.httpClient);
        UpdateRequest updateActual = this.updateOperations;
        if (this.substitutionMap != null && !this.substitutionMap.isEmpty()) {
            if (updateActual == null) {
                throw new UpdateException("Substitution only supported if an UpdateRequest object was provided");
            }
            updateActual = UpdateTransformOps.transform(updateActual, this.substitutionMap);
        }
        Context cxt = this.context != null ? this.context : ARQ.getContext().copy();
        return this.buildX(hClient, updateActual, cxt);
    }

    protected abstract X buildX(HttpClient var1, UpdateRequest var2, Context var3);

    static {
        JenaSystem.init();
    }
}

