/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.schema;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbmsTable {
    public static int total_opt;
    public static int MAX_DELTA_TO_FORCE_OPTIMIZE;
    private static final String[] TYPE_TABLE;
    private Logger logger = LoggerFactory.getLogger(RdbmsTable.class);
    private int addedCount;
    private Connection conn;
    private String name;
    private int removedCount;
    private long rowCount;
    private PreparedStatement clear;

    public RdbmsTable(String name) {
        this.name = name;
    }

    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    public void close() throws SQLException {
        if (this.clear != null) {
            this.clear.close();
        }
    }

    public long size() {
        assert (this.rowCount >= 0L) : this.rowCount;
        return this.rowCount;
    }

    public void clear() throws SQLException {
        if (this.clear == null) {
            this.clear = this.conn.prepareStatement(this.buildClear());
        }
        this.clear.execute();
        this.rowCount = 0L;
    }

    public void createTable(CharSequence columns) throws SQLException {
        this.execute(this.buildCreateTable(columns));
        this.rowCount = 0L;
    }

    public void createTransactionalTable(CharSequence columns) throws SQLException {
        this.execute(this.buildCreateTransactionalTable(columns));
        this.rowCount = 0L;
    }

    public void createTemporaryTable(CharSequence columns) throws SQLException {
        try {
            this.execute(this.buildCreateTemporaryTable(columns));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void execute(String command) throws SQLException {
        if (command != null) {
            Statement st = this.conn.createStatement();
            try {
                st.execute(command);
            }
            catch (SQLException e) {
                this.logger.warn(e.getMessage() + '\n' + command);
                throw e;
            }
            finally {
                st.close();
            }
        }
    }

    public int executeUpdate(String command, String ... parameters) throws SQLException {
        PreparedStatement st = this.conn.prepareStatement(command);
        try {
            int i;
            for (i = 0; i < parameters.length; ++i) {
                if (parameters[i] == null) {
                    st.setNull(i + 1, 12);
                    continue;
                }
                st.setString(i + 1, parameters[i]);
            }
            i = st.executeUpdate();
            return i;
        }
        catch (SQLException e) {
            this.logger.warn(e.getMessage() + '\n' + command);
            throw e;
        }
        finally {
            st.close();
        }
    }

    public String getCatalog() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return null;
    }

    public void primaryIndex(String ... columns) throws SQLException {
        this.execute(this.buildPrimaryIndex(columns));
    }

    public void index(String ... columns) throws SQLException {
        if (columns.length == 1 && columns[0].equalsIgnoreCase("value") && this.getName().toUpperCase().contains("LONG_")) {
            this.execute(this.buildLongIndex(columns));
        } else {
            this.execute(this.buildIndex(columns));
        }
    }

    public void dropIndex(String name) throws SQLException {
        this.execute(this.buildDropIndex(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCreated() throws SQLException {
        DatabaseMetaData metaData = this.conn.getMetaData();
        String c = this.getCatalog();
        String s = this.getSchema();
        String n = this.getName();
        ResultSet tables = metaData.getTables(c, s, n, TYPE_TABLE);
        try {
            boolean bl = tables.next();
            return bl;
        }
        finally {
            tables.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getIndexes() throws SQLException {
        DatabaseMetaData metaData = this.conn.getMetaData();
        String c = this.getCatalog();
        String s = this.getSchema();
        String n = this.getName();
        ResultSet indexes = metaData.getIndexInfo(c, s, n, false, false);
        try {
            HashMap<String, List<String>> names = new HashMap<String, List<String>>();
            while (indexes.next()) {
                String index = indexes.getString(6);
                String column = indexes.getString(9);
                ArrayList<String> columns = (ArrayList<String>)names.get(index);
                if (columns == null) {
                    columns = new ArrayList<String>();
                    names.put(index, columns);
                }
                columns.add(column);
            }
            HashMap<String, List<String>> hashMap = names;
            return hashMap;
        }
        finally {
            indexes.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count() throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT COUNT(*)\n");
        sb.append("FROM ").append(this.name);
        String query = sb.toString();
        Statement st = this.conn.createStatement();
        try {
            ResultSet rs;
            block9: {
                long l;
                rs = st.executeQuery(query);
                try {
                    if (!rs.next()) break block9;
                    this.rowCount = rs.getLong(1);
                    assert (this.rowCount >= 0L) : this.rowCount;
                    l = this.rowCount;
                }
                catch (Throwable throwable) {
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return l;
            }
            long l = 0L;
            rs.close();
            return l;
        }
        finally {
            st.close();
        }
    }

    public void modified(int inserted, int deleted) throws SQLException {
        if (inserted < 1 && deleted < 1) {
            return;
        }
        this.addedCount += inserted;
        this.removedCount += deleted;
        this.rowCount += (long)(inserted - deleted);
        assert (this.rowCount >= 0L) : this.rowCount;
    }

    public void optimize() throws SQLException {
        if (this.optimize(this.addedCount + this.removedCount, this.rowCount)) {
            this.execute(this.buildOptimize());
            this.removedCount = 0;
            this.addedCount = 0;
            ++total_opt;
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.conn.prepareStatement(sql);
    }

    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object[]> select(String ... columns) throws SQLException {
        StringBuilder sb = new StringBuilder();
        for (String column : columns) {
            if (sb.length() == 0) {
                sb.append("SELECT ");
            } else {
                sb.append(", ");
            }
            sb.append(column);
        }
        sb.append("\nFROM ").append(this.name);
        String query = sb.toString();
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        Statement st = this.conn.createStatement();
        try {
            ArrayList<Object[]> arrayList;
            ResultSet rs = st.executeQuery(query);
            try {
                int columnCount = rs.getMetaData().getColumnCount();
                while (rs.next()) {
                    Object[] row = new Object[columnCount];
                    for (int i = 0; i < row.length; ++i) {
                        row[i] = rs.getObject(i + 1);
                    }
                    result.add(row);
                }
                this.rowCount = result.size();
                assert (this.rowCount >= 0L) : this.rowCount;
                arrayList = result;
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return arrayList;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] aggregate(String ... expressions) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT COUNT(*)");
        for (String expression : expressions) {
            sb.append(", ").append(expression);
        }
        sb.append("\nFROM ").append(this.name);
        String query = sb.toString();
        Statement st = this.conn.createStatement();
        try {
            int[] nArray;
            ResultSet rs = st.executeQuery(query);
            try {
                if (!rs.next()) {
                    throw new AssertionError();
                }
                int columnCount = rs.getMetaData().getColumnCount();
                int[] result = new int[columnCount - 1];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = rs.getInt(i + 2);
                }
                this.rowCount = rs.getLong(1);
                assert (this.rowCount >= 0L) : this.rowCount;
                nArray = result;
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return nArray;
        }
        finally {
            st.close();
        }
    }

    protected boolean optimize(int delta, long rowCount) {
        if (delta > MAX_DELTA_TO_FORCE_OPTIMIZE) {
            return true;
        }
        return delta != 0 && rowCount / (long)delta <= 2L;
    }

    protected String buildClear() {
        return "DELETE FROM " + this.name;
    }

    protected String buildCreateTable(CharSequence columns) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(this.name);
        sb.append(" (\n").append(columns).append(")");
        return sb.toString();
    }

    protected String buildCreateTransactionalTable(CharSequence columns) {
        return this.buildCreateTable(columns);
    }

    protected String buildCreateTemporaryTable(CharSequence columns) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TEMPORARY TABLE ").append(this.name);
        sb.append(" (\n").append(columns).append(")");
        return sb.toString();
    }

    protected String buildPrimaryIndex(String ... columns) {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ");
        sb.append(this.getName());
        sb.append(" ADD PRIMARY KEY (");
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(columns[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    protected String buildIndex(String ... columns) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE INDEX ").append(this.buildIndexName(columns));
        sb.append(" ON ").append(this.name).append(" (");
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(columns[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    protected String buildLongIndex(String ... columns) {
        return this.buildIndex(columns);
    }

    protected String buildDropIndex(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("DROP INDEX ").append(name);
        return sb.toString();
    }

    protected String buildIndexName(String ... columns) {
        StringBuffer sb = new StringBuffer(32);
        sb.append(this.getName()).append("_").append(columns[0]);
        for (int i = 1; i < columns.length; ++i) {
            sb.append("_").append(columns[i]);
        }
        sb.append("_idx");
        return sb.toString();
    }

    protected String buildOptimize() throws SQLException {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdbmsTable)) {
            return false;
        }
        RdbmsTable other = (RdbmsTable)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public void drop() throws SQLException {
        this.execute("DROP TABLE " + this.name);
    }

    public String toString() {
        return this.getName();
    }

    static {
        MAX_DELTA_TO_FORCE_OPTIMIZE = 10000;
        TYPE_TABLE = new String[]{"TABLE"};
    }
}

