/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.schema;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.openrdf.sail.rdbms.schema.HashBatch;
import org.openrdf.sail.rdbms.schema.ValueTable;

public class HashTable {
    private static final int CHUNK_SIZE = 15;
    private ValueTable table;
    private PreparedStatement select;
    private int removedStatementsSinceExpunge;

    public HashTable(ValueTable table) {
        this.table = table;
    }

    public String getName() {
        return this.table.getName();
    }

    public int getBatchSize() {
        return this.table.getBatchSize();
    }

    public int getSelectChunkSize() {
        return 15;
    }

    public void init() throws SQLException {
    }

    public void close() throws SQLException {
        if (this.select != null) {
            this.select.close();
        }
        this.table.close();
    }

    public List<Long> maxIds(int shift, int mod) throws SQLException {
        return this.table.maxIds(shift, mod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Number id, long hash) throws SQLException, InterruptedException {
        ValueTable valueTable = this.table;
        synchronized (valueTable) {
            HashBatch batch = (HashBatch)this.table.getValueBatch();
            if (this.table.isExpired(batch)) {
                batch = this.newHashBatch();
                this.table.initBatch(batch);
            }
            batch.addBatch(id, hash);
            this.table.queue(batch);
        }
    }

    public boolean expungeRemovedStatements(int count, String condition) throws SQLException {
        this.removedStatementsSinceExpunge += count;
        if (condition != null && this.timeToExpunge()) {
            boolean removed = this.table.expunge(condition);
            this.removedStatementsSinceExpunge = 0;
            return removed;
        }
        return false;
    }

    protected boolean timeToExpunge() {
        return (long)this.removedStatementsSinceExpunge > this.table.size() / 4L;
    }

    public void optimize() throws SQLException {
        this.table.optimize();
    }

    public String toString() {
        return this.table.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Number> load(Map<Long, Number> hashes) throws SQLException {
        assert (!hashes.isEmpty());
        assert (hashes.size() <= this.getSelectChunkSize());
        if (this.select == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT id, value\nFROM ").append(this.getName());
            sb.append("\nWHERE value IN (");
            int n = this.getSelectChunkSize();
            for (int i = 0; i < n; ++i) {
                sb.append("?,");
            }
            sb.setCharAt(sb.length() - 1, ')');
            this.select = this.prepareSelect(sb.toString());
        }
        int p = 0;
        for (Long hash : hashes.keySet()) {
            this.select.setLong(++p, hash);
        }
        while (p < this.getSelectChunkSize()) {
            this.select.setNull(++p, -5);
        }
        ResultSet rs = this.select.executeQuery();
        try {
            while (rs.next()) {
                long id = rs.getLong(1);
                long hash = rs.getLong(2);
                hashes.put(hash, id);
            }
        }
        finally {
            rs.close();
        }
        return hashes;
    }

    protected HashBatch newHashBatch() {
        return new HashBatch();
    }

    protected PreparedStatement prepareSelect(String sql) throws SQLException {
        return this.table.getRdbmsTable().prepareStatement(sql);
    }
}

