/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.managers;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openrdf.model.Namespace;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.sail.rdbms.exceptions.RdbmsException;
import org.openrdf.sail.rdbms.schema.NamespacesTable;

public class NamespaceManager {
    private Map<String, NamespaceImpl> byNamespace = new ConcurrentHashMap<String, NamespaceImpl>();
    private Map<String, NamespaceImpl> byPrefix = new ConcurrentHashMap<String, NamespaceImpl>();
    private Connection conn;
    private NamespacesTable table;

    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    public void setNamespacesTable(NamespacesTable table) {
        this.table = table;
    }

    public void close() throws RdbmsException {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            throw new RdbmsException(e);
        }
    }

    public void initialize() throws RdbmsException {
        try {
            this.load();
        }
        catch (SQLException e) {
            throw new RdbmsException(e);
        }
    }

    public NamespaceImpl findNamespace(String namespace) throws RdbmsException {
        if (namespace == null) {
            return null;
        }
        if (this.byNamespace.containsKey(namespace)) {
            return this.byNamespace.get(namespace);
        }
        try {
            return this.create(namespace);
        }
        catch (SQLException e) {
            throw new RdbmsException(e);
        }
    }

    private void load() throws SQLException {
        HashMap<String, NamespaceImpl> map = new HashMap<String, NamespaceImpl>();
        HashMap<String, NamespaceImpl> prefixes = new HashMap<String, NamespaceImpl>();
        for (Object[] row : this.table.selectAll()) {
            String prefix = (String)row[0];
            String namespace = (String)row[1];
            if (namespace == null) continue;
            NamespaceImpl ns = new NamespaceImpl(prefix, namespace);
            map.put(namespace, ns);
            if (prefix == null) continue;
            prefixes.put(prefix, ns);
        }
        this.byNamespace.putAll(map);
        this.byPrefix.clear();
        this.byPrefix.putAll(prefixes);
    }

    private synchronized NamespaceImpl create(String namespace) throws SQLException {
        if (this.byNamespace.containsKey(namespace)) {
            return this.byNamespace.get(namespace);
        }
        this.table.insert(null, namespace);
        NamespaceImpl ns = new NamespaceImpl(null, namespace);
        this.byNamespace.put(ns.getName(), ns);
        return ns;
    }

    public void setPrefix(String prefix, String name) throws RdbmsException {
        NamespaceImpl ns = this.findNamespace(name);
        try {
            this.table.updatePrefix(prefix, name);
        }
        catch (SQLException e) {
            throw new RdbmsException(e);
        }
        ns.setPrefix(prefix);
        this.byPrefix.put(prefix, ns);
    }

    public NamespaceImpl findByPrefix(String prefix) {
        return this.byPrefix.get(prefix);
    }

    public void removePrefix(String prefix) throws RdbmsException {
        NamespaceImpl ns = this.findByPrefix(prefix);
        if (ns == null) {
            return;
        }
        try {
            this.table.updatePrefix(prefix, ns.getName());
        }
        catch (SQLException e) {
            throw new RdbmsException(e);
        }
        ns.setPrefix(null);
        this.byPrefix.remove(prefix);
    }

    public Collection<? extends Namespace> getNamespacesWithPrefix() throws RdbmsException {
        return this.byPrefix.values();
    }

    public void clearPrefixes() throws RdbmsException {
        try {
            this.table.clearPrefixes();
            this.load();
        }
        catch (SQLException e) {
            throw new RdbmsException(e);
        }
    }
}

