/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.evaluation;

import java.util.ArrayList;
import java.util.List;
import org.openrdf.sail.rdbms.evaluation.QueryBuilderFactory;
import org.openrdf.sail.rdbms.evaluation.SqlExprBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlQueryBuilder;

public class SqlJoinBuilder {
    private boolean left;
    private SqlQueryBuilder subquery;
    private String table;
    private String alias;
    private QueryBuilderFactory factory;
    private List<SqlJoinBuilder> joins = new ArrayList<SqlJoinBuilder>();
    private SqlExprBuilder on;
    private List<SqlJoinBuilder> leftJoins = new ArrayList<SqlJoinBuilder>();

    public SqlJoinBuilder(String table, String alias, QueryBuilderFactory factory) {
        this.table = table;
        this.alias = alias;
        this.factory = factory;
        this.on = factory.createSqlExprBuilder();
    }

    public boolean isLeft() {
        return this.left;
    }

    public void setLeft(boolean left) {
        this.left = left;
    }

    public String getTable() {
        if (this.subquery == null) {
            return this.table;
        }
        return "( " + this.subquery.toString() + " )";
    }

    public String getAlias() {
        return this.alias;
    }

    public List<SqlJoinBuilder> getLeftJoins() {
        return this.leftJoins;
    }

    public SqlJoinBuilder on(String column, String expression) {
        this.on.and().column(this.alias, column).eq().append(expression);
        return this;
    }

    public SqlJoinBuilder findJoin(String alias) {
        SqlJoinBuilder result;
        if (alias.equals(this.alias)) {
            return this;
        }
        for (SqlJoinBuilder join : this.joins) {
            result = join.findJoin(alias);
            if (result == null) continue;
            return result;
        }
        for (SqlJoinBuilder join : this.leftJoins) {
            result = join.findJoin(alias);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public SqlJoinBuilder join(String table, String alias) {
        SqlJoinBuilder join = this.findJoin(alias);
        if (join != null) {
            return join;
        }
        join = this.factory.createSqlJoinBuilder(table, alias);
        this.joins.add(join);
        return join;
    }

    public SqlJoinBuilder leftjoin(String table, String alias) {
        SqlJoinBuilder join = this.findJoin(alias);
        if (join != null) {
            return join;
        }
        join = this.factory.createSqlJoinBuilder(table, alias);
        join.setLeft(true);
        this.leftJoins.add(join);
        return join;
    }

    public SqlJoinBuilder join(String alias) {
        SqlJoinBuilder join = this.findJoin(alias);
        if (join != null) {
            return join;
        }
        join = this.factory.createSqlJoinBuilder(null, alias);
        this.joins.add(join);
        return join;
    }

    public SqlJoinBuilder leftjoin(String alias) {
        SqlJoinBuilder join = this.findJoin(alias);
        if (join != null) {
            return join;
        }
        join = this.factory.createSqlJoinBuilder(null, alias);
        join.setLeft(true);
        this.leftJoins.add(join);
        return join;
    }

    public SqlQueryBuilder subquery() {
        assert (this.table == null) : this.table;
        assert (this.subquery == null) : this.subquery;
        this.subquery = this.factory.createSqlQueryBuilder();
        return this.subquery;
    }

    public SqlExprBuilder on() {
        return this.on;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isLeft()) {
            sb.append("LEFT ");
        }
        sb.append("JOIN ").append(this.getJoinClause());
        sb.append(" ON (").append(this.on()).append(")");
        return sb.toString();
    }

    public CharSequence getFromClause() {
        if (this.joins.isEmpty() && this.leftJoins.isEmpty()) {
            return this.getTable() + " " + this.alias;
        }
        StringBuilder from = new StringBuilder();
        from.append(this.getTable()).append(" ").append(this.alias);
        for (SqlJoinBuilder join : this.joins) {
            this.appendJoin(from, join);
        }
        for (SqlJoinBuilder left : this.getLeftJoins()) {
            from.append("\n LEFT JOIN ").append(left.getJoinClause());
            from.append(" ON (").append(left.on()).append(")");
        }
        return from;
    }

    protected CharSequence getJoinClause() {
        if (this.joins.isEmpty() && this.leftJoins.isEmpty()) {
            return this.getTable() + " " + this.alias;
        }
        StringBuilder from = new StringBuilder();
        from.append("(");
        from.append(this.getFromClause());
        from.append(")");
        return from;
    }

    protected void appendJoin(StringBuilder from, SqlJoinBuilder join) {
        if (join.isLeft()) {
            from.append("\n LEFT JOIN ").append(join.getJoinClause());
        } else if (join.on().isEmpty()) {
            from.append(this.getSqlCrossJoin()).append(join.getJoinClause());
        } else {
            from.append("\n INNER JOIN ").append(join.getJoinClause());
        }
        if (!join.on().isEmpty()) {
            from.append(" ON (").append(join.on()).append(")");
        } else if (join.isLeft()) {
            from.append(" ON (").append(this.alias).append(".ctx = ").append(this.alias).append(".ctx)");
        }
    }

    protected String getSqlCrossJoin() {
        return "\n CROSS JOIN ";
    }

    public List<Object> findParameters(List<Object> parameters) {
        if (this.subquery != null) {
            this.subquery.findParameters(parameters);
        }
        for (SqlJoinBuilder join : this.joins) {
            join.findParameters(parameters);
        }
        for (SqlJoinBuilder join : this.leftJoins) {
            join.findParameters(parameters);
        }
        parameters.addAll(this.on.getParameters());
        return parameters;
    }
}

