/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.evaluation;

import java.util.ArrayList;
import java.util.List;
import org.openrdf.query.algebra.MathExpr;
import org.openrdf.sail.rdbms.algebra.SqlCompare;
import org.openrdf.sail.rdbms.evaluation.QueryBuilderFactory;
import org.openrdf.sail.rdbms.evaluation.SqlBracketBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlCaseBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlCastBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlRegexBuilder;

public class SqlExprBuilder {
    private static final String NULL = " NULL ";
    private QueryBuilderFactory factory;
    private List<Object> parameters = new ArrayList<Object>();
    private StringBuilder where = new StringBuilder();

    public SqlExprBuilder(QueryBuilderFactory factory) {
        this.factory = factory;
    }

    public SqlBracketBuilder abs() {
        this.where.append(" ABS");
        return this.open();
    }

    public SqlExprBuilder and() {
        if (!this.isEmpty()) {
            this.where.append("\n AND ");
        }
        return this;
    }

    public SqlExprBuilder append(CharSequence sql) {
        this.where.append(sql);
        return this;
    }

    public void appendBoolean(boolean booleanValue) {
        if (booleanValue) {
            this.where.append(" 1=1 ");
        } else {
            this.where.append(" 0=1 ");
        }
    }

    public SqlExprBuilder appendNull() {
        this.where.append(this.getSqlNull());
        return this;
    }

    public SqlExprBuilder appendNumeric(Number doubleValue) {
        this.where.append(" ? ");
        this.parameters.add(doubleValue);
        return this;
    }

    public void appendOperator(SqlCompare.Operator op) {
        switch (op) {
            case GE: {
                this.where.append(" >= ");
                break;
            }
            case GT: {
                this.where.append(" > ");
                break;
            }
            case LE: {
                this.where.append(" <= ");
                break;
            }
            case LT: {
                this.where.append(" < ");
            }
        }
    }

    public void as(String column) {
        this.where.append(" AS ").append(column);
    }

    public SqlExprBuilder number(Number time) {
        this.where.append(" ? ");
        this.parameters.add(time);
        return this;
    }

    public SqlCaseBuilder caseBegin() {
        return new SqlCaseBuilder(this);
    }

    public SqlCastBuilder cast(int jdbcType) {
        return this.factory.createSqlCastBuilder(this, jdbcType);
    }

    public SqlExprBuilder column(String alias, String column) {
        this.where.append(alias).append(".").append(column);
        return this;
    }

    public SqlExprBuilder columnEquals(String alias, String column, Number id) {
        return this.column(alias, column).eq().number(id);
    }

    public SqlExprBuilder columnEquals(String alias, String column, String label) {
        return this.column(alias, column).eq().varchar(label);
    }

    public SqlExprBuilder columnIn(String alias, String column, Number[] ids) {
        if (ids.length == 1) {
            return this.columnEquals(alias, column, ids[0]);
        }
        SqlBracketBuilder open = this.open();
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                open.or();
            }
            open.column(alias, column);
            open.eq();
            open.number(ids[i]);
        }
        open.close();
        return this;
    }

    public SqlExprBuilder columnsEqual(String al1, String col1, String al2, String col2) {
        return this.column(al1, col1).eq().column(al2, col2);
    }

    public void concat() {
        this.append(" || ");
    }

    public SqlExprBuilder eq() {
        this.where.append(" = ");
        return this;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public boolean isEmpty() {
        return this.where.length() == 0;
    }

    public SqlExprBuilder isNotNull() {
        this.where.append(" IS NOT NULL ");
        return this;
    }

    public SqlExprBuilder isNull() {
        this.where.append(" IS NULL ");
        return this;
    }

    public void like() {
        this.where.append(" LIKE ");
    }

    public SqlBracketBuilder lowerCase() {
        this.where.append(" lower");
        return this.open();
    }

    public void math(MathExpr.MathOp op) {
        this.append(" ").append(op.getSymbol()).append(" ");
    }

    public SqlBracketBuilder mod(int value) {
        this.where.append(" MOD");
        SqlBracketBuilder open = this.open();
        open.setClosing("," + value + open.getClosing());
        return open;
    }

    public SqlBracketBuilder not() {
        this.where.append(" NOT");
        return this.open();
    }

    public SqlExprBuilder notEqual() {
        this.where.append(" <> ");
        return this;
    }

    public SqlBracketBuilder open() {
        return this.factory.createSqlBracketBuilder(this);
    }

    public SqlExprBuilder or() {
        this.append(" OR ");
        return this;
    }

    public void plus(int range) {
        this.where.append(" + " + range);
    }

    public SqlRegexBuilder regex() {
        return this.factory.createSqlRegexBuilder(this);
    }

    public void rightShift(int rightShift) {
        this.where.append(" >> " + rightShift);
    }

    public CharSequence toSql() {
        return this.where;
    }

    public String toString() {
        return this.where.toString();
    }

    public SqlExprBuilder varchar(String stringValue) {
        if (stringValue == null) {
            this.appendNull();
        } else {
            this.where.append(" ? ");
            this.parameters.add(stringValue);
        }
        return this;
    }

    protected void addParameters(List<Object> params) {
        this.parameters.addAll(params);
    }

    protected String getSqlNull() {
        return NULL;
    }

    protected Mark mark() {
        return new Mark(this.where.length(), this.parameters.size());
    }

    protected void reset(Mark mark) {
        this.where.delete(mark.length, this.where.length());
        for (int i = this.parameters.size() - 1; i >= mark.size; --i) {
            this.parameters.remove(i);
        }
    }

    protected class Mark {
        int length;
        int size;

        Mark(int length, int size) {
            this.length = length;
            this.size = size;
        }
    }
}

