/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.config;

import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.sail.config.SailConfigException;
import org.openrdf.sail.config.SailImplConfigBase;
import org.openrdf.sail.rdbms.config.RdbmsStoreSchema;

public class RdbmsStoreConfig
extends SailImplConfigBase {
    private String jdbcDriver;
    private String url;
    private String user;
    private String password;
    private int maxTripleTables = 256;

    public RdbmsStoreConfig() {
        super("openrdf:RdbmsStore");
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getMaxTripleTables() {
        return this.maxTripleTables;
    }

    public void setMaxTripleTables(int maxTripleTables) {
        this.maxTripleTables = maxTripleTables;
    }

    public void validate() throws SailConfigException {
        super.validate();
        if (this.url == null) {
            throw new SailConfigException("No URL specified for RdbmsStore");
        }
    }

    public Resource export(Graph graph) {
        Resource implNode = super.export(graph);
        ValueFactory vf = graph.getValueFactory();
        if (this.jdbcDriver != null) {
            graph.add(implNode, RdbmsStoreSchema.JDBC_DRIVER, (Value)vf.createLiteral(this.jdbcDriver), new Resource[0]);
        }
        if (this.url != null) {
            graph.add(implNode, RdbmsStoreSchema.URL, (Value)vf.createLiteral(this.url), new Resource[0]);
        }
        if (this.user != null) {
            graph.add(implNode, RdbmsStoreSchema.USER, (Value)vf.createLiteral(this.user), new Resource[0]);
        }
        if (this.password != null) {
            graph.add(implNode, RdbmsStoreSchema.PASSWORD, (Value)vf.createLiteral(this.password), new Resource[0]);
        }
        graph.add(implNode, RdbmsStoreSchema.MAX_TRIPLE_TABLES, (Value)vf.createLiteral(this.maxTripleTables), new Resource[0]);
        return implNode;
    }

    public void parse(Graph graph, Resource implNode) throws SailConfigException {
        block8: {
            super.parse(graph, implNode);
            try {
                Literal maxTripleTablesLit;
                Literal passwordLit;
                Literal userLit;
                Literal urlLit;
                Literal jdbcDriverLit = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)RdbmsStoreSchema.JDBC_DRIVER);
                if (jdbcDriverLit != null) {
                    this.setJdbcDriver(jdbcDriverLit.getLabel());
                }
                if ((urlLit = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)RdbmsStoreSchema.URL)) != null) {
                    this.setUrl(urlLit.getLabel());
                }
                if ((userLit = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)RdbmsStoreSchema.USER)) != null) {
                    this.setUser(userLit.getLabel());
                }
                if ((passwordLit = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)RdbmsStoreSchema.PASSWORD)) != null) {
                    this.setPassword(passwordLit.getLabel());
                }
                if ((maxTripleTablesLit = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)RdbmsStoreSchema.MAX_TRIPLE_TABLES)) == null) break block8;
                try {
                    this.setMaxTripleTables(maxTripleTablesLit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Invalid value for maxTripleTables: " + maxTripleTablesLit);
                }
            }
            catch (GraphUtilException e) {
                throw new SailConfigException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

