/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store.tupletable;

import java.util.Iterator;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleMap;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.tupletable.TupleIndex;

public abstract class TupleIndexBase
implements TupleIndex {
    private static final boolean Check = false;
    protected final TupleMap tupleMap;
    protected final int tupleLength;
    private final String name;

    protected TupleIndexBase(int N, TupleMap indexMapping, String name) {
        this.tupleLength = N;
        this.tupleMap = indexMapping;
        this.name = name;
    }

    @Override
    public TupleIndex wrapped() {
        return null;
    }

    protected abstract void performAdd(Tuple<NodeId> var1);

    protected abstract void performDelete(Tuple<NodeId> var1);

    protected abstract Iterator<Tuple<NodeId>> performFind(Tuple<NodeId> var1);

    @Override
    public final void add(Tuple<NodeId> tuple) {
        this.performAdd(tuple);
    }

    @Override
    public final void delete(Tuple<NodeId> tuple) {
        this.performDelete(tuple);
    }

    @Override
    public final Iterator<Tuple<NodeId>> find(Tuple<NodeId> pattern) {
        return this.performFind(pattern);
    }

    @Override
    public final int weight(Tuple<NodeId> pattern) {
        for (int i = 0; i < this.tupleLength; ++i) {
            NodeId X = (NodeId)this.tupleMap.mapSlot(i, pattern);
            if (!this.undef(X)) continue;
            return i;
        }
        return this.tupleLength;
    }

    @Override
    public final String getMappingStr() {
        return this.tupleMap.getLabel();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final int getTupleLength() {
        return this.tupleLength;
    }

    @Override
    public final TupleMap getMapping() {
        return this.tupleMap;
    }

    protected final boolean undef(NodeId x) {
        return NodeId.isAny(x);
    }

    public String toString() {
        return "index:" + this.getName();
    }
}

