/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.ri;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import org.semarglproject.ri.MalformedIriException;

public final class RIUtils {
    private static final Pattern ABS_OPAQUE_IRI_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9+.-]*:[^#/][^#]*", 32);
    private static final Pattern ABS_HIER_IRI_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9+.-]*:/{1,3}(([^/?#@]*)@)?(\\[[^@/?#]+\\]|([^@/?#:]+))(:([^/?#]*))?([^#?]*)?(\\?([^#]*))?(#[^#]*)?", 32);
    private static final Pattern URN_PATTERN = Pattern.compile("urn:[a-zA-Z0-9][a-zA-Z0-9-]{1,31}:.+");

    private RIUtils() {
    }

    public static String resolveIri(String base, String iri) throws MalformedIriException {
        String result;
        if (iri == null) {
            return null;
        }
        if (RIUtils.isIri(iri) || RIUtils.isUrn(iri)) {
            return iri;
        }
        if (iri.startsWith("?") || iri.isEmpty()) {
            if (base.endsWith("#")) {
                return base.substring(0, base.length() - 1) + iri;
            }
            return base + iri;
        }
        try {
            URL basePart = new URL(base);
            result = new URL(basePart, iri).toString();
        }
        catch (MalformedURLException e) {
            result = base + iri;
        }
        if (RIUtils.isIri(result)) {
            return result;
        }
        throw new MalformedIriException("Malformed IRI: " + iri);
    }

    public static boolean isIri(String value) {
        return ABS_HIER_IRI_PATTERN.matcher(value).matches() || ABS_OPAQUE_IRI_PATTERN.matcher(value).matches();
    }

    public static boolean isAbsoluteIri(String value) {
        return ABS_HIER_IRI_PATTERN.matcher(value).matches();
    }

    public static boolean isUrn(String value) {
        return URN_PATTERN.matcher(value).matches();
    }
}

