/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.proxy;

import java.util.Enumeration;
import junit.extensions.proxy.IProxyTest;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;

public class ProxyTestSuite
extends TestSuite {
    protected static final Logger log = Logger.getLogger(ProxyTestSuite.class);
    private final Test m_delegate;

    private final void checkDelegate(Test delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("The delegate is null.");
        }
        log.debug((Object)("Delegate is " + delegate.getClass().getName()));
    }

    public Test getDelegate() {
        return this.m_delegate;
    }

    public ProxyTestSuite(Test delegate) {
        this.checkDelegate(delegate);
        this.m_delegate = delegate;
    }

    public ProxyTestSuite(Test delegate, Class testClass, String name) {
        super(testClass, name);
        this.checkDelegate(delegate);
        this.m_delegate = delegate;
        this.flowDown(this);
    }

    public ProxyTestSuite(Test delegate, Class testClass) {
        super(testClass);
        this.checkDelegate(delegate);
        this.m_delegate = delegate;
        this.flowDown(this);
    }

    public ProxyTestSuite(Test delegate, String name) {
        super(name);
        this.checkDelegate(delegate);
        this.m_delegate = delegate;
    }

    public void addTestSuite(Class testClass) {
        if (this.m_delegate == null) {
            super.addTestSuite(testClass);
            return;
        }
        ProxyTestSuite proxyTestSuite = new ProxyTestSuite(this.m_delegate, testClass);
        this.addTest((Test)proxyTestSuite);
    }

    public void addTest(Test test) {
        if (this.m_delegate == null) {
            super.addTest(test);
            return;
        }
        if (!(test instanceof ProxyTestSuite)) {
            this.flowDown(test);
        }
        super.addTest(test);
    }

    protected void flowDown(Test t) {
        if (this.m_delegate == null) {
            throw new AssertionError((Object)"delegate is not set.");
        }
        if (t instanceof TestSuite) {
            this.flowDown((TestSuite)t);
        } else if (t instanceof IProxyTest) {
            log.debug((Object)("Setting delegate on " + t.getClass() + " to " + this.m_delegate.getClass()));
            ((IProxyTest)t).setDelegate(this.m_delegate);
        }
    }

    protected void flowDown(TestSuite suite) {
        if (this.m_delegate == null) {
            throw new AssertionError((Object)"delegate is not set.");
        }
        Enumeration e = suite.tests();
        while (e.hasMoreElements()) {
            Test t = (Test)e.nextElement();
            this.flowDown(t);
        }
    }
}

