/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.federation.optimizers;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public class EmptyPatternOptimizer
extends QueryModelVisitorBase<RepositoryException>
implements QueryOptimizer {
    private final Collection<? extends RepositoryConnection> members;

    public EmptyPatternOptimizer(Collection<? extends RepositoryConnection> members) {
        this.members = members;
    }

    public void optimize(TupleExpr query, Dataset dataset, BindingSet bindings) {
        try {
            query.visit((QueryModelVisitor)this);
        }
        catch (RepositoryException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public void meet(StatementPattern node) throws RepositoryException {
        Resource subj = (Resource)node.getSubjectVar().getValue();
        URI pred = (URI)node.getPredicateVar().getValue();
        Value obj = node.getObjectVar().getValue();
        Resource[] ctx = this.getContexts(node.getContextVar());
        for (RepositoryConnection repositoryConnection : this.members) {
            if (!repositoryConnection.hasStatement(subj, pred, obj, true, ctx)) continue;
            return;
        }
        node.replaceWith((QueryModelNode)new EmptySet());
    }

    private Resource[] getContexts(Var var) {
        Resource[] resourceArray;
        if (var == null || !var.hasValue()) {
            resourceArray = new Resource[]{};
        } else {
            Resource[] resourceArray2 = new Resource[1];
            resourceArray = resourceArray2;
            resourceArray2[0] = (Resource)var.getValue();
        }
        return resourceArray;
    }
}

