/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.nquads;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.NTriplesWriterSettings;
import org.eclipse.rdf4j.rio.ntriples.NTriplesUtil;
import org.eclipse.rdf4j.rio.ntriples.NTriplesWriter;

public class NQuadsWriter
extends NTriplesWriter {
    public NQuadsWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public NQuadsWriter(Writer writer) {
        super(writer);
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.NQUADS;
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        try {
            NTriplesUtil.append((Resource)st.getSubject(), (Appendable)this.writer);
            this.writer.write(" ");
            NTriplesUtil.append((IRI)st.getPredicate(), (Appendable)this.writer);
            this.writer.write(" ");
            NTriplesUtil.append((Value)st.getObject(), (Appendable)this.writer, (boolean)((Boolean)this.getWriterConfig().get(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL)), (boolean)((Boolean)this.getWriterConfig().get(NTriplesWriterSettings.ESCAPE_UNICODE)));
            if (null != st.getContext()) {
                this.writer.write(" ");
                NTriplesUtil.append((Resource)st.getContext(), (Appendable)this.writer);
            }
            this.writer.write(" .\n");
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }
}

