/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.runtime;

import java.net.MalformedURLException;
import java.util.Collection;
import org.openrdf.OpenRDFException;
import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.config.RepositoryConfig;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryConfigSchema;
import org.openrdf.repository.http.config.HTTPRepositoryConfig;
import org.openrdf.repository.http.config.HTTPRepositorySchema;
import org.openrdf.repository.manager.RepositoryManager;
import org.openrdf.repository.sail.config.ProxyRepositorySchema;
import org.openrdf.repository.sail.config.SailRepositorySchema;
import org.openrdf.repository.sparql.config.SPARQLRepositoryConfig;
import org.openrdf.sail.config.SailConfigSchema;
import org.openrdf.sail.federation.config.FederationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryManagerFederator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryManagerFederator.class);
    private final RepositoryManager manager;
    private final ValueFactory valueFactory;

    public RepositoryManagerFederator(RepositoryManager manager) {
        this.manager = manager;
        this.valueFactory = manager.getSystemRepository().getValueFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFed(String fedID, String description, Collection<String> members, boolean readonly, boolean distinct) throws MalformedURLException, OpenRDFException {
        if (members.contains(fedID)) {
            throw new RepositoryConfigException("A federation member may not have the same ID as the federation.");
        }
        LinkedHashModel graph = new LinkedHashModel();
        BNode fedRepoNode = this.valueFactory.createBNode();
        LOGGER.debug("Federation repository root node: {}", (Object)fedRepoNode);
        RepositoryManagerFederator.addToGraph((Graph)graph, (Resource)fedRepoNode, RDF.TYPE, (Value)RepositoryConfigSchema.REPOSITORY);
        RepositoryManagerFederator.addToGraph((Graph)graph, (Resource)fedRepoNode, RepositoryConfigSchema.REPOSITORYID, (Value)this.valueFactory.createLiteral(fedID));
        RepositoryManagerFederator.addToGraph((Graph)graph, (Resource)fedRepoNode, RDFS.LABEL, (Value)this.valueFactory.createLiteral(description));
        RepositoryConnection con = this.manager.getSystemRepository().getConnection();
        try {
            this.addImplementation(members, (Graph)graph, fedRepoNode, con, readonly, distinct);
        }
        finally {
            con.close();
        }
        RepositoryConfig fedConfig = RepositoryConfig.create((Graph)graph, (Resource)fedRepoNode);
        fedConfig.validate();
        this.manager.addRepositoryConfig(fedConfig);
    }

    private void addImplementation(Collection<String> members, Graph graph, BNode fedRepoNode, RepositoryConnection con, boolean readonly, boolean distinct) throws OpenRDFException, MalformedURLException {
        BNode implRoot = this.valueFactory.createBNode();
        RepositoryManagerFederator.addToGraph(graph, (Resource)fedRepoNode, RepositoryConfigSchema.REPOSITORYIMPL, (Value)implRoot);
        RepositoryManagerFederator.addToGraph(graph, (Resource)implRoot, RepositoryConfigSchema.REPOSITORYTYPE, (Value)this.valueFactory.createLiteral("openrdf:SailRepository"));
        this.addSail(members, graph, implRoot, con, readonly, distinct);
    }

    private void addSail(Collection<String> members, Graph graph, BNode implRoot, RepositoryConnection con, boolean readonly, boolean distinct) throws OpenRDFException, MalformedURLException {
        BNode sailRoot = this.valueFactory.createBNode();
        RepositoryManagerFederator.addToGraph(graph, (Resource)implRoot, SailRepositorySchema.SAILIMPL, (Value)sailRoot);
        RepositoryManagerFederator.addToGraph(graph, (Resource)sailRoot, SailConfigSchema.SAILTYPE, (Value)this.valueFactory.createLiteral("openrdf:Federation"));
        RepositoryManagerFederator.addToGraph(graph, (Resource)sailRoot, FederationConfig.READ_ONLY, (Value)this.valueFactory.createLiteral(readonly));
        RepositoryManagerFederator.addToGraph(graph, (Resource)sailRoot, FederationConfig.DISTINCT, (Value)this.valueFactory.createLiteral(distinct));
        for (String member : members) {
            this.addMember(graph, sailRoot, member, con);
        }
    }

    private void addMember(Graph graph, BNode sailRoot, String identifier, RepositoryConnection con) throws OpenRDFException, MalformedURLException {
        LOGGER.debug("Adding member: {}", (Object)identifier);
        BNode memberNode = this.valueFactory.createBNode();
        RepositoryManagerFederator.addToGraph(graph, (Resource)sailRoot, FederationConfig.MEMBER, (Value)memberNode);
        String memberRepoType = this.manager.getRepositoryConfig(identifier).getRepositoryImplConfig().getType();
        if (!"openrdf:SPARQLRepository".equals(memberRepoType) && !"openrdf:HTTPRepository".equals(memberRepoType)) {
            memberRepoType = "openrdf:ProxyRepository";
        }
        RepositoryManagerFederator.addToGraph(graph, (Resource)memberNode, RepositoryConfigSchema.REPOSITORYTYPE, (Value)this.valueFactory.createLiteral(memberRepoType));
        RepositoryManagerFederator.addToGraph(graph, (Resource)memberNode, this.getLocationPredicate(memberRepoType), this.getMemberLocator(identifier, con, memberRepoType));
        LOGGER.debug("Added member {}: ", (Object)identifier);
    }

    private URI getLocationPredicate(String memberRepoType) {
        URI predicate = "openrdf:SPARQLRepository".equals(memberRepoType) ? SPARQLRepositoryConfig.QUERY_ENDPOINT : ("openrdf:HTTPRepository".equals(memberRepoType) ? HTTPRepositorySchema.REPOSITORYURL : ProxyRepositorySchema.PROXIED_ID);
        return predicate;
    }

    private Value getMemberLocator(String identifier, RepositoryConnection con, String memberRepoType) throws MalformedURLException, RepositoryConfigException, OpenRDFException {
        Object locator = "openrdf:HTTPRepository".equals(memberRepoType) ? this.valueFactory.createURI(((HTTPRepositoryConfig)this.manager.getRepositoryConfig(identifier).getRepositoryImplConfig()).getURL()) : ("openrdf:SPARQLRepository".equals(memberRepoType) ? this.valueFactory.createURI(((SPARQLRepositoryConfig)this.manager.getRepositoryConfig(identifier).getRepositoryImplConfig()).getQueryEndpointUrl()) : this.valueFactory.createLiteral(identifier));
        return locator;
    }

    private static void addToGraph(Graph graph, Resource subject, URI predicate, Value object) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(subject + " " + predicate + " " + object);
        }
        graph.add(subject, predicate, object, new Resource[0]);
    }
}

