/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model.providers;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

@FunctionalInterface
public interface DatatypeProvider
extends Serializable {
    public OWLDatatype getOWLDatatype(IRI var1);

    default public OWLDatatype getOWLDatatype(HasIRI iri) {
        return this.getOWLDatatype(iri.getIRI());
    }

    default public OWLDatatype getOWLDatatype(String iri) {
        return this.getOWLDatatype(IRI.create(iri));
    }

    default public OWLDatatype getOWLDatatype(String namespace, @Nullable String remainder) {
        return this.getOWLDatatype(IRI.create(namespace, remainder));
    }

    default public OWLDatatype getOWLDatatype(String abbreviatedIRI, PrefixManager prefixManager) {
        OWLAPIPreconditions.checkNotNull(abbreviatedIRI, "abbreviatedIRI cannot be null");
        OWLAPIPreconditions.checkNotNull(prefixManager, "prefixManager cannot be null");
        return this.getOWLDatatype(prefixManager.getIRI(abbreviatedIRI));
    }
}

