/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import java.util.ArrayList;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.inject.Provider;
import org.semanticweb.owlapi.annotations.OwlapiModule;
import org.semanticweb.owlapi.io.OWLParser;
import org.semanticweb.owlapi.io.OWLParserFactory;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyManagerFactory;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLStorer;
import org.semanticweb.owlapi.model.OWLStorerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OwlapiModule
public class OWLAPIServiceLoaderModule
extends AbstractModule {
    private static Logger logger = LoggerFactory.getLogger(OWLAPIServiceLoaderModule.class);

    protected void configure() {
        this.loadInstancesFromServiceLoader(OWLParser.class);
        this.loadInstancesFromServiceLoader(OWLStorer.class);
        this.loadInstancesFromServiceLoader(OWLOntologyFactory.class);
        this.loadInstancesFromServiceLoader(OWLOntologyIRIMapper.class);
        this.loadFactories(OWLDocumentFormatFactory.class, OWLDocumentFormat.class);
        this.loadFactories(OWLParserFactory.class, OWLParser.class);
        this.loadFactories(OWLStorerFactory.class, OWLStorer.class);
        this.loadOntologyManagerFactory();
    }

    protected <T> void loadInstancesFromServiceLoader(Class<T> type) {
        try {
            Multibinder binder = Multibinder.newSetBinder((Binder)this.binder(), type);
            this.load(type).forEach(o -> binder.addBinding().toInstance(o));
        }
        catch (ServiceConfigurationError e) {
            throw new OWLRuntimeException("Injection failed for " + type, e);
        }
    }

    protected <T> Iterable<T> load(Class<T> type) {
        ArrayList result = new ArrayList();
        try {
            ServiceLoader.load(type).forEach(result::add);
        }
        catch (ServiceConfigurationError e) {
            logger.debug("ServiceLoading: ", (Throwable)e);
        }
        if (result.isEmpty()) {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            ServiceLoader.load(type, classLoader).forEach(result::add);
        }
        return result;
    }

    protected <T, F extends Provider<T>> void loadFactories(Class<F> factory, Class<T> type) {
        try {
            Multibinder factoryBinder = Multibinder.newSetBinder((Binder)this.binder(), factory);
            Multibinder binder = Multibinder.newSetBinder((Binder)this.binder(), type);
            this.load(factory).forEach(o -> {
                factoryBinder.addBinding().toInstance(o);
                binder.addBinding().toInstance(o.get());
            });
        }
        catch (ServiceConfigurationError e) {
            throw new OWLRuntimeException("Injection failed for factory: " + factory + " type: " + type, e);
        }
    }

    protected void loadOntologyManagerFactory() {
        try {
            Multibinder binder = Multibinder.newSetBinder((Binder)this.binder(), OWLOntologyManagerFactory.class);
            this.load(OWLOntologyManagerFactory.class).forEach(o -> binder.addBinding().toInstance(o));
        }
        catch (ServiceConfigurationError e) {
            throw new OWLRuntimeException("Injection failed for OWLOntologyManager factory", e);
        }
    }
}

