/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.striterator;

import com.bigdata.btree.BTree;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.NOPTupleSerializer;
import com.bigdata.btree.keys.ASCIIKeyBuilderFactory;
import com.bigdata.btree.keys.KVO;
import com.bigdata.journal.IIndexManager;
import com.bigdata.striterator.IChunkConverter;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.util.BytesUtil;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.UUID;

public abstract class DistinctFilter<E>
implements IChunkConverter<E, E> {
    private final IIndexManager indexManager;
    private BTree btree = null;

    public DistinctFilter(IIndexManager indexManager) {
        if (indexManager == null) {
            throw new IllegalArgumentException();
        }
        this.indexManager = indexManager;
    }

    @Override
    public E[] convert(IChunkedOrderedIterator<E> src) {
        Object[] tmp;
        int j;
        if (src == null) {
            throw new IllegalArgumentException();
        }
        E[] chunk = src.nextChunk();
        boolean exhausted = !src.hasNext();
        int n = chunk.length;
        Object[] a = new KVO[n];
        for (int i = 0; i < n; ++i) {
            Object e = chunk[i];
            a[i] = new KVO(this.getSortKey(e), null, e);
        }
        Arrays.sort(a);
        if (this.btree == null && exhausted) {
            j = 0;
            tmp = (Object[])Array.newInstance(chunk.getClass().getComponentType(), n);
            tmp[j++] = ((KVO)a[0]).obj;
            for (int i = 1; i < n; ++i) {
                if (BytesUtil.bytesEqual((byte[])((KVO)a[i - 1]).key, (byte[])((KVO)a[i]).key)) continue;
                tmp[j++] = ((KVO)a[i]).obj;
            }
            if (j != n) {
                Object[] tmp2 = (Object[])Array.newInstance(tmp.getClass().getComponentType(), j);
                System.arraycopy(tmp, 0, tmp2, 0, j);
                return tmp2;
            }
            return tmp;
        }
        if (this.btree == null) {
            IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
            metadata.setTupleSerializer(new NOPTupleSerializer(new ASCIIKeyBuilderFactory(0)));
            this.btree = BTree.create(this.indexManager.getTempStore(), metadata);
        }
        j = 0;
        tmp = (Object[])Array.newInstance(chunk.getClass().getComponentType(), n);
        for (int i = 0; i < n; ++i) {
            if (this.btree.contains(((KVO)a[i]).key)) continue;
            this.btree.insert(((KVO)a[i]).key, null);
            tmp[j++] = ((KVO)a[i]).obj;
        }
        if (j != n) {
            Object[] tmp2 = (Object[])Array.newInstance(chunk.getClass().getComponentType(), j);
            System.arraycopy(tmp, 0, tmp2, 0, j);
            return tmp2;
        }
        return tmp;
    }

    protected abstract byte[] getSortKey(E var1);
}

