/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.sparse;

import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.btree.keys.IKeyBuilderFactory;
import com.bigdata.io.SerializerUtil;
import com.bigdata.sparse.TPS;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class TPSTupleSerializer
extends DefaultTupleSerializer<Void, TPS> {
    private static final long serialVersionUID = -2467715806323261423L;
    private static final transient byte VERSION0 = 0;
    private static final transient byte VERSION = 0;

    public static ITupleSerializer<Void, TPS> newInstance() {
        return new TPSTupleSerializer(TPSTupleSerializer.getDefaultKeyBuilderFactory());
    }

    public TPSTupleSerializer() {
    }

    public TPSTupleSerializer(IKeyBuilderFactory keyBuilderFactory) {
        super(keyBuilderFactory);
    }

    @Override
    public byte[] serializeKey(Object obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] serializeVal(TPS obj) {
        return SerializerUtil.serialize(obj);
    }

    @Override
    public TPS deserialize(ITuple tuple) {
        return (TPS)SerializerUtil.deserialize(tuple.getValue());
    }

    @Override
    public Void deserializeKey(ITuple tuple) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte version = in.readByte();
        switch (version) {
            case 0: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown version: " + version);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(0);
    }
}

