/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.proxy;

import com.bigdata.service.proxy.RemoteFuture;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ClientFuture<T>
implements Future<T>,
Serializable {
    protected static final transient Logger log = Logger.getLogger(ClientFuture.class);
    private static final long serialVersionUID = -910518634373204705L;
    private final RemoteFuture<T> proxy;
    private volatile transient boolean done = false;

    public ClientFuture(RemoteFuture<T> proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException();
        }
        this.proxy = proxy;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.done) {
            return false;
        }
        try {
            return this.proxy.cancel(mayInterruptIfRunning);
        }
        catch (ConnectException ex) {
            if (log.isEnabledFor((Priority)Level.WARN)) {
                log.warn((Object)ex.getLocalizedMessage());
            }
            return false;
        }
        catch (NoSuchObjectException ex) {
            if (log.isEnabledFor((Priority)Level.WARN)) {
                log.warn((Object)ex.getLocalizedMessage());
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            T t = this.proxy.get();
            this.done = true;
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            T t = this.proxy.get(timeout, unit);
            this.done = true;
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isCancelled() {
        try {
            boolean t = this.proxy.isCancelled();
            if (t) {
                this.done = true;
            }
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isDone() {
        try {
            if (this.done) {
                return this.done;
            }
            this.done = this.proxy.isDone();
            return this.done;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

