/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.proc.RangeCountProcedure;
import com.bigdata.mdi.IMetadataIndex;
import com.bigdata.mdi.MetadataIndex;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.service.AbstractScaleOutFederation;
import com.bigdata.service.IMetadataService;
import com.bigdata.service.MetadataService;
import com.bigdata.service.ndx.RawDataServiceTupleIterator;
import cutthecrap.utils.striterators.IFilter;

public class NoCacheMetadataIndexView
implements IMetadataIndex {
    private final AbstractScaleOutFederation fed;
    private final String name;
    private final long timestamp;
    private final MetadataIndex.MetadataIndexMetadata mdmd;

    @Override
    public MetadataIndex.MetadataIndexMetadata getIndexMetadata() {
        return this.mdmd;
    }

    protected IMetadataService getMetadataService() {
        return this.fed.getMetadataService();
    }

    public NoCacheMetadataIndexView(AbstractScaleOutFederation fed, String name, long timestamp, MetadataIndex.MetadataIndexMetadata mdmd) {
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (mdmd == null) {
            throw new IllegalArgumentException();
        }
        this.fed = fed;
        this.name = name;
        this.timestamp = timestamp;
        this.mdmd = mdmd;
    }

    @Override
    public IndexMetadata getScaleOutIndexMetadata() {
        return this.mdmd;
    }

    @Override
    public PartitionLocator get(byte[] key) {
        try {
            return this.getMetadataService().get(this.name, this.timestamp, key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PartitionLocator find(byte[] key) {
        try {
            return this.getMetadataService().find(this.name, this.timestamp, key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long rangeCount() {
        return this.rangeCount(null, null);
    }

    @Override
    public long rangeCount(byte[] fromKey, byte[] toKey) {
        Long rangeCount;
        RangeCountProcedure proc = new RangeCountProcedure(false, false, fromKey, toKey);
        try {
            rangeCount = this.getMetadataService().submit(this.timestamp, MetadataService.getMetadataIndexName(this.name), proc).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return rangeCount;
    }

    @Override
    public long rangeCountExact(byte[] fromKey, byte[] toKey) {
        Long rangeCount;
        RangeCountProcedure proc = new RangeCountProcedure(true, false, fromKey, toKey);
        try {
            rangeCount = this.getMetadataService().submit(this.timestamp, MetadataService.getMetadataIndexName(this.name), proc).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return rangeCount;
    }

    @Override
    public long rangeCountExactWithDeleted(byte[] fromKey, byte[] toKey) {
        Long rangeCount;
        RangeCountProcedure proc = new RangeCountProcedure(true, true, fromKey, toKey);
        try {
            rangeCount = this.getMetadataService().submit(this.timestamp, MetadataService.getMetadataIndexName(this.name), proc).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return rangeCount;
    }

    @Override
    public ITupleIterator rangeIterator() {
        return this.rangeIterator(null, null);
    }

    @Override
    public ITupleIterator rangeIterator(byte[] fromKey, byte[] toKey) {
        return this.rangeIterator(fromKey, toKey, 0, 3, null);
    }

    @Override
    public ITupleIterator rangeIterator(byte[] fromKey, byte[] toKey, int capacity, int flags, IFilter filter) {
        return new RawDataServiceTupleIterator(this.getMetadataService(), MetadataService.getMetadataIndexName(this.name), this.timestamp == 0L ? -1L : this.timestamp, true, fromKey, toKey, capacity, flags, filter);
    }

    @Override
    public void staleLocator(PartitionLocator locator) {
    }
}

