/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.search;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.SuccessorUtil;
import com.bigdata.search.FullTextIndex;
import org.apache.log4j.Logger;

public abstract class AbstractIndexTask<V extends Comparable<V>> {
    private static final Logger log = Logger.getLogger(AbstractIndexTask.class);
    protected final String queryTerm;
    protected final int queryTermNdx;
    protected final int numQueryTerms;
    protected final double queryTermWeight;
    protected final byte[] fromKey;
    protected final byte[] toKey;

    public AbstractIndexTask(String termText, int termNdx, int numTerms, boolean prefixMatch, double queryTermWeight, FullTextIndex<V> searchEngine) {
        if (termText == null) {
            throw new IllegalArgumentException();
        }
        if (searchEngine == null) {
            throw new IllegalArgumentException();
        }
        this.queryTerm = termText;
        this.queryTermNdx = termNdx;
        this.numQueryTerms = numTerms;
        this.queryTermWeight = queryTermWeight;
        IKeyBuilder keyBuilder = searchEngine.getIndex().getIndexMetadata().getKeyBuilder();
        keyBuilder.reset();
        keyBuilder.appendText(termText, true, false);
        byte[] tmp = keyBuilder.getKey();
        if (prefixMatch) {
            this.fromKey = new byte[tmp.length - 3];
            System.arraycopy(tmp, 0, this.fromKey, 0, this.fromKey.length);
        } else {
            this.fromKey = tmp;
        }
        this.toKey = SuccessorUtil.successor((byte[])this.fromKey.clone());
    }
}

