/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.BTree;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.ScatterSplitConfiguration;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure;
import com.bigdata.btree.proc.BatchLookup;
import com.bigdata.io.SerializerUtil;
import com.bigdata.journal.AbstractTask;
import com.bigdata.journal.IConcurrencyManager;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.mdi.SegmentMetadata;
import com.bigdata.resources.AbstractAtomicUpdateTask;
import com.bigdata.resources.AbstractPrepareTask;
import com.bigdata.resources.BuildResult;
import com.bigdata.resources.JoinIndexPartitionTask;
import com.bigdata.resources.MoveTask;
import com.bigdata.resources.OverflowActionEnum;
import com.bigdata.resources.OverflowManager;
import com.bigdata.resources.OverflowSubtaskEnum;
import com.bigdata.resources.ResourceManager;
import com.bigdata.resources.ScatterSplitTask;
import com.bigdata.resources.SplitIndexPartitionTask;
import com.bigdata.resources.ViewMetadata;
import com.bigdata.service.DataService;
import com.bigdata.service.Event;
import com.bigdata.service.EventResource;
import com.bigdata.service.ILoadBalancerService;
import com.bigdata.service.MetadataService;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.TimeoutException;

public class CompactingMergeTask
extends AbstractPrepareTask<BuildResult> {
    protected final ViewMetadata vmd;

    public CompactingMergeTask(ViewMetadata vmd) {
        super(vmd.resourceManager, TimestampUtility.asHistoricalRead(vmd.commitTime), vmd.name);
        this.vmd = vmd;
    }

    @Override
    protected void clearRefs() {
        this.vmd.clearRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BuildResult doTask() throws Exception {
        Event e = new Event(this.resourceManager.getFederation(), new EventResource(this.vmd.indexMetadata), (Object)OverflowActionEnum.Merge, this.vmd.getParams()).start();
        BuildResult buildResult = null;
        try {
            try {
                if (this.resourceManager.isOverflowAllowed()) {
                    throw new IllegalStateException();
                }
                buildResult = this.resourceManager.buildIndexSegment(this.vmd.name, this.vmd.getView(), true, this.vmd.commitTime, null, null, e);
            }
            finally {
                this.clearRefs();
            }
            if (buildResult.builder.getCheckpoint().length >= this.resourceManager.nominalShardSize) {
                // empty if block
            }
            try {
                UUID indexUUID = this.vmd.indexMetadata.getIndexUUID();
                this.concurrencyManager.submit(new AtomicUpdateCompactingMergeTask(this.resourceManager, this.concurrencyManager, this.vmd.name, indexUUID, buildResult, e.newSubEvent((Object)OverflowSubtaskEnum.AtomicUpdate, this.vmd.getParams()))).get();
            }
            catch (Throwable t) {
                this.resourceManager.retentionSetRemove(buildResult.segmentMetadata.getUUID());
                this.resourceManager.deleteResource(buildResult.segmentMetadata.getUUID(), false);
                throw new Exception(t);
            }
            this.resourceManager.getClass();
            AbstractTask<?> afterActionTask = this.chooseAfterActionTask();
            if (afterActionTask != null) {
                afterActionTask.call();
            }
            BuildResult buildResult2 = buildResult;
            return buildResult2;
        }
        finally {
            if (buildResult != null) {
                this.resourceManager.retentionSetRemove(buildResult.segmentMetadata.getUUID());
            }
            e.end();
        }
    }

    private AbstractTask<?> chooseAfterActionTask() {
        UUID sourceServiceUUID;
        UUID targetDataServiceUUID;
        UUID[] moveTargets;
        ViewMetadata vmd = new ViewMetadata(this.resourceManager, this.resourceManager.getLiveJournal().getLastCommitTime(), this.vmd.name, this.resourceManager.getIndexCounters(this.vmd.name));
        ScatterSplitConfiguration ssc = vmd.indexMetadata.getScatterSplitConfiguration();
        if (vmd.getIndexPartitionCount() == 1L && this.resourceManager.scatterSplitEnabled && ssc.isEnabled() && vmd.compactView && vmd.getPercentOfSplit() >= ssc.getPercentOfSplitThreshold() && (moveTargets = this.getScatterSplitTargets(ssc)) != null) {
            int nsplits;
            int n = nsplits = ssc.getIndexPartitionCount() == 0 ? 2 * moveTargets.length : ssc.getIndexPartitionCount();
            if (log.isInfoEnabled()) {
                log.info((Object)("will scatter: " + vmd));
            }
            return new ScatterSplitTask(vmd, nsplits, moveTargets);
        }
        if (vmd.isTailSplit()) {
            // empty if block
        }
        if (vmd.getPercentOfSplit() > 1.0) {
            if (log.isInfoEnabled()) {
                log.info((Object)("will split  : " + vmd));
            }
            return new SplitIndexPartitionTask(vmd, (UUID)null);
        }
        if (this.resourceManager.joinsEnabled && vmd.pmd.getRightSeparatorKey() != null) {
            String scaleOutIndexName;
            PartitionLocator rightSiblingLocator;
            double d = vmd.getPercentOfSplit();
            this.resourceManager.getClass();
            if (d < 0.4 && (rightSiblingLocator = this.getRightSiblingLocator(scaleOutIndexName = vmd.indexMetadata.getName(), vmd.commitTime)) != null) {
                UUID targetDataServiceUUID2 = rightSiblingLocator.getDataServiceUUID();
                Object[] resources = new String[]{DataService.getIndexPartitionName(scaleOutIndexName, vmd.pmd.getPartitionId()), DataService.getIndexPartitionName(scaleOutIndexName, rightSiblingLocator.getPartitionId())};
                if (this.resourceManager.getDataServiceUUID().equals(targetDataServiceUUID2)) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Will JOIN: " + Arrays.toString(resources)));
                    }
                    String rightSiblingName = DataService.getIndexPartitionName(scaleOutIndexName, rightSiblingLocator.getPartitionId());
                    ViewMetadata vmd2 = new ViewMetadata(this.resourceManager, vmd.commitTime, rightSiblingName, this.resourceManager.getIndexCounters(rightSiblingName));
                    return new JoinIndexPartitionTask(this.resourceManager, vmd.commitTime, (String[])resources, new ViewMetadata[]{vmd, vmd2});
                }
                if (log.isInfoEnabled()) {
                    String targetDataServiceName;
                    try {
                        targetDataServiceName = this.resourceManager.getFederation().getDataService(targetDataServiceUUID2).getServiceName();
                    }
                    catch (Throwable t) {
                        targetDataServiceName = targetDataServiceUUID2.toString();
                    }
                    log.info((Object)("willMoveToJoinWithRightSibling( " + vmd.name + " -> " + targetDataServiceName + ", leftSibling=" + (String)resources[0] + ", rightSibling=" + (String)resources[1] + ")"));
                }
                return new MoveTask(vmd, targetDataServiceUUID2);
            }
        }
        ILoadBalancerService loadBalancerService = null;
        if (vmd.getPercentOfSplit() < this.resourceManager.maximumMovePercentOfSplit && this.resourceManager.maximumMovesPerTarget != 0 && this.resourceManager.getLiveJournal().getName2Addr().rangeCount() > (long)this.resourceManager.minimumActiveIndexPartitions && (loadBalancerService = this.getLoadBalancerService()) != null && this.shouldMove(loadBalancerService) && (targetDataServiceUUID = this.getMoveTarget(sourceServiceUUID = this.resourceManager.getDataServiceUUID(), loadBalancerService)) != null) {
            if (log.isInfoEnabled()) {
                String targetDataServiceName;
                try {
                    targetDataServiceName = this.resourceManager.getFederation().getDataService(targetDataServiceUUID).getServiceName();
                }
                catch (Throwable t) {
                    targetDataServiceName = targetDataServiceUUID.toString();
                }
                log.info((Object)("willMove( " + vmd.name + " -> " + targetDataServiceName + ")"));
            }
            return new MoveTask(vmd, targetDataServiceUUID);
        }
        return null;
    }

    private ILoadBalancerService getLoadBalancerService() {
        ILoadBalancerService loadBalancerService;
        try {
            loadBalancerService = this.resourceManager.getFederation().getLoadBalancerService();
        }
        catch (Exception ex) {
            log.warn((Object)"Could not discover the load balancer service", (Throwable)ex);
            return null;
        }
        if (loadBalancerService == null) {
            log.warn((Object)"Could not discover the load balancer service");
            return null;
        }
        return loadBalancerService;
    }

    protected boolean shouldMove(ILoadBalancerService loadBalancerService) {
        boolean highlyUtilizedService;
        if (loadBalancerService == null) {
            throw new IllegalArgumentException();
        }
        try {
            UUID serviceUUID = this.resourceManager.getDataServiceUUID();
            highlyUtilizedService = loadBalancerService.isHighlyUtilizedDataService(serviceUUID);
        }
        catch (Exception ex) {
            log.warn((Object)"Could not determine if this data service is highly utilized");
            return false;
        }
        if (!highlyUtilizedService) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Service is not highly utilized.");
            }
            return false;
        }
        OverflowManager.ResourceScores resourceScores = this.resourceManager.getResourceScores();
        boolean shouldMove = resourceScores.percentCPUTime >= this.resourceManager.movePercentCpuTimeThreshold || resourceScores.majorPageFaultsPerSec > 20.0 || resourceScores.dataDirBytesFree < 5.36870912E9 || resourceScores.dataDirBytesFree < 5.36870912E8;
        return shouldMove;
    }

    private UUID getMoveTarget(UUID sourceServiceUUID, ILoadBalancerService loadBalancerService) {
        try {
            UUID[] uuids = loadBalancerService.getUnderUtilizedDataServices(0, 1, sourceServiceUUID);
            if (uuids != null && uuids.length > 0) {
                return uuids[0];
            }
            return null;
        }
        catch (TimeoutException t) {
            log.warn((Object)t.getMessage());
            return null;
        }
        catch (InterruptedException t) {
            log.warn((Object)t.getMessage());
            return null;
        }
        catch (Throwable t) {
            log.error((Object)"Could not obtain target service UUIDs: ", t);
            return null;
        }
    }

    private PartitionLocator getRightSiblingLocator(String scaleOutIndexName, long lastCommitTime) {
        AbstractKeyArrayIndexProcedure.ResultBuffer resultBuffer;
        BatchLookup op = (BatchLookup)BatchLookup.BatchLookupConstructor.INSTANCE.newInstance(0, 1, new byte[][]{this.vmd.pmd.getRightSeparatorKey()}, null);
        try {
            resultBuffer = this.resourceManager.getFederation().getMetadataService().submit(TimestampUtility.asHistoricalRead(lastCommitTime), MetadataService.getMetadataIndexName(scaleOutIndexName), op).get();
        }
        catch (Exception e) {
            log.error((Object)("Could not locate rightSiblings: index=" + scaleOutIndexName), (Throwable)e);
            return null;
        }
        return (PartitionLocator)SerializerUtil.deserialize(resultBuffer.getValues().get(0));
    }

    private UUID[] getScatterSplitTargets(ScatterSplitConfiguration ssc) {
        UUID[] a = this.resourceManager.getFederation().getDataServiceUUIDs(ssc.getDataServiceCount());
        if (a == null || a.length == 1) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Will not scatter split - insufficient data services discovered.");
            }
            return null;
        }
        HashSet<UUID> tmp = new HashSet<UUID>(Arrays.asList(a));
        tmp.add(this.resourceManager.getDataServiceUUID());
        return tmp.toArray(new UUID[tmp.size()]);
    }

    protected static class AtomicUpdateCompactingMergeTask
    extends AbstractAtomicUpdateTask<Void> {
        private final Event updateEvent;
        protected final UUID indexUUID;
        protected final BuildResult buildResult;

        public AtomicUpdateCompactingMergeTask(ResourceManager resourceManager, IConcurrencyManager concurrencyManager, String resource, UUID indexUUID, BuildResult buildResult, Event updateEvent) {
            super(resourceManager, 0L, resource);
            if (indexUUID == null) {
                throw new IllegalArgumentException();
            }
            if (buildResult == null) {
                throw new IllegalArgumentException();
            }
            if (!buildResult.compactingMerge) {
                throw new IllegalArgumentException();
            }
            if (!resource.equals(buildResult.name)) {
                throw new IllegalArgumentException();
            }
            if (updateEvent == null) {
                throw new IllegalArgumentException();
            }
            this.indexUUID = indexUUID;
            this.buildResult = buildResult;
            this.updateEvent = updateEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Void doTask() throws Exception {
            this.updateEvent.start();
            try {
                if (this.resourceManager.isOverflowAllowed()) {
                    throw new IllegalStateException();
                }
                SegmentMetadata segmentMetadata = this.buildResult.segmentMetadata;
                if (INFO) {
                    log.info((Object)("Begin: name=" + this.getOnlyResource() + ", newSegment=" + segmentMetadata));
                }
                ILocalBTreeView view = this.getIndex(this.getOnlyResource());
                this.assertSameIndex(this.indexUUID, view.getMutableBTree());
                if (view instanceof BTree) {
                    throw new RuntimeException("View is only a B+Tree: name=" + this.buildResult.name + ", pmd=" + view.getIndexMetadata().getPartitionMetadata());
                }
                BTree btree = view.getMutableBTree();
                if (INFO) {
                    log.info((Object)("src=" + this.getOnlyResource() + ",counter=" + view.getCounter().get() + ",checkpoint=" + btree.getCheckpoint()));
                }
                assert (btree != null) : "Expecting index: " + this.getOnlyResource();
                IndexMetadata indexMetadata = btree.getIndexMetadata().clone();
                LocalPartitionMetadata currentpmd = indexMetadata.getPartitionMetadata();
                IResourceMetadata[] currentResources = currentpmd.getResources();
                if (currentpmd == null) {
                    throw new IllegalStateException("Not an index partition: " + this.getOnlyResource());
                }
                if (!currentResources[0].getUUID().equals(this.getJournal().getRootBlockView().getUUID())) {
                    throw new IllegalStateException("Expecting live journal to be the first resource: " + currentResources);
                }
                assert (segmentMetadata.getCreateTime() < this.getJournal().getRootBlockView().getFirstCommitTime()) : "segment createTime LT journal 1st commit time: segmentMetadata=" + segmentMetadata + ", journal: " + this.getJournal().getRootBlockView();
                IResourceMetadata[] newResources = new IResourceMetadata[]{this.getJournal().getResourceMetadata(), segmentMetadata};
                indexMetadata.setPartitionMetadata(new LocalPartitionMetadata(currentpmd.getPartitionId(), currentpmd.getSourcePartitionId(), currentpmd.getLeftSeparatorKey(), currentpmd.getRightSeparatorKey(), newResources, currentpmd.getIndexPartitionCause()));
                btree.setIndexMetadata(indexMetadata);
                if (INFO) {
                    log.info((Object)("Updated view: name=" + this.getOnlyResource() + ", pmd=" + indexMetadata.getPartitionMetadata()));
                }
                assert (btree.needsCheckpoint());
                this.resourceManager.overflowCounters.indexPartitionMergeCounter.incrementAndGet();
                Void void_ = null;
                return void_;
            }
            finally {
                this.updateEvent.end();
            }
        }
    }
}

