/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.accesspath;

import com.bigdata.bop.IPredicate;
import com.bigdata.btree.IIndex;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.striterator.ChunkedArrayIterator;
import com.bigdata.striterator.ChunkedWrappedIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import java.lang.reflect.Array;
import java.util.Collections;

public class ArrayAccessPath<E>
implements IAccessPath<E> {
    private final IPredicate<E> predicate;
    private final IKeyOrder<E> keyOrder;
    private final E[] e;

    public ArrayAccessPath(E[] e) {
        this(e, null, null);
    }

    public ArrayAccessPath(E[] e, IPredicate<E> predicate, IKeyOrder<E> keyOrder) {
        this.predicate = predicate;
        this.keyOrder = keyOrder;
        this.e = e;
    }

    @Override
    public IPredicate<E> getPredicate() {
        if (this.predicate == null) {
            throw new UnsupportedOperationException();
        }
        return this.predicate;
    }

    @Override
    public IKeyOrder<E> getKeyOrder() {
        if (this.keyOrder == null) {
            throw new UnsupportedOperationException();
        }
        return this.keyOrder;
    }

    @Override
    public IIndex getIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.e.length == 0;
    }

    @Override
    public long rangeCount(boolean exact) {
        return this.e.length;
    }

    @Override
    public IChunkedOrderedIterator<E> iterator() {
        return this.iterator(0L, 0L, 0);
    }

    @Override
    public IChunkedOrderedIterator<E> iterator(long offset, long limit, int capacity) {
        if (offset < 0L) {
            throw new IllegalArgumentException();
        }
        if (offset > (long)this.e.length || this.e.length == 0) {
            return new ChunkedWrappedIterator(Collections.EMPTY_LIST.iterator());
        }
        if (limit >= Long.MAX_VALUE) {
            limit = 0L;
        }
        if (limit >= offset + (long)this.e.length) {
            limit = 0L;
        }
        int n = limit == 0L ? this.e.length - (int)offset : Math.min((int)limit, this.e.length - (int)offset);
        if (offset == 0L && n == this.e.length) {
            return new ChunkedArrayIterator<E>(this.e);
        }
        Object[] a = (Object[])Array.newInstance(this.e.getClass().getComponentType(), n);
        System.arraycopy(this.e, (int)offset, a, 0, n);
        return new ChunkedArrayIterator<Object>(a);
    }

    @Override
    public long removeAll() {
        return 0L;
    }
}

