/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.Banner;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.Journal;
import com.bigdata.journal.Options;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class RebuildTextIndex {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String propertyFileName;
        Properties properties;
        File journal;
        String arg;
        int i;
        Banner.banner();
        String namespace = null;
        boolean forceCreate = false;
        for (i = 0; i < args.length && (arg = args[i]).startsWith("-"); ++i) {
            if (arg.equals("-namespace")) {
                namespace = args[++i];
                continue;
            }
            if (arg.equals("-forceCreate")) {
                forceCreate = true;
                continue;
            }
            System.err.println("Unknown argument: " + arg);
            RebuildTextIndex.usage();
        }
        int remaining = args.length - i;
        if (remaining < 1) {
            System.err.println("Not enough arguments.");
            RebuildTextIndex.usage();
        }
        if ((journal = new File((properties = RebuildTextIndex.processProperties(propertyFileName = args[i++])).getProperty(Options.FILE))).exists()) {
            System.out.println("Journal: " + properties.getProperty(Options.FILE));
            try (AbstractJournal jnl = null;){
                jnl = new Journal(properties);
                System.out.println("Rebuild text index:");
                if (namespace == null) {
                    List<String> namespaces = ((Journal)jnl).getGlobalRowStore().getNamespaces(jnl.getLastCommitTime());
                    for (String nm : namespaces) {
                        AbstractTripleStore kb = (AbstractTripleStore)((Journal)jnl).getResourceLocator().locate(nm, 0L);
                        if (kb.getLexiconRelation().isTextIndex()) {
                            kb.getLexiconRelation().rebuildTextIndex(false);
                            System.out.println(nm + " - completed");
                            continue;
                        }
                        System.out.println(nm + " -  no text index");
                    }
                }
                AbstractTripleStore kb = (AbstractTripleStore)((Journal)jnl).getResourceLocator().locate(namespace, 0L);
                if (kb != null) {
                    kb.getLexiconRelation().rebuildTextIndex(forceCreate);
                    System.out.println(namespace + " - completed");
                }
                System.err.println("Namespace " + namespace + " does not exist");
            }
        } else {
            System.err.println("Journal " + journal + " does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties processProperties(String propertyFileName) throws IOException {
        File propertyFile = new File(propertyFileName);
        if (!propertyFile.exists()) {
            throw new FileNotFoundException(propertyFile.toString());
        }
        Properties properties = new Properties();
        try (FileInputStream is = new FileInputStream(propertyFile);){
            properties.load(is);
        }
        return properties;
    }

    private static void usage() {
        System.err.println("usage: [-namespace namespace] [-forceCreate] propertyFile");
        System.exit(1);
    }
}

