/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.btree.ITuple;
import com.bigdata.btree.filter.Advancer;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.keys.SuccessorUtil;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.spo.SPO;

public class DistinctMultiTermAdvancer
extends Advancer<SPO> {
    private static final long serialVersionUID = -7326621294779476500L;
    private final int arity;
    private final int boundEntries;
    private transient IKeyBuilder keyBuilder;

    public DistinctMultiTermAdvancer(int arity, int boundEntries) {
        this.arity = arity;
        this.boundEntries = boundEntries;
    }

    @Override
    protected void advance(ITuple<SPO> tuple) {
        if (this.keyBuilder == null) {
            this.keyBuilder = KeyBuilder.newInstance();
        }
        byte[] key = tuple.getKey();
        IV[] ivs = IVUtility.decode(key, this.boundEntries + 1);
        this.keyBuilder.reset();
        for (int i = 0; i < ivs.length; ++i) {
            ivs[i].encode(this.keyBuilder);
        }
        byte[] fromKey = this.keyBuilder.getKey();
        byte[] toKey = SuccessorUtil.successor((byte[])fromKey.clone());
        this.src.seek(toKey);
    }
}

