/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.engine.StaticAnalysisStats;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class ASTOptimizerList
extends LinkedList<IASTOptimizer>
implements IASTOptimizer {
    private static final Logger log = Logger.getLogger(ASTOptimizerList.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final long serialVersionUID = 1L;

    public ASTOptimizerList(Collection<IASTOptimizer> c) {
        super(c);
    }

    public ASTOptimizerList(IASTOptimizer ... optimizers) {
        this((Collection<IASTOptimizer>)Arrays.asList(optimizers));
    }

    @Override
    public boolean add(IASTOptimizer opt) {
        if (opt == null) {
            throw new IllegalArgumentException();
        }
        if (opt == this) {
            throw new IllegalArgumentException();
        }
        return super.add(opt);
    }

    @Override
    public QueryNodeWithBindingSet optimize(AST2BOpContext context, QueryNodeWithBindingSet input) {
        StaticAnalysisStats saStats = context.getStaticAnalysisStats();
        long startLoop = System.nanoTime();
        IQueryNode queryNode = input.getQueryNode();
        IBindingSet[] bindingSets = input.getBindingSets();
        if (DEBUG) {
            log.debug((Object)("Original AST:\n" + queryNode));
        }
        QueryNodeWithBindingSet tmp = new QueryNodeWithBindingSet(BOpUtility.deepCopy(queryNode), bindingSets);
        for (IASTOptimizer opt : this) {
            long startOpt = System.nanoTime();
            if (INFO) {
                log.info((Object)("Applying: " + opt));
            }
            tmp = opt.optimize(context, tmp);
            if (queryNode == null) {
                throw new AssertionError((Object)("Optimized discarded query: " + opt));
            }
            if (DEBUG) {
                log.debug((Object)("Rewritten AST:\n" + tmp.getQueryNode()));
            }
            saStats.registerOptimizerCall(opt.getClass().getSimpleName(), System.nanoTime() - startOpt);
        }
        saStats.registerOptimizerLoopCall(System.nanoTime() - startLoop);
        return tmp;
    }
}

