/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.ConstructNode;
import com.bigdata.rdf.sparql.ast.DescribeModeEnum;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.LinkedHashSet;
import org.openrdf.model.vocabulary.RDF;

public class ASTDescribeOptimizer
implements IASTOptimizer {
    @Override
    public QueryNodeWithBindingSet optimize(AST2BOpContext context, QueryNodeWithBindingSet input) {
        BigdataURI rdfSubject;
        GraphPatternGroup where;
        IQueryNode queryNode = input.getQueryNode();
        IBindingSet[] bindingSet = input.getBindingSets();
        QueryRoot queryRoot = (QueryRoot)queryNode;
        if (queryRoot.getQueryType() != QueryType.DESCRIBE) {
            return new QueryNodeWithBindingSet(queryRoot, bindingSet);
        }
        queryRoot.setQueryType(QueryType.CONSTRUCT);
        if (queryRoot.hasWhereClause()) {
            if (queryRoot.getWhereClause() instanceof UnionNode) {
                where = new JoinGroupNode();
                where.addChild(queryRoot.getWhereClause());
                queryRoot.setWhereClause(where);
            } else {
                where = queryRoot.getWhereClause();
            }
        } else {
            where = new JoinGroupNode();
            queryRoot.setWhereClause(where);
        }
        UnionNode union = new UnionNode();
        where.addChild(union);
        ConstructNode construct = new ConstructNode(context);
        ProjectionNode projection = queryRoot.getProjection();
        if (projection == null) {
            throw new RuntimeException("No projection?");
        }
        DescribeModeEnum describeMode = context.getDescribeMode(projection);
        projection.setReduced(true);
        queryRoot.setConstruct(construct);
        LinkedHashSet<TermNode> terms = new LinkedHashSet<TermNode>();
        if (projection.isWildcard()) {
            throw new AssertionError((Object)"Wildcard projection was not rewritten.");
        }
        if (projection.isEmpty()) {
            throw new RuntimeException("DESCRIBE, but no variables are projected.");
        }
        for (AssignmentNode n : projection) {
            terms.add((TermNode)n.getValueExpressionNode());
        }
        if (describeMode.isForward() && describeMode.isReifiedStatements()) {
            AbstractTripleStore db = context.getAbstractTripleStore();
            BigdataURI tmp = db.getValueFactory().asValue(RDF.SUBJECT);
            db.getLexiconRelation().addTerms(new BigdataValue[]{tmp}, 1, true);
            if (tmp.getIV() == null) {
                rdfSubject = null;
            } else {
                rdfSubject = tmp;
                rdfSubject.getIV().setValue(rdfSubject);
            }
        } else {
            rdfSubject = null;
        }
        int i = 0;
        for (TermNode term : terms) {
            JoinGroupNode group;
            StatementPatternNode sp;
            int termNum = i++;
            if (describeMode.isForward()) {
                sp = new StatementPatternNode(term, new VarNode("p" + termNum + "a"), new VarNode("o" + termNum));
                construct.addChild(sp);
                group = new JoinGroupNode();
                group.addChild(sp);
                union.addChild(group);
            }
            if (describeMode.isReverse()) {
                sp = new StatementPatternNode(new VarNode("s" + termNum), new VarNode("p" + termNum + "b"), term);
                construct.addChild(sp);
                group = new JoinGroupNode();
                group.addChild(sp);
                union.addChild(group);
            }
            if (!describeMode.isForward() || !describeMode.isReifiedStatements()) continue;
            sp = new StatementPatternNode(new VarNode("stmt" + termNum), new ConstantNode(rdfSubject.getIV()), term);
            construct.addChild(sp);
            group = new JoinGroupNode();
            group.addChild(sp);
            union.addChild(group);
        }
        return new QueryNodeWithBindingSet(queryRoot, bindingSet);
    }
}

